/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import leb.util.exec.GeneralExecInfo;
import leb.util.exec.SimpleExecTemplate;

public class ProdigalWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private String inputFileName = null;
    private String outputFileName = null;

    public ProdigalWrapper(String prodigalPath) {
        super(prodigalPath);
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
        this.addArgument("-i", this.inputFileName);
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
        this.addArgument("-o", this.outputFileName);
    }

    public void setMode(String mode) {
        this.addArgument("-p", mode);
    }

    public void setOutputFormat(String format) {
        this.addArgument("-f", format);
    }

    public void setClosedEnds() {
        this.addArgument("-c");
    }

    public void setSkipMaskedSequence() {
        this.addArgument("-m");
    }

    public void setProteinFileName(String proteinFileName) {
        this.addArgument("-a", proteinFileName);
    }

    public void setNuclFileName(String nuclFileName) {
        this.addArgument("-d", nuclFileName);
    }

    public void setStartFileName(String startFileName) {
        this.addArgument("-s", startFileName);
    }

    public void setTrainingFileName(String trainingFileName) {
        this.addArgument("-t", trainingFileName);
    }

    public void setMetagenome() {
        this.addArgument("-p", "meta");
    }

    public void setTranslationTable(int table) {
        this.addArgument("-g", table);
    }

    public void setForceFullMotifScan() {
        this.addArgument("-n");
    }

    public void setQuietRun() {
        this.addArgument("-q");
    }

    @Override
    public String getVersion() {
        return "v2.6.2";
    }
}

