/*
 * Decompiled with CFR 0.152.
 */
package leb.uucgp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import leb.domain.DetectedGeneDomain;
import leb.domain.GeneSetByGenomeDomain;
import leb.seq.FastaSeq;
import leb.seq.FastaSeqList;
import leb.util.cli.Arguments;
import leb.wrapper.HmmSearchWrapper;
import leb.wrapper.ProdigalWrapper;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcFindUucgpByGenome {
    private String contigFile = null;
    private String cdsProFile = null;
    private String cdsNucFile = null;
    private String ucgDirectory = null;
    private String hmmProfilePath = null;
    private String prodigalPath = null;
    private String hmmSearchPath = null;
    private HashMap<String, String> parameters = null;

    public ProcFindUucgpByGenome(String[] params, HashMap<String, String> programPath) {
        this.parameters = this.paramsHashMap(params);
        this.ucgDirectory = this.parameters.get("-ucg_dir");
        this.hmmProfilePath = this.parameters.get("-hmm");
        this.prodigalPath = programPath.get("prodigal");
        this.hmmSearchPath = programPath.get("hmmsearch");
        this.validateUcgDir();
    }

    private void validateUcgDir() {
        File ucgDir;
        File ucgParDir;
        if (!this.ucgDirectory.endsWith(File.separator)) {
            this.ucgDirectory = String.valueOf(this.ucgDirectory) + File.separator;
        }
        if (!(ucgParDir = new File((ucgDir = new File(this.ucgDirectory)).getAbsoluteFile().getParent())).canWrite()) {
            System.err.println("Error : Cannot write in the directory " + ucgParDir.getAbsolutePath());
            System.exit(1);
        }
        if (!ucgDir.exists()) {
            ucgDir.mkdir();
        }
    }

    private HashMap<String, String> paramsHashMap(String[] parameters) {
        HashMap<String, String> params = new HashMap<String, String>();
        Arguments arg = new Arguments(parameters);
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.startsWith("-") && arg.get(option) != null) {
                params.put(option, arg.get(option));
            }
            ++n2;
        }
        return params;
    }

    private void validateFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            System.err.println("There is no file " + filePath + ".");
            System.err.println("Exit.");
            System.exit(1);
        }
    }

    void cdsToJsonOnlyProtein() {
        this.validateFile(this.cdsProFile);
        File file = new File(this.cdsProFile);
        String path = String.valueOf(file.getAbsoluteFile().getParent()) + File.separator;
        String label = this.parameters.get("-label");
        label = label.replaceAll(" ", "_");
        String ucgFile = String.valueOf(this.ucgDirectory) + label + ".ucg";
        this.checkResultFileAlreadyExist(ucgFile);
        String hmmResultFile = String.valueOf(path) + label + ".result";
        this.runHmmsearch(this.cdsProFile, hmmResultFile);
        this.parsingHmmResultToUcgFileOnlyProteins(hmmResultFile, this.cdsProFile, ucgFile);
        System.out.println("The ucg file is written in '" + ucgFile + "'");
        ArrayList<String> files = new ArrayList<String>();
        files.add(hmmResultFile);
        this.deleteFiles(files);
    }

    void cdsToJson() {
        this.validateFile(this.cdsProFile);
        this.validateFile(this.cdsNucFile);
        File file = new File(this.cdsProFile);
        String path = String.valueOf(file.getAbsoluteFile().getParent()) + File.separator;
        String label = this.parameters.get("-label");
        label = label.replaceAll(" ", "_");
        String ucgFile = String.valueOf(this.ucgDirectory) + label + ".ucg";
        this.checkResultFileAlreadyExist(ucgFile);
        String hmmResultFile = String.valueOf(path) + label + ".result";
        this.runHmmsearch(this.cdsProFile, hmmResultFile);
        this.parsingHmmResultToUcgFile(hmmResultFile, this.cdsProFile, this.cdsNucFile, ucgFile);
        System.out.println("The ucg file is written in '" + ucgFile + "'");
        ArrayList<String> files = new ArrayList<String>();
        files.add(hmmResultFile);
        this.deleteFiles(files);
    }

    void contigsToJson() {
        this.validateFile(this.contigFile);
        File file = new File(this.contigFile);
        String path = String.valueOf(file.getAbsoluteFile().getParent()) + File.separator;
        String label = this.parameters.get("-label");
        label = label.replaceAll(" ", "_");
        String ucgFile = String.valueOf(this.ucgDirectory) + label + ".ucg";
        this.checkResultFileAlreadyExist(ucgFile);
        String cdsProFile = String.valueOf(path) + label + "_pro";
        String cdsNucFile = String.valueOf(path) + label + "_nuc";
        String outFile = String.valueOf(path) + label + ".prodigal";
        int codonTable = 11;
        if (this.parameters.containsKey("-g")) {
            try {
                codonTable = Integer.parseInt(this.parameters.get("-g"));
                Integer[] codonTables = new Integer[]{1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 16, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
                List<Integer> codonList = Arrays.asList(codonTables);
                if (!codonList.contains(codonTable)) {
                    System.err.println("Error : Enter the proper translation table. Invalid table '" + codonTable + "'");
                    System.exit(1);
                }
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
                System.err.println("Enter an integer for -g option.");
                System.err.println("Exit.");
                System.exit(1);
            }
        }
        this.runProdigal(this.contigFile, cdsProFile, cdsNucFile, outFile, codonTable);
        String hmmResultFile = String.valueOf(path) + label + ".result";
        this.runHmmsearch(cdsProFile, hmmResultFile);
        this.parsingHmmResultToUcgFile(hmmResultFile, cdsProFile, cdsNucFile, ucgFile);
        System.out.println("The ucg file is written in '" + ucgFile + "'");
        ArrayList<String> files = new ArrayList<String>();
        files.add(cdsProFile);
        files.add(cdsNucFile);
        files.add(hmmResultFile);
        files.add(outFile);
        this.deleteFiles(files);
    }

    public void findUpcgSingleGenome(String version) {
        System.out.println("     -------------------------------");
        System.out.println("       UBCG ver." + version);
        System.out.println("     -------------------------------");
        System.out.println();
        System.out.println("Extracting the core genes from a genome sequence or CDS sequences of a single genome");
        System.out.println();
        String mode = null;
        if (this.parameters.containsKey("-i")) {
            mode = "extract_contigs";
            this.contigFile = this.parameters.get("-i");
            System.out.println("Extracting from input file '" + this.contigFile + "'");
            System.out.println();
            this.testProdigal(this.prodigalPath);
            this.testHmmsearch(this.hmmSearchPath);
        } else if (this.parameters.containsKey("-p") && this.parameters.containsKey("-n")) {
            mode = "extract_cds";
            this.cdsProFile = this.parameters.get("-p");
            this.cdsNucFile = this.parameters.get("-n");
            System.out.println("Extracting from input file '" + this.cdsProFile + "' & '" + this.cdsNucFile + "'");
            System.out.println();
            this.testHmmsearch(this.hmmSearchPath);
        } else if (this.parameters.containsKey("-p") && !this.parameters.containsKey("-n")) {
            mode = "extract_cds_pro";
            this.cdsProFile = this.parameters.get("-p");
            System.out.println("Extracting from input file '" + this.cdsProFile + "'");
            System.out.println();
            this.testHmmsearch(this.hmmSearchPath);
        } else {
            System.err.println("Error!");
            System.err.println("Enter proper parameters");
            System.err.println("Exit!");
            System.exit(1);
        }
        switch (mode) {
            case "extract_contigs": {
                this.contigsToJson();
                break;
            }
            case "extract_cds": {
                this.cdsToJson();
                break;
            }
            case "extract_cds_pro": {
                this.cdsToJsonOnlyProtein();
            }
        }
    }

    private void runProdigal(String inputContigsFile, String cdsProFile, String cdsNucFile, String outFile, int codonTable) {
        ProdigalWrapper prodigalWrapper = new ProdigalWrapper(this.prodigalPath);
        prodigalWrapper.addArgument("-i", inputContigsFile);
        prodigalWrapper.addArgument("-g", codonTable);
        prodigalWrapper.addArgument("-a", cdsProFile);
        prodigalWrapper.addArgument("-d", cdsNucFile);
        prodigalWrapper.addArgument("-q");
        prodigalWrapper.addArgument("-o", outFile);
        System.out.println("Running Prodigal.. ");
        System.out.println("Command : [" + prodigalWrapper.getCommandLine() + "]");
        prodigalWrapper.executeWithStdOut();
        System.out.println("Prodigal finished..");
        System.out.println();
    }

    private void runHmmsearch(String cdsProFile, String outFilePath) {
        HmmSearchWrapper hmmSearchWrapper = new HmmSearchWrapper(this.hmmSearchPath);
        hmmSearchWrapper.setTrustedCutoff();
        hmmSearchWrapper.setNoAlignment();
        hmmSearchWrapper.setOutFileName(outFilePath);
        hmmSearchWrapper.setHmmFileName(this.hmmProfilePath);
        hmmSearchWrapper.setSeqFileName(cdsProFile);
        System.out.println("Running hmmsearch.. ");
        System.out.println("Command : [" + hmmSearchWrapper.getCommandLine() + this.hmmProfilePath + " " + cdsProFile + " ]");
        hmmSearchWrapper.executeWithStdOut();
        System.out.println("Hmmsearch finished..");
        System.out.println();
    }

    private GeneSetByGenomeDomain parsingHmmResultToUcgFileOnlyProteins(String hmmResultFile, String cdsProFile, String ucgFile) {
        System.out.println("Parsing hmmsearch result..");
        GeneSetByGenomeDomain geneSetByGenomeDomain = new GeneSetByGenomeDomain();
        long time = System.currentTimeMillis();
        SimpleDateFormat dayTime = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String timeString = dayTime.format(new Date(time));
        geneSetByGenomeDomain.setRunTime(timeString);
        if (this.parameters.containsKey("-targ_taxon")) {
            geneSetByGenomeDomain.setTargetTaxon(this.parameters.get("-targ_taxon"));
        }
        ArrayList<String> targetGeneList = this.readHmmProfilesToConfigureTargetGenes();
        StringBuilder targetGenes = new StringBuilder();
        for (String gene : targetGeneList) {
            targetGenes.append(gene).append(",");
        }
        targetGenes.deleteCharAt(targetGenes.length() - 1);
        String targetGeneSet = targetGenes.toString();
        int targetGeneNum = targetGeneList.size();
        geneSetByGenomeDomain.setTargetGenes(targetGeneNum);
        geneSetByGenomeDomain.setUsedHmmProfile(new File(this.hmmProfilePath).getName());
        geneSetByGenomeDomain.setTargetGeneSet(targetGeneSet);
        HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = this.parsingDetectedGeneDataToMapOnlyProtein(hmmResultFile, cdsProFile);
        geneSetByGenomeDomain.setDataMap(dataMap);
        if (this.parameters.containsKey("-uid")) {
            String uidString = this.parameters.get("-uid");
            long uid = 0L;
            try {
                uid = Long.parseLong(uidString);
            }
            catch (NumberFormatException e) {
                System.err.println("Error : uid must be an integer.");
                System.err.println("Exit!");
                System.exit(1);
            }
            geneSetByGenomeDomain.setUid(uid);
        }
        geneSetByGenomeDomain.setLabel(this.parameters.get("-label"));
        if (this.parameters.containsKey("-type")) {
            geneSetByGenomeDomain.setIsTpyeStrain(true);
        }
        if (this.parameters.containsKey("-acc")) {
            geneSetByGenomeDomain.setAccession(this.parameters.get("-acc"));
        }
        if (this.parameters.containsKey("-taxon_name")) {
            geneSetByGenomeDomain.setTaxonName(this.parameters.get("-taxon_name"));
        }
        if (this.parameters.containsKey("-ncbi_name")) {
            geneSetByGenomeDomain.setNcbiName(this.parameters.get("-ncbi_name"));
        }
        if (this.parameters.containsKey("-taxonomy")) {
            geneSetByGenomeDomain.setTaxonomy(this.parameters.get("-taxonomy"));
        }
        if (this.parameters.containsKey("-strain_name")) {
            geneSetByGenomeDomain.setStrainName(this.parameters.get("-strain_name"));
        }
        if (this.parameters.containsKey("-strain_property")) {
            geneSetByGenomeDomain.setStrainPproperty(this.parameters.get("-strain_property"));
        }
        int totalDetectedGenes = 0;
        int singleCopyGenes = 0;
        int multipleCopyGenes = 0;
        int paralogs = 0;
        for (String gene : dataMap.keySet()) {
            int geneNum = dataMap.get(gene).size();
            if (geneNum == 1) {
                ++singleCopyGenes;
            } else if (geneNum > 1) {
                ++multipleCopyGenes;
            }
            totalDetectedGenes += geneNum;
        }
        paralogs = totalDetectedGenes - singleCopyGenes - multipleCopyGenes;
        geneSetByGenomeDomain.setTotalDetectedGenes(totalDetectedGenes);
        geneSetByGenomeDomain.setSingleCopyGenes(singleCopyGenes);
        geneSetByGenomeDomain.setMultipleCopyGenes(multipleCopyGenes);
        geneSetByGenomeDomain.setParalogs(paralogs);
        try {
            this.writeUcgFile(geneSetByGenomeDomain, ucgFile);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return geneSetByGenomeDomain;
    }

    private GeneSetByGenomeDomain parsingHmmResultToUcgFile(String hmmResultFile, String cdsProFile, String cdsNucFile, String ucgFile) {
        System.out.println("Parsing hmmsearch result..");
        GeneSetByGenomeDomain geneSetByGenomeDomain = new GeneSetByGenomeDomain();
        long time = System.currentTimeMillis();
        SimpleDateFormat dayTime = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String timeString = dayTime.format(new Date(time));
        geneSetByGenomeDomain.setRunTime(timeString);
        if (this.parameters.containsKey("-targ_taxon")) {
            geneSetByGenomeDomain.setTargetTaxon(this.parameters.get("-targ_taxon"));
        }
        ArrayList<String> targetGeneList = this.readHmmProfilesToConfigureTargetGenes();
        StringBuilder targetGenes = new StringBuilder();
        for (String gene : targetGeneList) {
            targetGenes.append(gene).append(",");
        }
        targetGenes.deleteCharAt(targetGenes.length() - 1);
        String targetGeneSet = targetGenes.toString();
        int targetGeneNum = targetGeneList.size();
        geneSetByGenomeDomain.setTargetGenes(targetGeneNum);
        geneSetByGenomeDomain.setUsedHmmProfile(new File(this.hmmProfilePath).getName());
        geneSetByGenomeDomain.setTargetGeneSet(targetGeneSet);
        HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = this.parsingDetectedGeneDataToMap(hmmResultFile, cdsProFile, cdsNucFile);
        geneSetByGenomeDomain.setDataMap(dataMap);
        geneSetByGenomeDomain.setLabel(this.parameters.get("-label"));
        if (this.parameters.containsKey("-type")) {
            geneSetByGenomeDomain.setIsTpyeStrain(true);
        }
        if (this.parameters.containsKey("-acc")) {
            geneSetByGenomeDomain.setAccession(this.parameters.get("-acc"));
        }
        if (this.parameters.containsKey("-taxon_name")) {
            geneSetByGenomeDomain.setTaxonName(this.parameters.get("-taxon_name"));
        }
        if (this.parameters.containsKey("-ncbi_name")) {
            geneSetByGenomeDomain.setNcbiName(this.parameters.get("-ncbi_name"));
        }
        if (this.parameters.containsKey("-taxonomy")) {
            geneSetByGenomeDomain.setTaxonomy(this.parameters.get("-taxonomy"));
        }
        if (this.parameters.containsKey("-strain_name")) {
            geneSetByGenomeDomain.setStrainName(this.parameters.get("-strain_name"));
        }
        if (this.parameters.containsKey("-strain_property")) {
            geneSetByGenomeDomain.setStrainPproperty(this.parameters.get("-strain_property"));
        }
        int totalDetectedGenes = 0;
        int singleCopyGenes = 0;
        int multipleCopyGenes = 0;
        int paralogs = 0;
        for (String gene : dataMap.keySet()) {
            int geneNum = dataMap.get(gene).size();
            if (geneNum == 1) {
                ++singleCopyGenes;
            } else if (geneNum > 1) {
                ++multipleCopyGenes;
            }
            totalDetectedGenes += geneNum;
        }
        paralogs = totalDetectedGenes - singleCopyGenes - multipleCopyGenes;
        geneSetByGenomeDomain.setTotalDetectedGenes(totalDetectedGenes);
        geneSetByGenomeDomain.setSingleCopyGenes(singleCopyGenes);
        geneSetByGenomeDomain.setMultipleCopyGenes(multipleCopyGenes);
        geneSetByGenomeDomain.setParalogs(paralogs);
        try {
            this.writeUcgFile(geneSetByGenomeDomain, ucgFile);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return geneSetByGenomeDomain;
    }

    private void writeUcgFile(GeneSetByGenomeDomain geneSetByGenomeDomain, String geneSetJsonFile) throws JSONException {
        JSONObject geneSetJsonObject = geneSetByGenomeDomain.toJsonObject();
        String geneSetJsonString = geneSetJsonObject.toString(4);
        try {
            FileWriter fileWriter = new FileWriter(geneSetJsonFile);
            fileWriter.append(geneSetJsonString);
            fileWriter.close();
        }
        catch (IOException e) {
            System.err.println("Error");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private HashMap<String, ArrayList<DetectedGeneDomain>> parsingDetectedGeneDataToMapOnlyProtein(String hmmResultFile, String cdsProFile) {
        HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = new HashMap<String, ArrayList<DetectedGeneDomain>>();
        String line = null;
        try {
            FileReader outFr = new FileReader(hmmResultFile);
            BufferedReader outBr = new BufferedReader(outFr);
            FastaSeqList CdsProFastaSeqList = new FastaSeqList();
            CdsProFastaSeqList.importFile(cdsProFile);
            while ((line = outBr.readLine()) != null) {
                if (!line.startsWith("Query:")) continue;
                String[] sline = line.split("\\s+");
                String gene = sline[1];
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                ArrayList<DetectedGeneDomain> detectedGeneDomains = new ArrayList<DetectedGeneDomain>();
                while (!(line = outBr.readLine()).startsWith("\n\n")) {
                    DetectedGeneDomain detectedGeneDomain = new DetectedGeneDomain();
                    String[] sHit = line.split("\\s+");
                    if (sHit.length == 1) break;
                    double eValue = Double.valueOf(sHit[1]);
                    double bitScore = Double.valueOf(sHit[2]);
                    String seqName = sHit[9];
                    detectedGeneDomain.seteValue(eValue);
                    detectedGeneDomain.setBitScore(bitScore);
                    detectedGeneDomain.setGeneName(gene);
                    for (FastaSeq proFastaSeq : CdsProFastaSeqList.list) {
                        if (!proFastaSeq.title.startsWith(seqName)) continue;
                        String seq_pro = proFastaSeq.sequence;
                        if (seq_pro.charAt(seq_pro.length() - 1) == '*') {
                            seq_pro = seq_pro.substring(0, seq_pro.length() - 1);
                        }
                        detectedGeneDomain.setProtein(seq_pro);
                        break;
                    }
                    detectedGeneDomains.add(detectedGeneDomain);
                }
                dataMap.put(gene, detectedGeneDomains);
            }
            outFr.close();
            outBr.close();
        }
        catch (IOException e) {
            System.err.println("Error : CDS fasta file is not available.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return dataMap;
    }

    private HashMap<String, ArrayList<DetectedGeneDomain>> parsingDetectedGeneDataToMap(String hmmResultFile, String cdsProFile, String cdsNucFile) {
        HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = new HashMap<String, ArrayList<DetectedGeneDomain>>();
        String line = null;
        try {
            FileReader outFr = new FileReader(hmmResultFile);
            BufferedReader outBr = new BufferedReader(outFr);
            FastaSeqList CdsNucFastaSeqList = new FastaSeqList();
            CdsNucFastaSeqList.importFile(cdsNucFile);
            FastaSeqList CdsProFastaSeqList = new FastaSeqList();
            CdsProFastaSeqList.importFile(cdsProFile);
            while ((line = outBr.readLine()) != null) {
                if (!line.startsWith("Query:")) continue;
                String[] sline = line.split("\\s+");
                String gene = sline[1];
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                line = outBr.readLine();
                ArrayList<DetectedGeneDomain> detectedGeneDomains = new ArrayList<DetectedGeneDomain>();
                while (!(line = outBr.readLine()).startsWith("\n\n")) {
                    DetectedGeneDomain detectedGeneDomain = new DetectedGeneDomain();
                    String[] sHit = line.split("\\s+");
                    if (sHit.length == 1) break;
                    double eValue = Double.valueOf(sHit[1]);
                    double bitScore = Double.valueOf(sHit[2]);
                    String seqName = sHit[9];
                    detectedGeneDomain.seteValue(eValue);
                    detectedGeneDomain.setBitScore(bitScore);
                    detectedGeneDomain.setGeneName(gene);
                    for (FastaSeq nucFastaSeq : CdsNucFastaSeqList.list) {
                        if (!nucFastaSeq.title.startsWith(String.valueOf(seqName) + " ")) continue;
                        String seq_nuc = nucFastaSeq.sequence;
                        String stopCodon = seq_nuc.substring(seq_nuc.length() - 3);
                        if (!(stopCodon.equals("TAA") || stopCodon.equals("TAG") || stopCodon.equals("TGA"))) {
                            seq_nuc = String.valueOf(seq_nuc) + "TAA";
                        }
                        detectedGeneDomain.setDna(seq_nuc);
                        break;
                    }
                    for (FastaSeq proFastaSeq : CdsProFastaSeqList.list) {
                        if (!proFastaSeq.title.startsWith(String.valueOf(seqName) + " ")) continue;
                        String seq_pro = proFastaSeq.sequence;
                        if (seq_pro.charAt(seq_pro.length() - 1) == '*') {
                            seq_pro = seq_pro.substring(0, seq_pro.length() - 1);
                        }
                        detectedGeneDomain.setProtein(seq_pro);
                        break;
                    }
                    detectedGeneDomains.add(detectedGeneDomain);
                }
                dataMap.put(gene, detectedGeneDomains);
            }
            outFr.close();
            outBr.close();
        }
        catch (IOException e) {
            System.err.println("Error : CDS fasta file is not available.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        return dataMap;
    }

    private void deleteFiles(ArrayList<String> files) {
        for (String fileS : files) {
            File file = new File(fileS);
            if (!file.exists()) continue;
            try {
                file.delete();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }

    private ArrayList<String> readHmmProfilesToConfigureTargetGenes() {
        ArrayList<String> targetGeneSets = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(this.hmmProfilePath);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("NAME")) continue;
                String gene = line.substring(6);
                targetGeneSets.add(gene);
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            System.err.println("Error occurred! Cannot read the file " + this.hmmProfilePath);
            System.err.println("Exit!");
            System.exit(1);
        }
        if (targetGeneSets.isEmpty()) {
            System.err.println("No target genes in the HMM profile. Check the file");
            System.exit(1);
        }
        return targetGeneSets;
    }

    private void testHmmsearch(String hmmsearchPath) {
        boolean hmmsearch = false;
        ArrayList<String> argHmmsearch = new ArrayList<String>();
        argHmmsearch.add(hmmsearchPath);
        argHmmsearch.add("-h");
        try {
            String s;
            Process testHmmsearch = new ProcessBuilder(argHmmsearch).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(testHmmsearch.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(testHmmsearch.getErrorStream()));
            while ((s = stdOut.readLine()) != null) {
                if (!s.contains("# HMMER ")) continue;
                hmmsearch = true;
            }
            while ((s = stdError.readLine()) != null) {
            }
            stdOut.close();
            stdError.close();
            try {
                testHmmsearch.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (!hmmsearch) {
            System.err.println("Error : Check if Hmmsearch in HMMER 3.1b2 (February 2015) package is properly installed and check the program path in the 'programPath' file");
            System.exit(1);
        }
    }

    private void testProdigal(String prodigalPath) {
        boolean prodigal = false;
        ArrayList<String> argProdigal = new ArrayList<String>();
        argProdigal.add(prodigalPath);
        argProdigal.add("-v");
        try {
            String s;
            Process testProdigal = new ProcessBuilder(argProdigal).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(testProdigal.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(testProdigal.getErrorStream()));
            while ((s = stdOut.readLine()) != null) {
            }
            while ((s = stdError.readLine()) != null) {
                if (!s.contains("Prodigal ")) continue;
                prodigal = true;
            }
            stdOut.close();
            stdError.close();
            try {
                testProdigal.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (!prodigal) {
            System.err.println("Error : Check if PRODIGAL v2.6.3 is properly installed and check the program path in the 'programPath' file");
            System.exit(1);
        }
    }

    private void checkResultFileAlreadyExist(String fileName) {
        if (new File(fileName).exists()) {
            System.err.println("Error");
            System.err.println(String.valueOf(fileName) + " already exists!");
            System.err.println("Exit!");
            System.exit(1);
        }
    }
}

