/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private static final int COMPRESSION_LEVEL = 8;
    private static final int BUFFER_SIZE = 2048;

    public static boolean gunzipIt(String inputFilePath, String outFilePath) {
        byte[] buffer = new byte[40960];
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(inputFilePath));
            FileOutputStream out = new FileOutputStream(outFilePath);
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            gzis.close();
            out.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static String createMonthDirString() {
        return new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis());
    }

    public static byte[] file2bytes(File f) {
        FileInputStream fileInputStream = null;
        byte[] bFile = new byte[(int)f.length()];
        try {
            fileInputStream = new FileInputStream(f);
            fileInputStream.read(bFile);
            fileInputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return bFile;
    }

    public static boolean bytes2file(byte[] data, String file_name) {
        FileOutputStream fileOuputStream = null;
        try {
            fileOuputStream = new FileOutputStream(file_name);
            fileOuputStream.write(data);
            fileOuputStream.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.createMonthDirString());
    }

    public static boolean isBlastDbDNA(String fasta_file_name) {
        File f = new File(String.valueOf(fasta_file_name) + ".nsq");
        if (!f.exists()) {
            return false;
        }
        return f.length() > 0L;
    }

    public static boolean isBlastDbProtein(String fasta_file_name) {
        File f = new File(String.valueOf(fasta_file_name) + ".psq");
        if (!f.exists()) {
            return false;
        }
        return f.length() > 0L;
    }

    private static void zipEntry(File sourceFile, String sourcePath, ZipOutputStream zos) throws Exception {
        if (sourceFile.isDirectory()) {
            if (sourceFile.getName().equalsIgnoreCase(".metadata")) {
                return;
            }
            File[] fileArray = sourceFile.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                FileUtils.zipEntry(fileArray[i], sourcePath, zos);
                ++i;
            }
        } else {
            try (BufferedInputStream bis = null;){
                String zipEntryName = sourceFile.getName();
                bis = new BufferedInputStream(new FileInputStream(sourceFile));
                ZipEntry zentry = new ZipEntry(zipEntryName);
                zentry.setTime(sourceFile.lastModified());
                zos.putNextEntry(zentry);
                byte[] buffer = new byte[2048];
                int cnt = 0;
                while ((cnt = bis.read(buffer, 0, 2048)) != -1) {
                    zos.write(buffer, 0, cnt);
                }
                zos.closeEntry();
            }
        }
    }

    public static void unzip(File zipFile, File targetDir, boolean fileNameToLowerCase) throws Exception {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipEntry zentry = null;
        try {
            fis = new FileInputStream(zipFile);
            zis = new ZipInputStream(fis);
            while ((zentry = zis.getNextEntry()) != null) {
                String fileNameToUnzip = zentry.getName();
                if (fileNameToLowerCase) {
                    fileNameToUnzip = fileNameToUnzip.toLowerCase();
                }
                File targetFile = new File(targetDir, fileNameToUnzip);
                if (zentry.isDirectory()) {
                    targetFile.mkdir();
                    continue;
                }
                targetFile.mkdir();
                FileUtils.unzipEntry(zis, targetFile);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    protected static File unzipEntry(ZipInputStream zis, File targetFile) throws Exception {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(targetFile);
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        return targetFile;
    }

    public static String readTextFile2StringWithCR(String filename) {
        StringBuffer sb = new StringBuffer("");
        try {
            FileReader fr = new FileReader(new File(filename));
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(sb);
    }

    public static String readTextFile2StringWithCR(String filename, char CR_char) {
        StringBuffer sb = new StringBuffer("");
        try {
            FileReader fr = new FileReader(new File(filename));
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(String.valueOf(line) + CR_char);
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(sb);
    }
}

