/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import lbj.BranchRelationship;
import lbj.BranchScore;
import lbj.ConsenseProgram;
import lbj.Node;
import lbj.Species;
import lbj.Tree;

public class ConsensusTree {
    public static void getBranches(String newickString) {
        ArrayList branchStrings = new ArrayList();
        Tree[] trees = Tree.importNewick(newickString);
        int i = 0;
        while (i < trees.length) {
            Tree tree = trees[i];
            HashMap<String, Integer> leafNameIndexMap = new HashMap<String, Integer>();
            List leaves = tree.getLeaves();
            int numOfLeaves = leaves.size();
            System.out.print("branch ");
            int j = 0;
            while (j < leaves.size()) {
                leafNameIndexMap.put(leaves.get(j).getName(), j);
                System.out.print(" " + leaves.get(j).getName());
                ++j;
            }
            System.out.println();
            ArrayList list = new ArrayList();
            int j2 = 0;
            while (j2 < tree.getRoot().getChildren().size()) {
                list.add(tree.getRoot().getChildren().get(j2));
                ++j2;
            }
            int current = 0;
            while (current < list.size()) {
                Node currentNode = (Node)list.get(current);
                List currentLeaves = new Tree(currentNode).getLeaves();
                if (currentLeaves.size() > 1 && currentLeaves.size() < numOfLeaves - 1) {
                    System.out.print("       ");
                    boolean[] flags = new boolean[numOfLeaves];
                    int j3 = 0;
                    while (j3 < currentLeaves.size()) {
                        int index = (Integer)leafNameIndexMap.get(currentLeaves.get(j3).getName());
                        flags[index] = true;
                        ++j3;
                    }
                    j3 = 0;
                    while (j3 < flags.length) {
                        System.out.print(" " + (flags[j3] ? 1 : 0));
                        ++j3;
                    }
                    System.out.println();
                }
                int j4 = 0;
                while (j4 < currentNode.getChildren().size()) {
                    list.add(currentNode.getChildren().get(j4));
                    ++j4;
                }
                ++current;
            }
            ++i;
        }
    }

    private static void propagate(String[] charset, int k, int position, String string, List<String> strings) {
        if (position == k) {
            strings.add(string);
        } else {
            int i = 0;
            while (i < charset.length) {
                ConsensusTree.propagate(charset, k, position + 1, String.valueOf(string) + charset[i], strings);
                ++i;
            }
        }
    }

    public static String[] getAllPossibleKmers(String[] charset, int k) {
        ArrayList<String> strings = new ArrayList<String>((int)Math.pow(charset.length, k));
        ConsensusTree.propagate(charset, k, 0, "", strings);
        return strings.toArray(new String[strings.size()]);
    }

    public static int[] growBranches(List<Species> speciesList, Node<BranchScore> node) {
        BranchScore branch = node.getData();
        int[] descendants = new int[speciesList.size()];
        int i = 0;
        while (i < speciesList.size()) {
            if (branch.getSpeciesString().charAt(i) == '*') {
                descendants[i] = 1;
            }
            ++i;
        }
        i = 0;
        while (i < node.getChildren().size()) {
            int[] descendants2 = ConsensusTree.growBranches(speciesList, node.getChildren().get(i));
            int j = 0;
            while (j < speciesList.size()) {
                int n = j;
                descendants[n] = descendants[n] + descendants2[j];
                ++j;
            }
            ++i;
        }
        System.out.println(String.valueOf(branch.getSpeciesString()) + "->" + node.getChildren().size());
        i = 0;
        while (i < speciesList.size()) {
            System.out.print(descendants[i]);
            ++i;
        }
        System.out.println();
        if (node.getChildren().size() > 0) {
            i = 0;
            while (i < speciesList.size()) {
                if (descendants[i] == 1) {
                    Node child = new Node(speciesList.get(i).getName());
                    node.addChild(child, speciesList.get(i).getCount());
                    System.out.println(String.valueOf(node.getName()) + " growing child " + speciesList.get(i).getName());
                }
                ++i;
            }
        }
        return descendants;
    }

    public static void getBranchCount(String filename) {
        int leftChar;
        File file = new File(filename);
        String string = "";
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                char[] buf = new char[(int)file.length()];
                reader.read(buf, 0, (int)file.length());
                string = new String(buf);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(string);
        ArrayList<String> firstTreeSpecies = new ArrayList<String>();
        HashMap<String, Species> speciesMap = new HashMap<String, Species>();
        ArrayList<Species> speciesList = new ArrayList<Species>();
        Tree[] trees = Tree.importNewick(string);
        int i = 0;
        while (i < trees.length) {
            Tree tree = trees[i];
            List leaves = tree.getLeaves();
            int j = 0;
            while (j < leaves.size()) {
                Species species;
                Node leaf = leaves.get(j);
                String name = leaf.getName();
                if (!speciesMap.containsKey(name)) {
                    species = new Species(name);
                    species.setCount(1);
                    speciesMap.put(name, species);
                    speciesList.add(species);
                } else {
                    species = (Species)speciesMap.get(name);
                    species.setCount(species.getCount() + 1);
                }
                if (i == 0) {
                    firstTreeSpecies.add(name);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(speciesList, new Comparator<Species>(){

            @Override
            public int compare(Species speciesA, Species speciesB) {
                return speciesA.getName().compareTo(speciesB.getName());
            }
        });
        i = 0;
        while (i < speciesList.size()) {
            Species species = (Species)speciesList.get(i);
            species.setIndex(i);
            System.out.println(String.format("%4d: %12s | %4d", species.getIndex(), species.getName(), species.getCount()));
            ++i;
        }
        HashMap<String, BranchScore> branchMap = new HashMap<String, BranchScore>();
        ArrayList<BranchScore> branchList = new ArrayList<BranchScore>();
        int i2 = 0;
        while (i2 < trees.length) {
            Tree tree = trees[i2];
            HashMap<String, BranchScore> localBranchMap = new HashMap<String, BranchScore>();
            List leaves = tree.getLeaves();
            int numOfLeaves = leaves.size();
            Boolean[] existingSpecies = new Boolean[speciesList.size()];
            int j = 0;
            while (j < existingSpecies.length) {
                existingSpecies[j] = false;
                ++j;
            }
            j = 0;
            while (j < leaves.size()) {
                existingSpecies[((Species)speciesMap.get((Object)leaves.get((int)j).getName())).getIndex()] = true;
                ++j;
            }
            ArrayList<Integer> missingSpecies = new ArrayList<Integer>();
            int j2 = 0;
            while (j2 < existingSpecies.length) {
                if (!existingSpecies[j2].booleanValue()) {
                    missingSpecies.add(j2);
                }
                ++j2;
            }
            int numMissingSpecies = speciesList.size() - leaves.size();
            int numVariations = (int)Math.pow(2.0, numMissingSpecies);
            System.out.println("missing " + missingSpecies);
            ArrayList list = new ArrayList();
            list.add(tree.getRoot());
            int current = 0;
            while (current < list.size()) {
                Node currentNode = (Node)list.get(current);
                List currentLeaves = new Tree(currentNode).getLeaves();
                double points = 1.0 / (double)numVariations;
                BranchScore[] branches = new BranchScore[numVariations];
                if (numMissingSpecies == 0) {
                    BranchScore branch = new BranchScore(speciesList.size());
                    int j3 = 0;
                    while (j3 < currentLeaves.size()) {
                        branch.getSpecies()[((Species)speciesMap.get((Object)currentLeaves.get((int)j3).getName())).getIndex()] = 1;
                        ++j3;
                    }
                    branch.setSpeciesString();
                    branches[0] = branch;
                } else {
                    BranchScore branch2 = new BranchScore(speciesList.size());
                    int k = 0;
                    while (k < currentLeaves.size()) {
                        branch2.getSpecies()[((Species)speciesMap.get((Object)currentLeaves.get((int)k).getName())).getIndex()] = 1;
                        ++k;
                    }
                    k = 0;
                    while (k < numMissingSpecies) {
                        branch2.getSpecies()[((Integer)missingSpecies.get((int)k)).intValue()] = 2;
                        ++k;
                    }
                    branch2.setSpeciesString();
                    String[] strings = ConsensusTree.getAllPossibleKmers(new String[]{".", "*"}, numMissingSpecies);
                    int j4 = 0;
                    while (j4 < numVariations) {
                        BranchScore branch = new BranchScore(speciesList.size());
                        int k2 = 0;
                        while (k2 < currentLeaves.size()) {
                            branch.getSpecies()[((Species)speciesMap.get((Object)currentLeaves.get((int)k2).getName())).getIndex()] = 1;
                            ++k2;
                        }
                        k2 = 0;
                        while (k2 < numMissingSpecies) {
                            if (strings[j4].charAt(k2) == '*') {
                                branch.getSpecies()[((Integer)missingSpecies.get((int)k2)).intValue()] = 1;
                            }
                            ++k2;
                        }
                        branch.setSpeciesString();
                        branches[j4] = branch;
                        ++j4;
                    }
                }
                int j5 = 0;
                while (j5 < branches.length) {
                    BranchScore branch = branches[j5];
                    if (branch.getNumRights() > 0 && branch.getNumRights() < speciesList.size() - 0 && !localBranchMap.containsKey(branch.getSpeciesString())) {
                        localBranchMap.put(branch.getSpeciesString(), branch);
                        if (!branchMap.containsKey(branch.getSpeciesString())) {
                            branchMap.put(branch.getSpeciesString(), branch);
                            branch.setScore(points);
                            branchList.add(branch);
                        } else {
                            ((BranchScore)branchMap.get(branch.getSpeciesString())).addPoints(points);
                        }
                    }
                    ++j5;
                }
                j5 = 0;
                while (j5 < currentNode.getChildren().size()) {
                    list.add(currentNode.getChildren().get(j5));
                    ++j5;
                }
                ++current;
            }
            ++i2;
        }
        Collections.sort(branchList, new Comparator<BranchScore>(){

            @Override
            public int compare(BranchScore branchA, BranchScore branchB) {
                double difference = branchB.getScore() - branchA.getScore();
                if (difference == 0.0) {
                    return 0;
                }
                if (difference < 0.0) {
                    return -1;
                }
                return 1;
            }
        });
        HashMap<String, BranchRelationship> relationshipMap = new HashMap<String, BranchRelationship>();
        ArrayList<BranchScore> includedBranches = new ArrayList<BranchScore>();
        ArrayList<BranchScore> omittedBranches = new ArrayList<BranchScore>();
        includedBranches.add((BranchScore)branchList.get(0));
        int i3 = 1;
        while (i3 < branchList.size()) {
            BranchScore branch = (BranchScore)branchList.get(i3);
            boolean valid = true;
            int j = 0;
            while (j < includedBranches.size()) {
                BranchRelationship relationship = ((BranchScore)includedBranches.get(j)).getRelationshipWith(branch);
                if (relationship == BranchRelationship.IMCOMPATIBLE) {
                    valid = false;
                }
                relationshipMap.put(String.valueOf(((BranchScore)includedBranches.get(j)).getSpeciesString()) + branch.getSpeciesString(), relationship);
                ++j;
            }
            if (valid) {
                includedBranches.add(branch);
            } else {
                omittedBranches.add(branch);
            }
            ++i3;
        }
        int longestName = 0;
        int i4 = 0;
        while (i4 < firstTreeSpecies.size()) {
            if (longestName < ((String)firstTreeSpecies.get(i4)).length()) {
                longestName = ((String)firstTreeSpecies.get(i4)).length();
            }
            ++i4;
        }
        String[] names = new String[longestName];
        int i5 = 0;
        while (i5 < longestName) {
            names[i5] = "";
            ++i5;
        }
        i5 = 0;
        while (i5 < firstTreeSpecies.size()) {
            int diff = longestName - ((String)firstTreeSpecies.get(i5)).length();
            int j = 0;
            while (j < longestName) {
                int index = j - diff;
                if (index < 0) {
                    int n = j;
                    names[n] = String.valueOf(names[n]) + ' ';
                } else {
                    int n = j;
                    names[n] = String.valueOf(names[n]) + ((String)firstTreeSpecies.get(i5)).charAt(index);
                }
                ++j;
            }
            ++i5;
        }
        String firstTreeString = "";
        int i6 = 0;
        while (i6 < longestName) {
            firstTreeString = String.valueOf(firstTreeString) + names[i6];
            if (i6 < longestName - 1) {
                firstTreeString = String.valueOf(firstTreeString) + '\n';
            }
            ++i6;
        }
        System.out.println(firstTreeString);
        System.out.println("Sets included in the consensus tree");
        i6 = 0;
        while (i6 < includedBranches.size()) {
            BranchScore branch = (BranchScore)includedBranches.get(i6);
            String str = "";
            boolean isFirst = true;
            leftChar = 32;
            char rightChar = ' ';
            int j = 0;
            while (j < firstTreeSpecies.size()) {
                int status = branch.getSpecies()[((Species)speciesMap.get(firstTreeSpecies.get(j))).getIndex()];
                if (status == 0) {
                    if (isFirst) {
                        isFirst = false;
                        leftChar = 46;
                        rightChar = '*';
                    }
                    str = String.valueOf(str) + (char)leftChar;
                } else if (status == 1) {
                    if (isFirst) {
                        isFirst = false;
                        leftChar = 42;
                        rightChar = '.';
                    }
                    str = String.valueOf(str) + rightChar;
                } else if (status == 2) {
                    str = String.valueOf(str) + "?";
                }
                ++j;
            }
            System.out.println(String.format("%s | %4.2f   .......%d", str, branch.getScore(), i6));
            ++i6;
        }
        System.out.println("Sets NOT included in the consensus tree");
        i6 = 0;
        while (i6 < omittedBranches.size()) {
            BranchScore branch = (BranchScore)omittedBranches.get(i6);
            String str = "";
            boolean isFirst = true;
            leftChar = 32;
            char rightChar = ' ';
            int j = 0;
            while (j < firstTreeSpecies.size()) {
                int status = branch.getSpecies()[((Species)speciesMap.get(firstTreeSpecies.get(j))).getIndex()];
                if (status == 0) {
                    if (isFirst) {
                        isFirst = false;
                        leftChar = 46;
                        rightChar = '*';
                    }
                    str = String.valueOf(str) + (char)leftChar;
                } else if (status == 1) {
                    if (isFirst) {
                        isFirst = false;
                        leftChar = 42;
                        rightChar = '.';
                    }
                    str = String.valueOf(str) + rightChar;
                } else if (status == 2) {
                    str = String.valueOf(str) + "?";
                }
                ++j;
            }
            System.out.println(String.format("%s | %4.2f   .......%d", str, branch.getScore(), i6));
            ++i6;
        }
        BranchScore rootBranch = new BranchScore(speciesList.size());
        int j = 0;
        while (j < speciesList.size()) {
            rootBranch.getSpecies()[j] = 1;
            ++j;
        }
        rootBranch.setSpeciesString();
        Node<BranchScore> root = new Node<BranchScore>(rootBranch, "root");
        String name = "";
        int i7 = 0;
        while (i7 < speciesList.size()) {
            Species species = (Species)speciesList.get(i7);
            name = String.valueOf(name) + species.getName();
            if (i7 < speciesList.size() - 1) {
                name = String.valueOf(name);
            }
            ++i7;
        }
        root.setName(name);
        i7 = 0;
        while (i7 < includedBranches.size()) {
            BranchScore branch = (BranchScore)includedBranches.get(i7);
            name = "";
            int numOfRightSpecies = 0;
            int j6 = 0;
            while (j6 < branch.getSpecies().length) {
                if (branch.getSpecies()[j6] == 1) {
                    if (++numOfRightSpecies > 1) {
                        name = String.valueOf(name);
                    }
                    name = String.valueOf(name) + ((Species)speciesList.get(j6)).getName();
                }
                ++j6;
            }
            Node<BranchScore> node = new Node<BranchScore>(branch, name);
            Node<BranchScore> parent = root;
            while (parent.getChildren().size() > 0) {
                boolean traversed = false;
                int j7 = 0;
                while (j7 < parent.getChildren().size()) {
                    Node<BranchScore> child = parent.getChildren().get(j7);
                    String key = String.valueOf(child.getData().getSpeciesString()) + branch.getSpeciesString();
                    BranchRelationship relationship = (BranchRelationship)((Object)relationshipMap.get(key));
                    if (relationship == BranchRelationship.SUPERSET) {
                        traversed = true;
                        parent = child;
                        break;
                    }
                    ++j7;
                }
                if (traversed) continue;
                j7 = 0;
                while (j7 < parent.getChildren().size()) {
                    Node<BranchScore> child = parent.getChildren().get(j7);
                    String key = String.valueOf(child.getData().getSpeciesString()) + branch.getSpeciesString();
                    BranchRelationship relationship = (BranchRelationship)((Object)relationshipMap.get(key));
                    if (relationship == BranchRelationship.SUBSET) {
                        parent.removeChild(j7);
                        node.addChild(child, child.getData().getScore());
                        --j7;
                    }
                    ++j7;
                }
                break block39;
            }
            parent.addChild(node, branch.getScore());
            ++i7;
        }
        ConsensusTree.growBranches(speciesList, root);
        System.out.println("Consensus Tree:");
        System.out.println(new Tree<BranchScore>(root).exportAsNewick());
    }

    public static void main(String[] args) {
        ConsenseProgram.setBinDirectory(new File("D:/Dev/workspace/TreeOfLife"));
        File samplesDir = new File("samples");
        File[] files = samplesDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File inputFile = new File(files[i].getPath().concat(String.valueOf(File.separator) + "intree"));
                inputFile.exists();
            }
            ++i;
        }
        ConsensusTree.getBranchCount("intree");
    }
}

