/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lbj.BranchAnalysis;
import lbj.BranchRelationship;

public class BranchTag {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int MISSING = 2;
    static boolean useHashArray = false;
    private List<Integer> id;
    private boolean isLeaf;
    private boolean isRoot;
    private int hashCode;
    private int tagLength;
    private int hashLength;
    private int[] hashArray;

    private BranchTag() {
    }

    public BranchTag(int size, List<Integer> speciesOnRight, List<Integer> speciesMissing) {
        this.id = this.produceIdFromIndexedList(size, speciesOnRight, speciesMissing);
        this.calcHashCode();
    }

    public BranchTag getCopy(boolean side) {
        BranchTag copy;
        block19: {
            copy = new BranchTag();
            copy.id = new ArrayList<Integer>(this.id.size());
            copy.isLeaf = this.isLeaf;
            copy.isRoot = this.isRoot;
            copy.hashCode = this.hashCode;
            int index = 0;
            while (index < this.id.size() && this.id.get(index) == 2) {
                copy.id.add(2);
                ++index;
            }
            if (index >= this.id.size()) break block19;
            if (!side) {
                if (this.id.get(index) == 0) {
                    int i = index;
                    while (i < this.id.size()) {
                        copy.id.add(this.id.get(i));
                        ++i;
                    }
                } else {
                    int i = index;
                    while (i < this.id.size()) {
                        if (this.id.get(i) == 0) {
                            copy.id.add(1);
                        } else if (this.id.get(i) == 1) {
                            copy.id.add(0);
                        } else {
                            copy.id.add(this.id.get(i));
                        }
                        ++i;
                    }
                }
            } else if (this.id.get(index) == 1) {
                int i = index;
                while (i < this.id.size()) {
                    copy.id.add(this.id.get(i));
                    ++i;
                }
            } else {
                int i = index;
                while (i < this.id.size()) {
                    if (this.id.get(i) == 0) {
                        copy.id.add(1);
                    } else if (this.id.get(i) == 1) {
                        copy.id.add(0);
                    } else {
                        copy.id.add(this.id.get(i));
                    }
                    ++i;
                }
            }
        }
        return copy;
    }

    public BranchTag getCopy(int outgroupIndex) {
        BranchTag copy = new BranchTag();
        copy.id = new ArrayList<Integer>(this.id.size());
        copy.isLeaf = this.isLeaf;
        copy.isRoot = this.isRoot;
        copy.hashCode = this.hashCode;
        if (this.isRoot) {
            int i = 0;
            while (i < this.id.size()) {
                copy.id.add(this.id.get(i));
                ++i;
            }
        } else if (this.id.get(outgroupIndex) == 0) {
            int i = 0;
            while (i < this.id.size()) {
                copy.id.add(this.id.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.id.size()) {
                if (this.id.get(i) == 0) {
                    copy.id.add(1);
                } else if (this.id.get(i) == 1) {
                    copy.id.add(0);
                } else {
                    copy.id.add(this.id.get(i));
                }
                ++i;
            }
        }
        return copy;
    }

    private List<Integer> produceIdFromIndexedList(int size, List<Integer> speciesOnRight, List<Integer> speciesMissing) {
        int index;
        List<Integer> id = Arrays.asList(new Integer[size]);
        this.isRoot = speciesOnRight.isEmpty() || size == speciesOnRight.size();
        this.isLeaf = speciesOnRight.size() == 1 || size - speciesOnRight.size() == 1;
        int i = 0;
        while (i < size) {
            id.set(i, 0);
            ++i;
        }
        if (speciesOnRight != null) {
            i = 0;
            while (i < speciesOnRight.size()) {
                index = speciesOnRight.get(i);
                id.set(index, 1);
                ++i;
            }
        }
        if (speciesMissing != null) {
            i = 0;
            while (i < speciesMissing.size()) {
                index = speciesMissing.get(i);
                id.set(index, 2);
                ++i;
            }
        }
        return id;
    }

    public List<Integer> getId() {
        return Collections.unmodifiableList(this.id);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public BranchRelationship getRelationshipWith(BranchTag other) {
        if (this.id.size() != other.id.size()) {
            return BranchRelationship.IMCOMPATIBLE;
        }
        int LL = 0;
        int RR = 0;
        int LR = 0;
        int RL = 0;
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) == 0) {
                if (other.id.get(i) == 0) {
                    ++LL;
                } else if (other.id.get(i) == 1) {
                    ++LR;
                }
            } else if (this.id.get(i) == 1) {
                if (other.id.get(i) == 0) {
                    ++RL;
                } else if (other.id.get(i) == 1) {
                    ++RR;
                }
            }
            ++i;
        }
        BranchRelationship verdict = BranchRelationship.IMCOMPATIBLE;
        if (RR > 0) {
            if (LR == 0) {
                verdict = BranchRelationship.SUPERSET;
            } else if (RL == 0) {
                verdict = BranchRelationship.SUBSET;
            }
        } else {
            verdict = BranchRelationship.MUTEX;
        }
        return verdict;
    }

    public BranchRelationship getRelationshipWith(BranchTag other, int outgroupIndex) {
        if (this.id.size() != other.id.size()) {
            return BranchRelationship.IMCOMPATIBLE;
        }
        if (this.isRoot) {
            return BranchRelationship.SUPERSET;
        }
        if (other.isRoot) {
            return BranchRelationship.SUBSET;
        }
        Integer thisRight = this.id.get(outgroupIndex);
        Integer otherRight = other.id.get(outgroupIndex);
        int LL = 0;
        int RR = 0;
        int LR = 0;
        int RL = 0;
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) == thisRight) {
                if (other.id.get(i) == otherRight) {
                    ++LL;
                } else if (other.id.get(i) != otherRight) {
                    ++LR;
                }
            } else if (this.id.get(i) != thisRight) {
                if (other.id.get(i) == otherRight) {
                    ++RL;
                } else if (other.id.get(i) != otherRight) {
                    ++RR;
                }
            }
            ++i;
        }
        BranchRelationship verdict = BranchRelationship.IMCOMPATIBLE;
        if (RR > 0) {
            if (LR == 0) {
                verdict = BranchRelationship.SUPERSET;
            } else if (RL == 0) {
                verdict = BranchRelationship.SUBSET;
            }
        } else {
            verdict = BranchRelationship.MUTEX;
        }
        return verdict;
    }

    protected Object clone() throws CloneNotSupportedException {
        BranchTag branch = new BranchTag();
        branch.id = Collections.unmodifiableList(this.id);
        branch.isRoot = this.isRoot;
        branch.isLeaf = this.isLeaf;
        branch.hashCode = this.hashCode;
        return branch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BranchTag)) {
            return false;
        }
        BranchTag other = (BranchTag)obj;
        if (this.tagLength != other.tagLength) {
            return false;
        }
        if (this.tagLength == 0 && other.tagLength == 0) {
            return true;
        }
        if (useHashArray) {
            int i = 0;
            while (i < this.hashLength) {
                if (this.hashArray[i] != other.hashArray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int index = 0;
        while (index < this.id.size() && this.id.get(index) == 2 && other.id.get(index) == 2) {
            ++index;
        }
        if (index < this.id.size()) {
            boolean firstXOR = this.id.get(index) != other.id.get(index);
            int i = index;
            while (i < this.id.size()) {
                if (this.id.get(i) == 2 || other.id.get(i) == 2) {
                    if (this.id.get(i) != other.id.get(i)) {
                        return false;
                    }
                } else if (firstXOR != (this.id.get(i) != other.id.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean equalsIgnoreMissing(Object obj) {
        return this.equalsIgnoreMissing(obj, 0, 0);
    }

    public boolean equalsIgnoreMissing(Object obj, int missingTolerance, int mismatchTolerance) {
        if (!(obj instanceof BranchTag)) {
            return false;
        }
        if (missingTolerance < 0) {
            missingTolerance = this.id.size();
        }
        if (mismatchTolerance < 0) {
            mismatchTolerance = this.id.size();
        }
        BranchTag other = (BranchTag)obj;
        if (this.id.size() != other.id.size()) {
            return false;
        }
        if (this.id.size() == 0 && other.id.size() == 0) {
            return true;
        }
        int missing = 0;
        int mismatch = 0;
        int index = 0;
        while (index < this.id.size() && (this.id.get(index) == 2 || other.id.get(index) == 2)) {
            if ((this.id.get(index) != 2 || other.id.get(index) != 2) && ++missing > missingTolerance) {
                return false;
            }
            ++index;
        }
        if (index < this.id.size()) {
            boolean firstXOR = this.id.get(index) != other.id.get(index);
            int i = index + 1;
            while (i < this.id.size()) {
                if (this.id.get(i) == 2 || other.id.get(i) == 2 ? (this.id.get(index) != 2 || other.id.get(index) != 2) && ++missing > missingTolerance : firstXOR != (this.id.get(i) != other.id.get(i)) && ++mismatch > mismatchTolerance) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean equalsSideSensitive(Object obj) {
        if (!(obj instanceof BranchTag)) {
            return false;
        }
        BranchTag other = (BranchTag)obj;
        if (this.id.size() != other.id.size()) {
            return false;
        }
        if (this.id.size() == 0 && other.id.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) != other.id.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void calcHashCode() {
        this.tagLength = this.id.size();
        int remainder = 20;
        int current = 0;
        if (useHashArray) {
            this.hashLength = Math.max(1, (int)Math.ceil((double)this.tagLength / 20.0));
            this.hashArray = new int[this.hashLength];
            remainder -= this.hashLength * 20 - this.tagLength;
        }
        this.hashCode = 0;
        if (this.id.isEmpty()) {
            return;
        }
        int length = this.id.size();
        boolean isFirst = true;
        Integer first = 2;
        Iterator<Integer> i = this.id.iterator();
        int idx = 0;
        while (i.hasNext()) {
            int next = i.next();
            int point = -1;
            if (next == 2) {
                point = isFirst ? 1 : 2;
            } else {
                if (isFirst) {
                    isFirst = false;
                    first = next;
                }
                point = first == next ? 0 : 1;
            }
            this.hashCode = 3 * this.hashCode + point;
            if (useHashArray) {
                this.hashArray[current] = 3 * this.hashArray[current] + point;
                if (--remainder == 0) {
                    remainder = 20;
                    ++current;
                }
            }
            ++idx;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.id.toString();
    }

    public String toConsenseString() {
        String string = "";
        int i = 0;
        while (i < this.id.size()) {
            char c = '?';
            c = this.id.get(i) == 1 ? (char)'*' : (this.id.get(i) == 0 ? (char)'.' : '?');
            string = String.valueOf(string) + c;
            ++i;
        }
        return string;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i <= 20) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            String output = "";
            String[] strings = new String[]{BranchAnalysis.getAllPossibleKmers(new String[]{"."}, i)[0]};
            int j = 0;
            while (j < strings.length) {
                String string = strings[j];
                ArrayList<Integer> list = new ArrayList<Integer>();
                ArrayList<Integer> missingList = new ArrayList<Integer>();
                int k = 0;
                while (k < i) {
                    if (string.charAt(k) == '*') {
                        list.add(k);
                    } else if (string.charAt(k) == '?') {
                        missingList.add(k);
                    }
                    ++k;
                }
                BranchTag bt = new BranchTag(i, list, missingList);
                int hashCode = bt.hashCode();
                output = String.valueOf(output) + String.format("%-12s | %-12s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode);
                if (j < strings.length - 1) {
                    output = String.valueOf(output) + "\n";
                }
                if (min > hashCode) {
                    min = hashCode;
                }
                if (max < hashCode) {
                    max = hashCode;
                }
                ++j;
            }
            ++i;
        }
        int testLength = 41;
        int testIterations = 100000;
        int failedTests = 0;
        int i2 = 0;
        while (i2 < testIterations) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            ArrayList<Integer> altList = new ArrayList<Integer>();
            ArrayList<Integer> missingList = new ArrayList<Integer>();
            int j = 0;
            while (j < testLength) {
                double rand = Math.random();
                if (rand < 0.495) {
                    list.add(j);
                } else if (rand < 0.99) {
                    altList.add(j);
                } else {
                    missingList.add(j);
                }
                ++j;
            }
            BranchTag bt1 = new BranchTag(testLength, list, missingList);
            BranchTag bt2 = new BranchTag(testLength, altList, missingList);
            String out1 = String.format("%11d |", bt1.hashCode);
            String out2 = String.format("%11d |", bt2.hashCode);
            int j2 = 0;
            while (j2 < bt1.hashLength) {
                out1 = String.valueOf(out1) + " " + String.format("<%11d>", bt1.hashArray[j2]);
                out2 = String.valueOf(out2) + " " + String.format("<%11d>", bt2.hashArray[j2]);
                ++j2;
            }
            boolean hashCodeComparison = bt1.hashCode == bt2.hashCode;
            boolean hashArrayComparison = bt1.equals(bt2);
            if (!hashCodeComparison || !hashArrayComparison) {
                ++failedTests;
                System.out.println(String.valueOf(bt1.toConsenseString()) + String.format(" %s %s", hashCodeComparison ? "O" : "X", hashArrayComparison ? "O" : "X") + "\n" + out1 + "\n" + out2 + "\n");
            }
            ++i2;
        }
        System.out.printf("Test | l: %d | i: %d -> %d out of %d failed (Success Rate: %.2f%%)\n", testLength, testIterations, failedTests, testIterations, (double)(testIterations - failedTests) * 100.0 / (double)testIterations);
    }
}

