/*
 * Decompiled with CFR 0.152.
 */
package leb.uucgp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import leb.process.enumclass.AlignMode;
import leb.util.StreamGobbler;
import leb.uucgp.ProcessGobbler;

class multipleTreeRaxml
implements Callable<ProcessGobbler> {
    String alignedFastaFile;
    String run_id;
    String programPath;
    int[] counter;
    String ucg;
    AlignMode alignMode;
    int ucgNum;
    String outputDir;
    String model;

    public multipleTreeRaxml(String alignedFastaFile, String run_id, String programPath, int[] counter, String ucg, AlignMode alignMode, int ucgNum, String outputDir, String model) {
        this.alignedFastaFile = alignedFastaFile;
        this.run_id = run_id;
        this.programPath = programPath;
        this.counter = counter;
        this.ucg = ucg;
        this.alignMode = alignMode;
        this.ucgNum = ucgNum;
        this.outputDir = outputDir;
        this.model = model;
    }

    public static synchronized void updateCounter(String ucg, int[] counter, int ucgNum) {
        counter[0] = counter[0] + 1;
        String msg = "'" + ucg + "' tree was reconstructed. (" + counter[0] + " / " + ucgNum + ")";
        System.out.println(msg);
    }

    @Override
    public ProcessGobbler call() throws IOException {
        ArrayList<String> argTree = new ArrayList<String>();
        argTree.add(this.programPath);
        File inputFile = new File(this.alignedFastaFile);
        if (!inputFile.exists()) {
            return new ProcessGobbler(1, "Error : Input file '" + this.alignedFastaFile + "' dosen't exist to run RAxML!");
        }
        argTree.add("-s");
        argTree.add(this.alignedFastaFile);
        argTree.add("-n");
        argTree.add(String.valueOf(this.run_id) + "_" + this.ucg);
        if (this.model == null) {
            if (this.alignMode.equals((Object)AlignMode.protein)) {
                argTree.add("-m");
                argTree.add("PROTCATJTT");
            } else {
                argTree.add("-m");
                argTree.add("GTRCAT");
            }
        } else {
            argTree.add("-m");
            argTree.add(this.model);
        }
        argTree.add("-p");
        argTree.add("123");
        argTree.add("-f");
        argTree.add("a");
        argTree.add("-x");
        argTree.add("123");
        argTree.add("-N");
        argTree.add("100");
        Process tree = new ProcessBuilder(argTree).start();
        StreamGobbler outGobbler = new StreamGobbler(tree.getInputStream(), null, false);
        StreamGobbler errorGobbler = new StreamGobbler(tree.getErrorStream(), null, false);
        outGobbler.start();
        errorGobbler.start();
        try {
            tree.waitFor();
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        int exitValue = tree.exitValue();
        String errorLog = errorGobbler.LogMessage();
        ProcessGobbler processGobbler = new ProcessGobbler(exitValue, errorLog);
        new File("RAxML_bipartitions." + this.run_id + "_" + this.ucg).renameTo(new File(String.valueOf(this.outputDir) + this.run_id + File.separator + this.ucg + ".zZ.nwk"));
        new File("RAxML_bestTree." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_bipartitionsBranchLabels." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_bootstrap." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_info." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_log." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_parsimonyTree." + this.run_id + "_" + this.ucg).delete();
        new File("RAxML_result." + this.run_id + "_" + this.ucg).delete();
        File reducedFile = new File(String.valueOf(this.alignedFastaFile) + ".reduced");
        if (reducedFile.exists()) {
            reducedFile.delete();
        }
        multipleTreeRaxml.updateCounter(this.ucg, this.counter, this.ucgNum);
        return processGobbler;
    }
}

