/*
 * Decompiled with CFR 0.152.
 */
package leb.uucgp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import leb.process.enumclass.AlignMode;
import leb.util.StreamGobbler;
import leb.uucgp.ProcessGobbler;

class multipleTree
implements Callable<ProcessGobbler> {
    String alignedFastaFile;
    String run_id;
    String programPath;
    int[] counter;
    String ucg;
    AlignMode alignMode;
    int ucgNum;
    String outputDir;
    String model;

    public multipleTree(String alignedFastaFile, String run_id, String programPath, int[] counter, String ucg, AlignMode alignMode, int ucgNum, String outputDir, String model) {
        this.alignedFastaFile = alignedFastaFile;
        this.run_id = run_id;
        this.programPath = programPath;
        this.counter = counter;
        this.ucg = ucg;
        this.alignMode = alignMode;
        this.ucgNum = ucgNum;
        this.outputDir = outputDir;
        this.model = model;
    }

    public static synchronized void updateCounter(String ucg, int[] counter, int ucgNum) {
        counter[0] = counter[0] + 1;
        String msg = "'" + ucg + "' tree was reconstructed. (" + counter[0] + " / " + ucgNum + ")";
        System.out.println(msg);
    }

    @Override
    public ProcessGobbler call() throws IOException {
        ArrayList<String> argTree = new ArrayList<String>();
        argTree.add("bash");
        argTree.add("-c");
        File inputFile = new File(this.alignedFastaFile);
        if (!inputFile.exists()) {
            ProcessGobbler processGobbler = new ProcessGobbler(1, "Error : Input file '" + this.alignedFastaFile + "' dosen't exist to run FastTree!");
            return processGobbler;
        }
        if (this.model == null) {
            if (this.alignMode.equals((Object)AlignMode.protein)) {
                argTree.add(String.valueOf(this.programPath) + " " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else {
                argTree.add(String.valueOf(this.programPath) + " -nt -gtr < " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            }
        } else if (this.alignMode.equals((Object)AlignMode.protein)) {
            if (this.model.equalsIgnoreCase("JTTcat")) {
                argTree.add(String.valueOf(this.programPath) + " " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else if (this.model.equalsIgnoreCase("LGcat")) {
                argTree.add(String.valueOf(this.programPath) + " -lg " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else if (this.model.equalsIgnoreCase("WAGcat")) {
                argTree.add(String.valueOf(this.programPath) + " -wag " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else if (this.model.equalsIgnoreCase("JTTgamma")) {
                argTree.add(String.valueOf(this.programPath) + " -gamma " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else if (this.model.equalsIgnoreCase("LGgamma")) {
                argTree.add(String.valueOf(this.programPath) + " -lg -gamma " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            } else if (this.model.equalsIgnoreCase("WAGgamma")) {
                argTree.add(String.valueOf(this.programPath) + " -wag -gamma " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
            }
        } else if (this.model.equalsIgnoreCase("JCcat")) {
            argTree.add(String.valueOf(this.programPath) + " -nt " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
        } else if (this.model.equalsIgnoreCase("GTRcat")) {
            argTree.add(String.valueOf(this.programPath) + " -nt -gtr < " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
        } else if (this.model.equalsIgnoreCase("JCgamma")) {
            argTree.add(String.valueOf(this.programPath) + " -nt -gamma < " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
        } else if (this.model.equalsIgnoreCase("GTRgamma")) {
            argTree.add(String.valueOf(this.programPath) + " -nt -gtr -gamma < " + this.alignedFastaFile + " > " + this.outputDir + this.run_id + File.separator + this.ucg + ".zZ.nwk");
        }
        Process tree = new ProcessBuilder(argTree).start();
        StreamGobbler outGobbler = new StreamGobbler(tree.getInputStream(), null, false);
        StreamGobbler errorGobbler = new StreamGobbler(tree.getErrorStream(), null, false);
        outGobbler.start();
        errorGobbler.start();
        try {
            tree.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int exitValue = tree.exitValue();
        String errorLog = errorGobbler.LogMessage();
        multipleTree.updateCounter(this.ucg, this.counter, this.ucgNum);
        ProcessGobbler processGobbler = new ProcessGobbler(exitValue, errorLog);
        return processGobbler;
    }
}

