/*
 * Decompiled with CFR 0.152.
 */
package leb.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import leb.domain.DetectedGeneDomain;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeneSetByGenomeDomain
implements Serializable {
    private static final long serialVersionUID = 4383968253887214194L;
    private Long uid = Math.abs(new Random().nextLong());
    private String label = null;
    private String targetTaxon = null;
    private String accession = null;
    private String taxonName = null;
    private String ncbiName = null;
    private String strainName = null;
    private Boolean isTpyeStrain = null;
    private String strainProperty = null;
    private String taxonomy = null;
    private String runTime = null;
    private int targetGenes = 0;
    private String usedHmmProfile = null;
    private String targetGeneSet = null;
    private int totalDetectedGenes = 0;
    private int singleCopyGenes = 0;
    private int multipleCopyGenes = 0;
    private int paralogs = 0;
    private HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = new HashMap();

    public JSONObject toJsonObject() {
        JSONObject genomeInfoJO = new JSONObject();
        JSONObject runInfoJO = new JSONObject();
        JSONObject dataJO = new JSONObject();
        try {
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "uid", this.uid);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "label", this.label);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "target_taxon", this.targetTaxon);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "accession", this.accession);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "taxon_name", this.taxonName);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "ncbi_name", this.ncbiName);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "strain_name", this.strainName);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "isTypeStrain", this.isTpyeStrain);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "strain_property", this.strainProperty);
            GeneSetByGenomeDomain.putJsonObjectValueNull(genomeInfoJO, "taxonomy", this.taxonomy);
            runInfoJO.put("n_paralogs", this.paralogs);
            runInfoJO.put("n_multiple_copy_genes", this.multipleCopyGenes);
            runInfoJO.put("n_single_copy_genes", this.singleCopyGenes);
            runInfoJO.put("n_total_detected_genes", this.totalDetectedGenes);
            runInfoJO.put("target_gene_set", this.targetGeneSet);
            runInfoJO.put("used_hmm_profile", this.usedHmmProfile);
            runInfoJO.put("n_target_genes", this.targetGenes);
            runInfoJO.put("run_time", this.runTime);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        for (String gene : this.dataMap.keySet()) {
            ArrayList<DetectedGeneDomain> dgdL = this.dataMap.get(gene);
            JSONArray dgdJL = new JSONArray();
            for (DetectedGeneDomain dgd : dgdL) {
                JSONObject dgdJO = dgd.toJsonObject();
                dgdJL.put(dgdJO);
            }
            try {
                dataJO.put(gene, dgdJL);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        JSONObject geneSetByGenomeJO = new JSONObject();
        try {
            geneSetByGenomeJO.put("genome_info", genomeInfoJO);
            geneSetByGenomeJO.put("run_info", runInfoJO);
            geneSetByGenomeJO.put("data", dataJO);
        }
        catch (JSONException e3) {
            e3.printStackTrace();
        }
        return geneSetByGenomeJO;
    }

    public static GeneSetByGenomeDomain jsonToDomain(String geneSetJson) throws JSONException {
        GeneSetByGenomeDomain geneSet = new GeneSetByGenomeDomain();
        JSONObject geneSetJO = GeneSetByGenomeDomain.stringToJsonObject(geneSetJson);
        geneSet = GeneSetByGenomeDomain.jsonToDomain(geneSetJO);
        return geneSet;
    }

    public static GeneSetByGenomeDomain jsonToDomain(JSONObject geneSetJO) throws JSONException {
        GeneSetByGenomeDomain geneSet = new GeneSetByGenomeDomain();
        JSONObject genomeInfoJO = (JSONObject)geneSetJO.get("genome_info");
        JSONObject runInfoJO = (JSONObject)geneSetJO.get("run_info");
        JSONObject dataJO = (JSONObject)geneSetJO.get("data");
        Object object = genomeInfoJO.get("uid");
        long uid = 0L;
        if (object instanceof Integer) {
            uid = ((Integer)object).intValue();
            geneSet.setUid(uid);
        } else {
            geneSet.setUid((long)((Long)genomeInfoJO.get("uid")));
        }
        geneSet.setLabel((String)genomeInfoJO.get("label"));
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "target_taxon")) {
            Object target_taxon = genomeInfoJO.get("target_taxon");
            if (target_taxon == JSONObject.NULL) {
                geneSet.setTargetTaxon(null);
            } else {
                geneSet.setTargetTaxon((String)target_taxon);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "accession")) {
            Object accession = genomeInfoJO.get("accession");
            if (accession == JSONObject.NULL) {
                geneSet.setAccession(null);
            } else {
                geneSet.setAccession((String)accession);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "taxon_name")) {
            Object taxon_name = genomeInfoJO.get("taxon_name");
            if (taxon_name == JSONObject.NULL) {
                geneSet.setTaxonName(null);
            } else {
                geneSet.setTaxonName((String)taxon_name);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "ncbi_name")) {
            Object ncbi_name = genomeInfoJO.get("ncbi_name");
            if (ncbi_name == JSONObject.NULL) {
                geneSet.setNcbiName(null);
            } else {
                geneSet.setNcbiName((String)ncbi_name);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "strain_name")) {
            Object strain_name = genomeInfoJO.get("strain_name");
            if (strain_name == JSONObject.NULL) {
                geneSet.setStrainName(null);
            } else {
                geneSet.setStrainName((String)strain_name);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "isTypeStrain")) {
            Object isTypeStrain = genomeInfoJO.get("isTypeStrain");
            if (isTypeStrain == JSONObject.NULL) {
                geneSet.setIsTpyeStrain(null);
            } else {
                geneSet.setIsTpyeStrain((boolean)((Boolean)isTypeStrain));
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "strain_property")) {
            Object strain_property = genomeInfoJO.get("strain_property");
            if (strain_property == JSONObject.NULL) {
                geneSet.setStrainPproperty(null);
            } else {
                geneSet.setStrainPproperty((String)strain_property);
            }
        }
        if (GeneSetByGenomeDomain.containKey(genomeInfoJO, "taxonomy")) {
            Object taxonomy = genomeInfoJO.get("taxonomy");
            if (taxonomy == JSONObject.NULL) {
                geneSet.setTaxonomy(null);
            } else {
                geneSet.setTaxonomy((String)taxonomy);
            }
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "run_time")) {
            geneSet.setRunTime((String)runInfoJO.get("run_time"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "run_time")) {
            geneSet.setTargetGenes((Integer)runInfoJO.get("n_target_genes"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "target_gene_set")) {
            geneSet.setTargetGeneSet((String)runInfoJO.get("target_gene_set"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "n_total_detected_genes")) {
            geneSet.setTotalDetectedGenes((Integer)runInfoJO.get("n_total_detected_genes"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "n_single_copy_genes")) {
            geneSet.setSingleCopyGenes((Integer)runInfoJO.get("n_single_copy_genes"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "n_multiple_copy_genes")) {
            geneSet.setMultipleCopyGenes((Integer)runInfoJO.get("n_multiple_copy_genes"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "n_paralogs")) {
            geneSet.setParalogs((Integer)runInfoJO.get("n_paralogs"));
        }
        if (GeneSetByGenomeDomain.containKey(runInfoJO, "used_hmm_profile")) {
            geneSet.setUsedHmmProfile((String)runInfoJO.get("used_hmm_profile"));
        }
        HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = new HashMap<String, ArrayList<DetectedGeneDomain>>();
        Iterator<String> dataIterator = dataJO.keys();
        while (dataIterator.hasNext()) {
            String geneName = dataIterator.next();
            JSONArray jsonArray = (JSONArray)dataJO.get(geneName);
            ArrayList<DetectedGeneDomain> detectedGeneDomainList = new ArrayList<DetectedGeneDomain>();
            int i = 0;
            while (i < jsonArray.length()) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                DetectedGeneDomain detectedGeneDomain = new DetectedGeneDomain(jsonObject);
                detectedGeneDomainList.add(detectedGeneDomain);
                ++i;
            }
            dataMap.put(geneName, detectedGeneDomainList);
        }
        geneSet.setDataMap(dataMap);
        return geneSet;
    }

    private static JSONObject stringToJsonObject(String geneSetJson) throws JSONException {
        JSONObject geneSetJO = new JSONObject(geneSetJson);
        return geneSetJO;
    }

    private static boolean containKey(JSONObject jsonObject, String key) {
        return jsonObject.keySet().contains(key);
    }

    private static void putJsonObjectValueNull(JSONObject jsonObject, String key, Object object) {
        if (object != null) {
            jsonObject.put(key, object);
        } else {
            jsonObject.put(key, JSONObject.NULL);
        }
    }

    public String getStrainProperty() {
        return this.strainProperty;
    }

    public void setStrainProperty(String strainProperty) {
        this.strainProperty = strainProperty;
    }

    public String getUsedHmmProfile() {
        return this.usedHmmProfile;
    }

    public void setUsedHmmProfile(String usedHmmProfile) {
        this.usedHmmProfile = usedHmmProfile;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTargetTaxon() {
        return this.targetTaxon;
    }

    public void setTargetTaxon(String targetTaxon) {
        this.targetTaxon = targetTaxon;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public String getTaxonName() {
        return this.taxonName;
    }

    public void setTaxonName(String taxonName) {
        this.taxonName = taxonName;
    }

    public String getNcbiName() {
        return this.ncbiName;
    }

    public void setNcbiName(String ncbiName) {
        this.ncbiName = ncbiName;
    }

    public String getStrainName() {
        return this.strainName;
    }

    public void setStrainName(String strainName) {
        this.strainName = strainName;
    }

    public Boolean getIsTpyeStrain() {
        return this.isTpyeStrain;
    }

    public void setIsTpyeStrain(Boolean isTpyeStrain) {
        this.isTpyeStrain = isTpyeStrain;
    }

    public String getStrainPproperty() {
        return this.strainProperty;
    }

    public void setStrainPproperty(String strainPproperty) {
        this.strainProperty = strainPproperty;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
    }

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public int getTargetGenes() {
        return this.targetGenes;
    }

    public void setTargetGenes(int targetGenes) {
        this.targetGenes = targetGenes;
    }

    public String getTargetGeneSet() {
        return this.targetGeneSet;
    }

    public void setTargetGeneSet(String targetGeneSet) {
        this.targetGeneSet = targetGeneSet;
    }

    public int getTotalDetectedGenes() {
        return this.totalDetectedGenes;
    }

    public void setTotalDetectedGenes(int totalDetectedGenes) {
        this.totalDetectedGenes = totalDetectedGenes;
    }

    public int getSingleCopyGenes() {
        return this.singleCopyGenes;
    }

    public void setSingleCopyGenes(int singleCopyGenes) {
        this.singleCopyGenes = singleCopyGenes;
    }

    public int getMultipleCopyGenes() {
        return this.multipleCopyGenes;
    }

    public void setMultipleCopyGenes(int multipleCopyGenes) {
        this.multipleCopyGenes = multipleCopyGenes;
    }

    public int getParalogs() {
        return this.paralogs;
    }

    public void setParalogs(int paralogs) {
        this.paralogs = paralogs;
    }

    public HashMap<String, ArrayList<DetectedGeneDomain>> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(HashMap<String, ArrayList<DetectedGeneDomain>> dataMap) {
        this.dataMap = dataMap;
    }

    public static long getSerialversionuid() {
        return 4383968253887214194L;
    }
}

