/*
 * Decompiled with CFR 0.152.
 */
package leb.uucgp;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lbj.BranchAnalysis;
import leb.domain.DetectedGeneDomain;
import leb.domain.GeneSetByGenomeDomain;
import leb.process.enumclass.AlignMode;
import leb.process.enumclass.PhylogenyTool;
import leb.seq.FastaSeq;
import leb.seq.FastaSeqList;
import leb.util.StreamGobbler;
import leb.util.common.FileUtils;
import leb.uucgp.LabelReplacer;
import leb.uucgp.ProcessGobbler;
import leb.uucgp.multipleAlign;
import leb.uucgp.multipleTree;
import leb.uucgp.multipleTreeRaxml;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcAlign {
    private String ucgDirectory = null;
    private String outDirectory = null;
    private String runOutDirName = null;
    private String mafftPath = null;
    private String raxmlPath = null;
    private String fastTreePath = null;
    private AlignMode alignMode = AlignMode.codon;
    private int filtering = 50;
    private String model = null;
    private int gsi_threshold = 95;
    private List<String> outputLabels = null;
    private ArrayList<Long> genomeList = null;
    private HashMap<String, String> replaceMap = null;
    private ArrayList<String> targetGenes = null;
    private HashSet<String> usedGenes = null;
    private String treeZzFileName = null;
    private String treeZzGsiFileName = null;
    private String concatenatedSeqFileName = null;
    private String concatenatedSeqLabelFileName = null;
    private String treeLabelFileName = null;
    private String treeLabelGsiFileName = null;
    private String allGeneTreesFile = null;
    private String logFileName = null;
    private String trmFile = null;

    public ProcAlign(String ucgDirectory, String outDirectory, String runOutDirName, String mafftPath, String raxmlPath, String fastTreePath, AlignMode alignMode, int filtering, String model, int gsi_threshold, List<String> outputLabels) {
        if (!ucgDirectory.endsWith(File.separator)) {
            ucgDirectory = String.valueOf(ucgDirectory) + File.separator;
        }
        this.ucgDirectory = ucgDirectory;
        if (!outDirectory.endsWith(File.separator)) {
            outDirectory = String.valueOf(outDirectory) + File.separator;
        }
        this.outDirectory = outDirectory;
        this.runOutDirName = String.valueOf(String.valueOf(new Timestamp(System.currentTimeMillis()).getTime())) + File.separator;
        if (runOutDirName != null && !runOutDirName.equals("")) {
            if (!runOutDirName.endsWith(File.separator)) {
                runOutDirName = String.valueOf(runOutDirName) + File.separator;
            }
            this.runOutDirName = runOutDirName;
        }
        this.mafftPath = mafftPath;
        this.raxmlPath = raxmlPath;
        this.fastTreePath = fastTreePath;
        this.genomeList = new ArrayList();
        this.replaceMap = new HashMap();
        this.targetGenes = new ArrayList();
        this.usedGenes = new HashSet();
        this.concatenatedSeqFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_concatenated.zZ.fasta";
        this.concatenatedSeqLabelFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_concatenated.fasta";
        this.treeZzFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "concatenated." + (Object)((Object)alignMode) + ".zZ.nwk";
        this.treeLabelFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "concatenated" + ".nwk";
        this.allGeneTreesFile = String.valueOf(this.outDirectory) + this.runOutDirName + "all_genetrees.txt";
        this.logFileName = String.valueOf(this.outDirectory) + this.runOutDirName + runOutDirName.replace(File.separator, "") + ".log";
        this.trmFile = String.valueOf(this.outDirectory) + this.runOutDirName + runOutDirName.replace(File.separator, "") + ".trm";
        if (filtering <= 0 || filtering > 100) {
            System.err.print("filtering must be a value between 1~100. Exit!");
            System.exit(1);
        }
        this.alignMode = alignMode;
        this.filtering = filtering;
        this.model = model;
        this.gsi_threshold = gsi_threshold;
        this.outputLabels = outputLabels;
    }

    public void jsonsToTree(int nThreads, PhylogenyTool tool) throws IOException {
        this.checkThirdPartyPrograms(tool);
        this.readJsonsToFastaFiles();
        this.alignGenes(nThreads);
        this.concatenateAlignedGenesRemoveGaps();
        this.inferTree(tool, nThreads);
        this.inferGeneTrees(tool, nThreads);
        this.calculateGsi();
        this.replaceLabel();
        this.deleteFiles();
    }

    void readJsonsToFastaFiles() throws IOException {
        this.checkPathDirectory();
        File dir = new File(this.ucgDirectory);
        if (!dir.exists()) {
            System.err.println("Error occurred! " + this.ucgDirectory + " doesn't exists.");
            System.err.println("Exit!");
            System.exit(1);
        }
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ucg");
            }
        });
        this.checkIfSameTargetGeneSets(files);
        List<GeneSetByGenomeDomain> geneSetsDomainList = this.jsonsToGeneSetDomains(files);
        HashMap<String, Integer> labelCountMap = new HashMap<String, Integer>();
        HashSet<Long> uidSet = new HashSet<Long>();
        for (GeneSetByGenomeDomain domain : geneSetsDomainList) {
            long uid = domain.getUid();
            this.genomeList.add(uid);
            if (!uidSet.add(uid)) {
                System.err.println("Error! There are duplicate uids. Uid must be unique.");
                System.err.println("Exit!");
                System.exit(1);
            }
            String label = "";
            if (this.outputLabels.contains("uid")) {
                label = String.valueOf(label) + "|" + domain.getUid();
            }
            if (this.outputLabels.contains("acc")) {
                label = String.valueOf(label) + "|" + domain.getAccession();
            }
            if (this.outputLabels.contains("label")) {
                label = String.valueOf(label) + "|" + domain.getLabel();
            }
            if (this.outputLabels.contains("taxon")) {
                label = String.valueOf(label) + "|" + domain.getTaxonName();
            }
            if (this.outputLabels.contains("strain")) {
                label = String.valueOf(label) + "|" + domain.getStrainName();
            }
            if (this.outputLabels.contains("taxonomy")) {
                label = String.valueOf(label) + "|" + domain.getTaxonomy();
            }
            if (this.outputLabels.contains("type") && domain.getIsTpyeStrain() != null && domain.getIsTpyeStrain().booleanValue()) {
                label = String.valueOf(label) + "|TYPE";
            }
            if (label.startsWith("|")) {
                label = label.substring(1);
            }
            if (labelCountMap.containsKey(label)) {
                labelCountMap.put(label, (Integer)labelCountMap.get(label) + 1);
            } else {
                labelCountMap.put(label, 1);
            }
            if ((Integer)labelCountMap.get(label) != 1) {
                label = String.valueOf(label) + "_" + labelCountMap.get(label);
            }
            this.replaceMap.put(String.valueOf(uid), label);
        }
        this.writeGenomeInfoToLogFile(geneSetsDomainList);
        if (this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            this.retrieveFastaNucProFiles(geneSetsDomainList);
        } else if (this.alignMode.equals((Object)AlignMode.nucleotide) || this.alignMode.equals((Object)AlignMode.protein)) {
            this.retrieveFastaFiles(geneSetsDomainList);
        }
    }

    void alignGenes(int nThreads) {
        int geneNum = this.usedGenes.size();
        System.out.println("Aligning each gene..");
        System.out.println();
        System.out.println("Total # of genes to be aligned : " + geneNum);
        System.out.println();
        this.align(nThreads);
        System.out.println();
        System.out.println("MSA is finished!");
        System.out.println();
        if (this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            this.proAlignToCodon();
        }
    }

    void concatenateAlignedGenesRemoveGaps() {
        System.out.println("Concatenating aligned genes..");
        System.out.println();
        ArrayList<String> fileList = new ArrayList<String>();
        for (String gene : this.usedGenes) {
            fileList.add(this.alignedFinalGeneFastaFile(gene));
        }
        HashMap<String, Integer> geneLengthMap = new HashMap<String, Integer>();
        LinkedHashMap<String, FastaSeqList> geneFastaSeqListMap = new LinkedHashMap<String, FastaSeqList>();
        for (String fileName : fileList) {
            FastaSeqList fsl = new FastaSeqList();
            fsl.importFile(fileName);
            Integer seqLength = null;
            for (FastaSeq fastaSeq : fsl.list) {
                if (seqLength == null) {
                    seqLength = fastaSeq.sequence.length();
                    continue;
                }
                if (seqLength.intValue() == fastaSeq.sequence.length()) continue;
                System.out.println("Error : \"" + fileName + "\" has different sequence length.");
                System.exit(1);
            }
            geneLengthMap.put(fileName, seqLength);
            geneFastaSeqListMap.put(fileName, fsl);
        }
        String tmpFileName = String.valueOf(this.concatenatedSeqFileName) + "_tmp";
        try {
            String tmpFasta = "";
            int count = 0;
            for (Long genomeUid : this.genomeList) {
                String zZgenomeUid = "zZ" + genomeUid + "zZ";
                StringBuffer concatenatedFasta = new StringBuffer();
                if (count == 0) {
                    concatenatedFasta.append(">" + zZgenomeUid + "\n");
                } else {
                    concatenatedFasta.append("\n>" + zZgenomeUid + "\n");
                }
                ++count;
                for (String key : geneFastaSeqListMap.keySet()) {
                    if (((FastaSeqList)geneFastaSeqListMap.get(key)).find(String.valueOf(zZgenomeUid)) == null) {
                        StringBuffer gaps = new StringBuffer();
                        int i = 0;
                        while (i < (Integer)geneLengthMap.get(key)) {
                            gaps.append("-");
                            ++i;
                        }
                        concatenatedFasta.append(gaps.toString());
                        continue;
                    }
                    concatenatedFasta.append(((FastaSeqList)geneFastaSeqListMap.get((Object)key)).find((String)zZgenomeUid).sequence);
                }
                tmpFasta = String.valueOf(tmpFasta) + concatenatedFasta.toString();
            }
            String filteredFasta = this.removeGapColumns(tmpFasta);
            FileWriter fileWriter = new FileWriter(this.concatenatedSeqFileName);
            fileWriter.append(filteredFasta);
            fileWriter.close();
        }
        catch (IOException e) {
            e.getMessage();
            System.err.println("Error : Cannot write a file in the directory '" + this.outDirectory + this.runOutDirName);
            System.exit(1);
        }
    }

    void inferTree(PhylogenyTool tool, int nThreads) {
        System.out.println("Reconstructing the final tree..");
        if (tool.equals((Object)PhylogenyTool.raxml)) {
            this.runRaxml(nThreads);
        } else if (tool.equals((Object)PhylogenyTool.fasttree)) {
            this.runFasttree(nThreads);
        }
        System.out.println("The final tree is written in " + this.treeLabelFileName);
        System.out.println();
    }

    void inferGeneTrees(PhylogenyTool phylogenyTool, int nThreads) {
        Future<ProcessGobbler> f;
        System.out.println("Reconstructing gene trees..");
        System.out.println();
        StringBuffer logSB = new StringBuffer();
        File concatFile = new File(this.concatenatedSeqFileName);
        FastaSeqList conFsl = new FastaSeqList();
        conFsl.importFile(concatFile);
        logSB.append("//\n\n");
        logSB.append("Length of the concatenated alignment: " + conFsl.list.get((int)1).sequence.length());
        logSB.append("\n\n");
        logSB.append("Length of gene alignments\n");
        int[] counterTree = new int[1];
        for (String ucg : this.usedGenes) {
            String alignedGene = this.alignedFinalGeneFastaFile(ucg);
            File file = new File(alignedGene);
            if (!file.exists()) continue;
            Iterator<String> fsl = new FastaSeqList();
            ((FastaSeqList)((Object)fsl)).importFile(file);
            logSB.append(String.valueOf(ucg) + ": " + ((FastaSeqList)((Object)fsl)).list.get((int)0).sequence.length() + "\n");
        }
        try {
            FileWriter logFW = new FileWriter(this.logFileName, true);
            logFW.append(logSB);
            logFW.flush();
            logFW.close();
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.err.println("Exit!");
            System.exit(1);
        }
        int numOfGenes = this.usedGenes.size();
        System.out.println("Total number of gene trees to be reconstructed : " + numOfGenes);
        System.out.println();
        ExecutorService exeServiceTree = Executors.newFixedThreadPool(nThreads);
        ArrayList<Future<ProcessGobbler>> futures = new ArrayList<Future<ProcessGobbler>>();
        if (phylogenyTool.equals((Object)PhylogenyTool.raxml)) {
            for (String string : this.usedGenes) {
                f = exeServiceTree.submit(new multipleTreeRaxml(this.alignedFinalGeneFastaFile(string), this.runOutDirName.replace(File.separator, ""), this.raxmlPath, counterTree, string, this.alignMode, numOfGenes, this.outDirectory, this.model));
                futures.add(f);
            }
        } else {
            for (String string : this.usedGenes) {
                f = exeServiceTree.submit(new multipleTree(this.alignedFinalGeneFastaFile(string), this.runOutDirName.replace(File.separator, ""), this.fastTreePath, counterTree, string, this.alignMode, numOfGenes, this.outDirectory, this.model));
                futures.add(f);
            }
        }
        exeServiceTree.shutdown();
        try {
            for (Future future : futures) {
                ProcessGobbler processGobbler = (ProcessGobbler)future.get();
                if (processGobbler.getExitValue() == 0) continue;
                System.err.println("Error occurred!");
                System.err.println("log|" + processGobbler.getLog());
                System.exit(1);
            }
            while (!exeServiceTree.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error occurred!");
            System.err.println(interruptedException.getMessage());
            System.err.println("Exit!");
            System.exit(1);
        }
        catch (ExecutionException executionException) {
            System.err.println("Error occurred!");
            System.err.println(executionException.getMessage());
            System.err.println("Exit!");
            System.exit(1);
        }
        System.out.println("All of the gene trees were reconstructed.");
        System.out.println();
        StringBuffer stringBuffer = new StringBuffer();
        for (String ucg : this.usedGenes) {
            String geneTree = String.valueOf(this.outDirectory) + this.runOutDirName + ucg + ".zZ.nwk";
            try {
                File treeFile = new File(geneTree);
                FileReader treeReader = new FileReader(treeFile);
                BufferedReader br = new BufferedReader(treeReader);
                stringBuffer.append(br.readLine()).append("\n");
                br.close();
                treeReader.close();
            }
            catch (IOException e) {
                System.err.println("Error : Cannot read gene tree '" + geneTree + "'.");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        try {
            FileWriter mergeWriter = new FileWriter(this.allGeneTreesFile);
            mergeWriter.append(stringBuffer);
            mergeWriter.close();
        }
        catch (IOException e) {
            System.err.println("Error : Cannot write a file in the directory.");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    void calculateGsi() {
        System.out.println("Calculating Gene Support Indices (GSIs) from the gene trees..");
        System.out.println();
        File ucgJsonDir = new File(this.ucgDirectory);
        File[] tempUcgJsonFileList = ucgJsonDir.listFiles();
        int genomeNum = 0;
        File[] fileArray = tempUcgJsonFileList;
        int n = tempUcgJsonFileList.length;
        int n2 = 0;
        while (n2 < n) {
            File jsonFile = fileArray[n2];
            if (jsonFile.getName().endsWith(".ucg")) {
                ++genomeNum;
            }
            ++n2;
        }
        BranchAnalysis branchAnalysis = new BranchAnalysis(new File(this.allGeneTreesFile));
        String tmp = branchAnalysis.markTree(new File(this.treeZzFileName), false, true, -1, (100 - this.gsi_threshold) * genomeNum / 100);
        this.treeZzGsiFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "concatenated_gsi(" + this.usedGenes.size() + ")." + ".zZ.nwk";
        this.treeLabelGsiFileName = String.valueOf(this.outDirectory) + this.runOutDirName + "concatenated_gsi(" + this.usedGenes.size() + ")" + ".nwk";
        try {
            FileWriter stFW = new FileWriter(this.treeZzGsiFileName);
            BufferedWriter stBW = new BufferedWriter(stFW);
            stBW.append(tmp);
            stBW.close();
            stFW.close();
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.err.println("Exit!");
            System.exit(1);
        }
        JSONObject trmJson = new JSONObject();
        try {
            String line;
            FileReader fr = new FileReader(this.treeZzFileName);
            BufferedReader br = new BufferedReader(fr);
            String ucgNwk = br.readLine();
            trmJson.put("UBCG", ucgNwk);
            for (String ucg : this.usedGenes) {
                FileReader geneFR = new FileReader(String.valueOf(this.outDirectory) + this.runOutDirName + ucg + ".zZ.nwk");
                BufferedReader geneBR = new BufferedReader(geneFR);
                String geneNwk = geneBR.readLine();
                trmJson.put(ucg, geneNwk);
            }
            JSONArray listArray = new JSONArray();
            FileReader logFR = new FileReader(this.logFileName);
            BufferedReader logBR = new BufferedReader(logFR);
            boolean list = false;
            while ((line = logBR.readLine()) != null) {
                if (line.startsWith("//")) break;
                if (list) {
                    String[] metadata = line.split("\t");
                    JSONArray ar = new JSONArray();
                    String[] stringArray = metadata;
                    int n3 = metadata.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String data = stringArray[n4];
                        ar.put(data);
                        ++n4;
                    }
                    listArray.put(ar);
                    continue;
                }
                if (!line.startsWith("Genomes included in the analysis")) continue;
                list = true;
                logBR.readLine();
            }
            trmJson.put("list", listArray);
            FileWriter trmFW = new FileWriter(this.trmFile);
            trmFW.append(trmJson.toString());
            trmFW.flush();
            trmFW.close();
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.err.println("Exit!");
            System.exit(1);
        }
    }

    void replaceLabel() {
        LabelReplacer replacer = new LabelReplacer();
        replacer.replace_name_delete(this.concatenatedSeqFileName, this.concatenatedSeqLabelFileName, this.replaceMap);
        replacer.replace_name_delete(this.treeZzFileName, this.treeLabelFileName, this.replaceMap);
        replacer.replace_name_delete(this.treeZzGsiFileName, this.treeLabelGsiFileName, this.replaceMap);
        for (String ucg : this.usedGenes) {
            String fastaFile = this.fastaFileName(ucg);
            String fastaLabelFile = this.fastaLabelFileName(ucg);
            String alignedGene = this.alignedFinalGeneFastaFile(ucg);
            String alignedLabelGene = this.alignedFinalGeneFastaLabelFile(ucg);
            String geneTreeFile = String.valueOf(this.outDirectory) + this.runOutDirName + ucg + ".zZ.nwk";
            String geneTreeLabelFile = String.valueOf(this.outDirectory) + this.runOutDirName + ucg + ".nwk";
            replacer.replace_name_delete(fastaFile, fastaLabelFile, this.replaceMap);
            replacer.replace_name_delete(alignedGene, alignedLabelGene, this.replaceMap);
            replacer.replace_name_delete(geneTreeFile, geneTreeLabelFile, this.replaceMap);
        }
        if (this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            for (String gene : this.usedGenes) {
                String nucLabelFasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_nuc.fasta";
                replacer.replace_name_delete(this.fastaFileName(gene, AlignMode.nucleotide), nucLabelFasta, this.replaceMap);
            }
        }
        System.out.println("The final tree marked with GSI was written to '" + this.treeLabelGsiFileName);
        System.out.println();
    }

    void deleteFiles() {
        if (this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            for (String gene : this.usedGenes) {
                File alignedProFasta = new File(this.alignedFastaFileName(gene));
                if (!alignedProFasta.exists()) continue;
                alignedProFasta.delete();
            }
        }
    }

    private void runRaxml(int nThreads) {
        ArrayList<String> argTree = new ArrayList<String>();
        String prefix = this.runOutDirName.substring(0, this.runOutDirName.length() - 1);
        argTree.add(this.raxmlPath);
        argTree.add("-s");
        argTree.add(this.concatenatedSeqFileName);
        argTree.add("-n");
        argTree.add(prefix);
        argTree.add("-T");
        argTree.add(Integer.toString(nThreads));
        if (this.model == null) {
            if (this.alignMode.equals((Object)AlignMode.protein)) {
                argTree.add("-m");
                argTree.add("PROTCATJTT");
            } else {
                argTree.add("-m");
                argTree.add("GTRCAT");
            }
        } else {
            argTree.add("-m");
            argTree.add(this.model);
        }
        argTree.add("-p");
        argTree.add("123");
        argTree.add("-f");
        argTree.add("a");
        argTree.add("-x");
        argTree.add("123");
        argTree.add("-N");
        argTree.add("100");
        this.runPhylogenyToolByProcess(argTree, PhylogenyTool.raxml);
        new File("RAxML_bipartitions." + prefix).renameTo(new File(this.treeZzFileName));
        new File("RAxML_bestTree." + prefix).delete();
        new File("RAxML_bipartitionsBranchLabels." + prefix).delete();
        new File("RAxML_bootstrap." + prefix).delete();
        new File("RAxML_info." + prefix).delete();
        new File("RAxML_log." + prefix).delete();
        new File("RAxML_parsimonyTree." + prefix).delete();
        new File("RAxML_result." + prefix).delete();
    }

    private void runFasttree(int nThreads) {
        ArrayList<String> argTree = new ArrayList<String>();
        argTree.add("bash");
        argTree.add("-c");
        if (this.model == null) {
            if (this.alignMode.equals((Object)AlignMode.protein)) {
                argTree.add(String.valueOf(this.fastTreePath) + " " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else {
                argTree.add(String.valueOf(this.fastTreePath) + " -nt -gtr < " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            }
        } else if (this.alignMode.equals((Object)AlignMode.protein)) {
            if (this.model.equalsIgnoreCase("JTTcat")) {
                argTree.add(String.valueOf(this.fastTreePath) + " " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else if (this.model.equalsIgnoreCase("LGcat")) {
                argTree.add(String.valueOf(this.fastTreePath) + " -lg " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else if (this.model.equalsIgnoreCase("WAGcat")) {
                argTree.add(String.valueOf(this.fastTreePath) + " -wag " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else if (this.model.equalsIgnoreCase("JTTgamma")) {
                argTree.add(String.valueOf(this.fastTreePath) + " -gamma " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else if (this.model.equalsIgnoreCase("LGgamma")) {
                argTree.add(String.valueOf(this.fastTreePath) + " -lg -gamma " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            } else if (this.model.equalsIgnoreCase("WAGgamma")) {
                argTree.add(String.valueOf(this.fastTreePath) + " -wag -gamma " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
            }
        } else if (this.model.equalsIgnoreCase("JCcat")) {
            argTree.add(String.valueOf(this.fastTreePath) + " -nt " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
        } else if (this.model.equalsIgnoreCase("GTRcat")) {
            argTree.add(String.valueOf(this.fastTreePath) + " -nt -gtr < " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
        } else if (this.model.equalsIgnoreCase("JCgamma")) {
            argTree.add(String.valueOf(this.fastTreePath) + " -nt -gamma < " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
        } else if (this.model.equalsIgnoreCase("GTRgamma")) {
            argTree.add(String.valueOf(this.fastTreePath) + " -nt -gtr -gamma < " + this.concatenatedSeqFileName + " > " + this.treeZzFileName);
        }
        this.runPhylogenyToolByProcess(argTree, PhylogenyTool.fasttree);
    }

    private void runPhylogenyToolByProcess(List<String> argTree, PhylogenyTool phylogenyTool) {
        try {
            System.out.println(argTree);
            Process tree = new ProcessBuilder(argTree).start();
            StreamGobbler outGobbler = new StreamGobbler(tree.getInputStream(), null, false);
            StreamGobbler errorGobbler = new StreamGobbler(tree.getErrorStream(), null, false);
            outGobbler.start();
            errorGobbler.start();
            try {
                tree.waitFor();
            }
            catch (InterruptedException e) {
                System.err.println("Error occurred!");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            if (tree.exitValue() != 0) {
                String log = errorGobbler.LogMessage();
                System.err.println(log);
                if (phylogenyTool.equals((Object)PhylogenyTool.raxml)) {
                    System.err.println("Error occurred during running RAxML.");
                } else {
                    System.err.println("Error occurred during running FastTree.");
                }
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void checkPathDirectory() {
        File path = new File(this.outDirectory);
        if (!path.exists() && !path.mkdir()) {
            System.err.println("Error occurred!");
            System.err.println(String.valueOf(this.outDirectory) + " doesn't exist and can't be created.");
            System.exit(1);
        }
        if (new File(String.valueOf(this.outDirectory) + this.runOutDirName).exists()) {
            System.err.println("Error occurred!");
            System.err.println("Run id '" + this.runOutDirName.replace(File.separator, "") + "' already exists!");
            System.exit(1);
        }
        if (!new File(this.outDirectory).canWrite()) {
            System.err.println("Error occurred!");
            System.err.println("Cannot write files to " + this.outDirectory + ". Check the permission.");
            System.exit(1);
        } else {
            new File(String.valueOf(this.outDirectory) + this.runOutDirName).mkdir();
        }
    }

    void checkThirdPartyPrograms(PhylogenyTool phylogenyTool) {
        if (phylogenyTool.equals((Object)PhylogenyTool.fasttree)) {
            this.testMafft(this.mafftPath);
            this.testFasttree(this.fastTreePath);
        } else if (phylogenyTool.equals((Object)PhylogenyTool.raxml)) {
            this.testMafft(this.mafftPath);
            this.testRaxml(this.raxmlPath);
        }
    }

    private void align(int nThreads) {
        try {
            ExecutorService exeService = Executors.newFixedThreadPool(nThreads);
            int[] counter = new int[1];
            ArrayList<Future<ProcessGobbler>> futures = new ArrayList<Future<ProcessGobbler>>();
            for (String string : this.usedGenes) {
                String fastaFile = this.fastaFileName(string);
                String alignedFastaFile = this.alignedFastaFileName(string);
                Future<ProcessGobbler> future = exeService.submit(new multipleAlign(this.mafftPath, this.alignMode, fastaFile, alignedFastaFile, counter, string, this.usedGenes.size(), this.filtering));
                futures.add(future);
            }
            exeService.shutdown();
            for (Future future : futures) {
                ProcessGobbler processGobbler = (ProcessGobbler)future.get();
                if (processGobbler.getExitValue() == 0) continue;
                System.err.println("Error occurred when running mafft!");
                System.err.println("log|" + processGobbler.getLog());
                System.exit(1);
            }
            while (!exeService.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (ExecutionException ex) {
            System.err.println("Error occurred!");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private void proAlignToCodon() {
        System.out.println("Converting protein alignments to DNA(codon) alignments..");
        for (String gene : this.usedGenes) {
            String nucFile = this.fastaFileName(gene, AlignMode.nucleotide);
            String alignedProFile = this.alignedFastaFileName(gene);
            FastaSeqList nucFasta = new FastaSeqList();
            nucFasta.importFile(nucFile);
            FastaSeqList alignedProFasta = new FastaSeqList();
            alignedProFasta.importFile(alignedProFile);
            int i = 0;
            while (i < alignedProFasta.list.size()) {
                FastaSeq alignedFastaSeq = alignedProFasta.list.get(i);
                FastaSeq dnaFastaSeq = nucFasta.find(alignedFastaSeq.title);
                char[] alignedSeq = alignedFastaSeq.sequence.toCharArray();
                String dnaSeq = dnaFastaSeq.sequence;
                String stopCodon = dnaSeq.substring(dnaSeq.length() - 3);
                if (stopCodon.contains("X")) {
                    dnaSeq = String.valueOf(dnaSeq.substring(0, dnaSeq.length() - 3)) + "TAA";
                } else if (!(stopCodon.equals("TAA") || stopCodon.equals("TAG") || stopCodon.equals("TGA"))) {
                    dnaSeq = String.valueOf(dnaSeq) + "TAA";
                }
                StringBuffer alignedCodonSB = new StringBuffer(dnaSeq);
                int k = 0;
                while (k < alignedSeq.length) {
                    char ch = alignedSeq[k];
                    if (ch == '-') {
                        int index = 3 * k;
                        alignedCodonSB.insert(index, "---");
                    }
                    ++k;
                }
                if (this.alignMode.equals((Object)AlignMode.codon)) {
                    nucFasta.find((String)alignedFastaSeq.title).sequence = alignedCodonSB.toString();
                    nucFasta.write(this.alignedCodonFile(gene));
                } else if (this.alignMode.equals((Object)AlignMode.codon12)) {
                    char[] seqArray = alignedCodonSB.toString().toCharArray();
                    StringBuffer codon12SB = new StringBuffer();
                    int k2 = 0;
                    while (k2 < seqArray.length) {
                        if (k2 % 3 != 2) {
                            codon12SB.append(seqArray[k2]);
                        }
                        ++k2;
                    }
                    nucFasta.find((String)alignedFastaSeq.title).sequence = codon12SB.toString();
                    nucFasta.write(this.alignedCodon12File(gene));
                }
                ++i;
            }
        }
    }

    private String removeGapColumns(String concatFasta) {
        FastaSeqList conFastaSeqList = new FastaSeqList();
        conFastaSeqList.importString(concatFasta);
        int numOfGenome = conFastaSeqList.list.size();
        int seqLength = conFastaSeqList.list.get((int)0).sequence.length();
        int[] numGaps = new int[seqLength];
        Arrays.fill(numGaps, 0);
        for (FastaSeq fastaSeq : conFastaSeqList.list) {
            String seq = fastaSeq.sequence;
            int pos = 0;
            while (pos < seq.length()) {
                if (fastaSeq.sequence.charAt(pos) == '-') {
                    int n = pos;
                    numGaps[n] = numGaps[n] + 1;
                }
                ++pos;
            }
        }
        double percentageFilter = 1.0 - (double)this.filtering / 100.0;
        for (FastaSeq fastaSeq : conFastaSeqList.list) {
            String seq = fastaSeq.sequence;
            char[] seqArray = seq.toCharArray();
            StringBuffer seqSB = new StringBuffer();
            int pos = 0;
            while (pos < seq.length()) {
                if (!((double)numGaps[pos] > (double)numOfGenome * percentageFilter)) {
                    seqSB.append(seqArray[pos]);
                }
                ++pos;
            }
            fastaSeq.sequence = seqSB.toString();
        }
        return conFastaSeqList.getString();
    }

    private void retrieveFastaNucProFiles(List<GeneSetByGenomeDomain> geneSetsDomainList) throws IOException {
        for (String gene : this.targetGenes) {
            StringBuffer sbNuc = new StringBuffer();
            StringBuffer sbPro = new StringBuffer();
            int nuc = 0;
            int pro = 0;
            for (GeneSetByGenomeDomain geneSetsDomain : geneSetsDomainList) {
                long uid = geneSetsDomain.getUid();
                HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = geneSetsDomain.getDataMap();
                if (!dataMap.containsKey(gene) || dataMap.get(gene).size() == 0) continue;
                DetectedGeneDomain geneDomain = dataMap.get(gene).get(0);
                String nucSeq = geneDomain.getDna();
                String proSeq = geneDomain.getProtein();
                if (nucSeq == null) {
                    String label = geneSetsDomain.getLabel();
                    System.err.println("Error : " + label + " has no DNA sequence! DNA sequence is needed to be aligned with their sequences.");
                    System.err.println("Exit!");
                    System.exit(1);
                }
                if (nucSeq != null) {
                    sbNuc.append(">zZ" + uid + "zZ\n");
                    sbNuc.append(nucSeq);
                    sbNuc.append("\n");
                    ++nuc;
                }
                if (proSeq == null) continue;
                sbPro.append(">zZ" + uid + "zZ\n");
                sbPro.append(proSeq);
                sbPro.append("\n");
                ++pro;
            }
            if (nuc < 4 && pro < 4) {
                System.err.println("Less than 4 species have '" + gene + "', this sequence is excluded in further analysis.");
            }
            if (sbNuc.length() != 0 && nuc > 3) {
                FileWriter fileNucWriter = new FileWriter(this.fastaFileName(gene, AlignMode.nucleotide));
                fileNucWriter.append(sbNuc.toString());
                fileNucWriter.close();
                this.usedGenes.add(gene);
            }
            if (sbPro.length() == 0 || pro <= 3) continue;
            FileWriter fileProWriter = new FileWriter(this.fastaFileName(gene, AlignMode.protein));
            fileProWriter.append(sbPro.toString());
            fileProWriter.close();
            this.usedGenes.add(gene);
        }
    }

    private void retrieveFastaFiles(List<GeneSetByGenomeDomain> geneSetsDomainList) throws IOException {
        for (String gene : this.targetGenes) {
            StringBuffer sb = new StringBuffer();
            int num = 0;
            for (GeneSetByGenomeDomain geneSetsDomain : geneSetsDomainList) {
                long uid = geneSetsDomain.getUid();
                HashMap<String, ArrayList<DetectedGeneDomain>> dataMap = geneSetsDomain.getDataMap();
                if (!dataMap.containsKey(gene) || dataMap.get(gene).size() == 0) continue;
                DetectedGeneDomain geneDomain = dataMap.get(gene).get(0);
                String seq = null;
                if (this.alignMode.equals((Object)AlignMode.nucleotide)) {
                    seq = geneDomain.getDna();
                } else if (this.alignMode.equals((Object)AlignMode.protein)) {
                    seq = geneDomain.getProtein();
                }
                if (seq == null) continue;
                sb.append(">zZ" + uid + "zZ\n");
                sb.append(seq);
                sb.append("\n");
                ++num;
            }
            if (num < 4) {
                System.err.println("Less than 4 species have '" + gene + "', this sequence is excluded in further analysis.");
            }
            if (sb.length() == 0 || num <= 3) continue;
            FileWriter fileNucWriter = new FileWriter(this.fastaFileName(gene));
            fileNucWriter.append(sb.toString());
            fileNucWriter.close();
            this.usedGenes.add(gene);
        }
    }

    private List<GeneSetByGenomeDomain> jsonsToGeneSetDomains(File[] files) {
        ArrayList<GeneSetByGenomeDomain> geneSetsDomainList = new ArrayList<GeneSetByGenomeDomain>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String filePath = file.getAbsolutePath();
            String geneSetJson = FileUtils.readTextFile2StringWithCR(filePath);
            GeneSetByGenomeDomain geneSetDomain = GeneSetByGenomeDomain.jsonToDomain(geneSetJson);
            geneSetsDomainList.add(geneSetDomain);
            ++n2;
        }
        return geneSetsDomainList;
    }

    private boolean checkIfSameTargetGeneSets(File[] files) throws JSONException {
        System.out.println(String.valueOf(files.length) + " ucg files are detected.");
        System.out.println();
        if (files.length < 3) {
            System.err.println("There are less than 3 ucg files! Exit.");
            System.exit(1);
        }
        boolean same = false;
        File refFile = files[0];
        ArrayList<String> refTargetGenes = this.fileToTargetGeneList(refFile);
        this.targetGenes = refTargetGenes;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File geneSetFile = fileArray[n2];
            ArrayList<String> targetGenes = this.fileToTargetGeneList(geneSetFile);
            if (!this.sameTargetGenes(refTargetGenes, targetGenes)) {
                System.err.println("Gene sets were extracted from different target genes.");
                System.err.println("Exit!");
                System.exit(1);
            }
            ++n2;
        }
        same = true;
        return same;
    }

    private ArrayList<String> fileToTargetGeneList(File geneSetJsonFile) throws JSONException {
        String geneSetFile = geneSetJsonFile.getAbsolutePath();
        String geneSetJson = FileUtils.readTextFile2StringWithCR(geneSetFile);
        GeneSetByGenomeDomain geneSetByGenomeDomain = GeneSetByGenomeDomain.jsonToDomain(geneSetJson);
        String geneSet = geneSetByGenomeDomain.getTargetGeneSet();
        String[] targetGenes = geneSet.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(targetGenes));
        return list;
    }

    private boolean sameTargetGenes(ArrayList<String> ref, ArrayList<String> target) {
        if (ref.size() != target.size()) {
            return false;
        }
        for (String gene : ref) {
            if (target.contains(gene)) continue;
            return false;
        }
        return true;
    }

    private String fastaFileName(String gene) {
        String fasta = null;
        if (this.alignMode.equals((Object)AlignMode.nucleotide)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_nuc.zZ.fasta";
        } else if (this.alignMode.equals((Object)AlignMode.protein) || this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_pro.zZ.fasta";
        }
        return fasta;
    }

    private String fastaLabelFileName(String gene) {
        String fasta = null;
        if (this.alignMode.equals((Object)AlignMode.nucleotide)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_nuc.fasta";
        } else if (this.alignMode.equals((Object)AlignMode.protein) || this.alignMode.equals((Object)AlignMode.codon) || this.alignMode.equals((Object)AlignMode.codon12)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_pro.fasta";
        }
        return fasta;
    }

    private String fastaFileName(String gene, AlignMode alignMode) {
        String fasta = null;
        if (alignMode.equals((Object)AlignMode.nucleotide)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_nuc.zZ.fasta";
        } else if (alignMode.equals((Object)AlignMode.protein) || alignMode.equals((Object)AlignMode.codon) || alignMode.equals((Object)AlignMode.codon12)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + gene + "_pro.zZ.fasta";
        }
        return fasta;
    }

    private String alignedFastaFileName(String gene) {
        String fasta = null;
        if (this.alignMode.equals((Object)AlignMode.nucleotide)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_nuc.zZ.fasta";
        } else if (this.alignMode.equals((Object)AlignMode.protein) || this.alignMode.equals((Object)AlignMode.codon12) || this.alignMode.equals((Object)AlignMode.codon)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_pro.zZ.fasta";
        }
        return fasta;
    }

    private String alignedCodonFile(String gene) {
        String fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_codon.zZ.fasta";
        return fasta;
    }

    private String alignedCodon12File(String gene) {
        String fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_codon12.zZ.fasta";
        return fasta;
    }

    private String alignedFinalGeneFastaFile(String gene) {
        String fasta = null;
        if (this.alignMode.equals((Object)AlignMode.nucleotide)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_nuc.zZ.fasta";
        } else if (this.alignMode.equals((Object)AlignMode.protein)) {
            fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + "_pro.zZ.fasta";
        } else if (this.alignMode.equals((Object)AlignMode.codon)) {
            fasta = this.alignedCodonFile(gene);
        } else if (this.alignMode.equals((Object)AlignMode.codon12)) {
            fasta = this.alignedCodon12File(gene);
        }
        return fasta;
    }

    private String alignedFinalGeneFastaLabelFile(String gene) {
        String fasta = String.valueOf(this.outDirectory) + this.runOutDirName + "aligned_" + gene + ".fasta";
        return fasta;
    }

    private void testMafft(String mafftPath) {
        boolean mafft = false;
        ArrayList<String> argMafft = new ArrayList<String>();
        argMafft.add(mafftPath);
        argMafft.add("-h");
        try {
            String s;
            Process testMafft = new ProcessBuilder(argMafft).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(testMafft.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(testMafft.getErrorStream()));
            while ((s = stdOut.readLine()) != null) {
            }
            while ((s = stdError.readLine()) != null) {
                if (!s.contains("  MAFFT ")) continue;
                mafft = true;
            }
            stdOut.close();
            stdError.close();
            try {
                testMafft.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (!mafft) {
            System.err.println("Error : Check if MAFFT v7.310 is properly installed and check the program path in the 'programPath' file");
            System.exit(1);
        }
    }

    private void testFasttree(String fasttreePath) {
        boolean fasttree = false;
        ArrayList<String> argFasttree = new ArrayList<String>();
        argFasttree.add(fasttreePath);
        argFasttree.add("-help");
        try {
            String s;
            Process testFasttree = new ProcessBuilder(argFasttree).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(testFasttree.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(testFasttree.getErrorStream()));
            BufferedOutputStream stdin = new BufferedOutputStream(testFasttree.getOutputStream());
            while ((s = stdOut.readLine()) != null) {
            }
            while ((s = stdError.readLine()) != null) {
                if (!s.contains("FastTree ")) continue;
                fasttree = true;
            }
            stdOut.close();
            stdError.close();
            try {
                testFasttree.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (!fasttree) {
            System.err.println("Error : Check if FastTree version 2.1.10 SSE3 is properly installed and check the program path in the 'programPath' file");
            System.exit(1);
        }
    }

    private void testRaxml(String raxmlPath) {
        boolean raxml = false;
        ArrayList<String> argRaxml = new ArrayList<String>();
        argRaxml.add(raxmlPath);
        argRaxml.add("-h");
        try {
            String s;
            Process testRaxml = new ProcessBuilder(argRaxml).start();
            BufferedReader stdOut = new BufferedReader(new InputStreamReader(testRaxml.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(testRaxml.getErrorStream()));
            BufferedOutputStream stdin = new BufferedOutputStream(testRaxml.getOutputStream());
            while ((s = stdOut.readLine()) != null) {
                if (!s.contains("This is RAxML version 8")) continue;
                raxml = true;
            }
            while ((s = stdError.readLine()) != null) {
            }
            stdOut.close();
            stdError.close();
            try {
                testRaxml.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (!raxml) {
            System.err.println("Error : Check if RAxML version 8 is properly installed and check the program path in the 'programPath' file");
            System.exit(1);
        }
    }

    private void writeGenomeInfoToLogFile(List<GeneSetByGenomeDomain> geneSetByGenomeDomains) {
        StringBuffer logSB = new StringBuffer();
        logSB.append("Run ID: " + this.runOutDirName.replace(File.separator, "") + "\n");
        logSB.append("Genomes produced: " + geneSetByGenomeDomains.size() + "\n");
        logSB.append("Alignment mode: " + (Object)((Object)this.alignMode) + "\n");
        logSB.append("Filtered by: " + this.filtering + "%\n\n");
        logSB.append("Genomes included in the analysis\n");
        logSB.append("uid\tlabel\tacc\ttaxon_name\tstrain_name\ttype\ttaxonomy\tUBCG\n");
        for (GeneSetByGenomeDomain dom : geneSetByGenomeDomains) {
            long uid = dom.getUid();
            String label = dom.getLabel();
            String acc = dom.getAccession();
            String taxon_name = dom.getTaxonName();
            String strain_name = dom.getStrainName();
            Boolean type = dom.getIsTpyeStrain();
            String taxonomy = dom.getTaxonomy();
            int numDetectedGenes = dom.getTotalDetectedGenes();
            logSB.append(String.valueOf(uid) + "\t" + label + "\t" + acc + "\t" + taxon_name + "\t" + strain_name + "\t" + type + "\t" + taxonomy + "\t" + numDetectedGenes + "\n");
        }
        try {
            FileWriter fw = new FileWriter(this.logFileName, true);
            fw.append(logSB);
            fw.close();
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

