/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import lbj.Branch;
import lbj.BranchRelationship;
import lbj.BranchTag;
import lbj.Node;
import lbj.Species;
import lbj.Tree;
import lbj.TreeMetadata;

public class BranchAnalysis {
    private static String version = "0.0.1";
    private List<Species> speciesList = new ArrayList<Species>();
    private HashMap<String, Species> speciesMap = new HashMap();
    private HashMap<BranchTag, Branch> branchMap = new HashMap();
    private List<Branch> branchList = new ArrayList<Branch>();
    private double maximumScore;
    private Tree[] trees;
    public List<TreeMetadata> treeMetadataList = new ArrayList<TreeMetadata>();
    public List<HashMap<BranchTag, boolean[]>> localBranchMaps = new ArrayList<HashMap<BranchTag, boolean[]>>();

    public BranchAnalysis(File inputFile) {
        String newickString = "";
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
                char[] buf = new char[(int)inputFile.length()];
                reader.read(buf, 0, (int)inputFile.length());
                newickString = new String(buf);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.runAnalysis(newickString);
    }

    public BranchAnalysis(String[] newickStrings) {
        String newickString = "";
        int i = 0;
        while (i < newickStrings.length) {
            newickString = String.valueOf(newickString) + newickStrings[i];
            ++i;
        }
        this.runAnalysis(newickString);
    }

    public BranchAnalysis(String newickString) {
        this.runAnalysis(newickString);
    }

    private BranchAnalysis(Tree[] trees) {
        this.runAnalysis(trees);
    }

    private void runAnalysis(String newickString) {
        Tree[] trees = Tree.importNewick(newickString);
        this.runAnalysis(trees);
    }

    private void runAnalysis(Tree[] trees) {
        this.trees = trees;
        this.maximumScore = 0.0;
        long t0 = System.currentTimeMillis();
        this.getSpecies(trees);
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        this.getBranches(trees);
        long t3 = System.currentTimeMillis();
    }

    private void getSpecies(Tree[] trees) {
        int i = 0;
        while (i < trees.length) {
            Tree tree = trees[i];
            List leaves = tree.getLeaves();
            int j = 0;
            while (j < leaves.size()) {
                Species species;
                Node leaf = leaves.get(j);
                String name = leaf.getName();
                if (!this.speciesMap.containsKey(name)) {
                    species = new Species(name);
                    species.setCount(1);
                    this.speciesMap.put(name, species);
                    this.speciesList.add(species);
                } else {
                    species = this.speciesMap.get(name);
                    species.setCount(species.getCount() + 1);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(this.speciesList, new Comparator<Species>(){

            @Override
            public int compare(Species speciesA, Species speciesB) {
                int diff = speciesA.getCount() - speciesB.getCount();
                if (diff == 0) {
                    return speciesA.getName().compareTo(speciesB.getName());
                }
                return diff;
            }
        });
        int coreSpecies = 0;
        long totalMissing = 0L;
        int i2 = 0;
        while (i2 < this.speciesList.size()) {
            Species species = this.speciesList.get(i2);
            species.setIndex(i2);
            if (species.getCount() < 54) {
                totalMissing += (long)(54 - species.getCount());
            } else {
                ++coreSpecies;
            }
            ++i2;
        }
    }

    private void getBranches(Tree[] trees) {
        long t0 = System.currentTimeMillis();
        long branchTagCreationDuration = 0L;
        long btcd = 0L;
        long branchTagAdditionDuration = 0L;
        long btad = 0L;
        long branchTagLookupDuration = 0L;
        long btld = 0L;
        int i = 0;
        while (i < trees.length) {
            Tree tree = trees[i];
            TreeMetadata treeMetaData = new TreeMetadata();
            HashMap<BranchTag, boolean[]> localBranchMap = new HashMap<BranchTag, boolean[]>();
            List leaves = tree.getLeaves();
            int numOfLeaves = leaves.size();
            int totalBranches = tree.getNodes().size();
            Boolean[] existingSpecies = new Boolean[this.speciesList.size()];
            int j = 0;
            while (j < existingSpecies.length) {
                existingSpecies[j] = false;
                ++j;
            }
            j = 0;
            while (j < leaves.size()) {
                existingSpecies[this.speciesMap.get((Object)leaves.get((int)j).getName()).getIndex()] = true;
                ++j;
            }
            treeMetaData.speciesCheck = existingSpecies;
            ArrayList<Integer> missingSpecies = new ArrayList<Integer>();
            int j2 = 0;
            while (j2 < existingSpecies.length) {
                if (!existingSpecies[j2].booleanValue()) {
                    missingSpecies.add(j2);
                }
                ++j2;
            }
            int numMissingSpecies = this.speciesList.size() - leaves.size();
            double points = 1.0;
            treeMetaData.missingSpecies = missingSpecies;
            this.maximumScore += points;
            ArrayList queue = new ArrayList();
            queue.add(tree.getRoot());
            int current = 0;
            while (current < queue.size()) {
                Branch branch;
                Node currentNode = (Node)queue.get(current);
                btcd = System.currentTimeMillis();
                List currentLeaves = new Tree(currentNode).getLeaves();
                ArrayList<Integer> speciesOnRight = new ArrayList<Integer>(currentLeaves.size());
                int j3 = 0;
                while (j3 < currentLeaves.size()) {
                    Species species = this.speciesMap.get(currentLeaves.get(j3).getName());
                    speciesOnRight.add(species.getIndex());
                    ++j3;
                }
                BranchTag branchTag = new BranchTag(this.speciesList.size(), speciesOnRight, missingSpecies);
                branchTagCreationDuration += System.currentTimeMillis() - btcd;
                int index = 0;
                while (index < branchTag.getId().size() && branchTag.getId().get(index) == 2) {
                    ++index;
                }
                boolean[] leftAndRight = (boolean[])localBranchMap.get(branchTag);
                if (leftAndRight == null) {
                    leftAndRight = new boolean[2];
                    if (index < branchTag.getId().size()) {
                        if (branchTag.getId().get(index) == 0) {
                            leftAndRight[0] = true;
                        } else {
                            leftAndRight[1] = true;
                        }
                    } else {
                        leftAndRight[0] = true;
                        leftAndRight[1] = true;
                    }
                    localBranchMap.put(branchTag, leftAndRight);
                    btld = System.currentTimeMillis();
                    branch = this.branchMap.get(branchTag);
                    branchTagLookupDuration += System.currentTimeMillis() - btld;
                    if (branch == null) {
                        branch = new Branch(branchTag);
                        btad = System.currentTimeMillis();
                        this.branchMap.put(branchTag, branch);
                        branchTagAdditionDuration += System.currentTimeMillis() - btad;
                        branch.setScore(points);
                        this.branchList.add(branch);
                    } else {
                        branch.addPoints(points);
                    }
                    if (leftAndRight[0]) {
                        branch.addLeftPoints(points);
                    }
                    if (leftAndRight[1]) {
                        branch.addRightPoints(points);
                    }
                } else {
                    btld = System.currentTimeMillis();
                    branch = this.branchMap.get(branchTag);
                    branchTagLookupDuration += System.currentTimeMillis() - btld;
                    if (index < branchTag.getId().size()) {
                        if (branchTag.getId().get(index) == 0) {
                            if (!leftAndRight[0]) {
                                leftAndRight[0] = true;
                                branch.addLeftPoints(points);
                            }
                        } else if (!leftAndRight[1]) {
                            leftAndRight[1] = true;
                            branch.addRightPoints(points);
                        }
                    } else {
                        if (!leftAndRight[0]) {
                            leftAndRight[0] = true;
                            branch.addLeftPoints(points);
                        }
                        if (!leftAndRight[1]) {
                            leftAndRight[1] = true;
                            branch.addRightPoints(points);
                        }
                    }
                }
                int j4 = 0;
                while (j4 < currentNode.getChildren().size()) {
                    queue.add(currentNode.getChildren().get(j4));
                    ++j4;
                }
                ++current;
            }
            this.localBranchMaps.add(localBranchMap);
            this.treeMetadataList.add(treeMetaData);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        long t2 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < this.branchList.size()) {
            Branch branch = this.branchList.get(i2);
            branch.setIndex(i2);
            ++i2;
        }
        long t3 = System.currentTimeMillis();
    }

    private static void propagate(String[] charset, int k, int position, String string, List<String> strings) {
        if (position == k) {
            strings.add(string);
        } else {
            int i = 0;
            while (i < charset.length) {
                BranchAnalysis.propagate(charset, k, position + 1, String.valueOf(string) + charset[i], strings);
                ++i;
            }
        }
    }

    public static String[] getAllPossibleKmers(String[] charset, int k) {
        ArrayList<String> strings = new ArrayList<String>((int)Math.pow(charset.length, k));
        BranchAnalysis.propagate(charset, k, 0, "", strings);
        return strings.toArray(new String[strings.size()]);
    }

    public void printAllSpecies() {
        String analysis = "";
        int indexDigits = 0;
        int number = Math.max(this.speciesList.size(), this.branchList.size());
        while (number > 0) {
            number /= 10;
            ++indexDigits;
        }
        int indexWidth = Math.max(3, indexDigits);
        int speciesNameMaxLength = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.speciesList.size()) {
            int length = this.speciesList.get(i).getName().length();
            if (speciesNameMaxLength < length) {
                speciesNameMaxLength = length;
            }
            ++i;
        }
        int nameWidth = Math.max(4, Math.max(this.speciesList.size(), speciesNameMaxLength));
        String separatorString = "+-";
        int i2 = 0;
        while (i2 < indexWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i2;
        }
        separatorString = String.valueOf(separatorString) + "-+-";
        i2 = 0;
        while (i2 < nameWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i2;
        }
        separatorString = String.valueOf(separatorString) + "-+";
        String speciesFormat = String.format("| %%%ds | %%%ds |", indexWidth, nameWidth);
        analysis = String.valueOf(analysis) + "All Items\t..." + this.speciesList.size() + "\n";
        analysis = String.valueOf(analysis) + separatorString + "\n";
        analysis = String.valueOf(analysis) + String.format(speciesFormat, "Idx", "Name") + "\n";
        analysis = String.valueOf(analysis) + separatorString + "\n";
        int i3 = 0;
        while (i3 < this.speciesList.size()) {
            Species species = this.speciesList.get(i3);
            analysis = String.valueOf(analysis) + String.format(speciesFormat, Integer.toString(species.getIndex() + 1), species.getName()) + "\n";
            ++i3;
        }
        analysis = String.valueOf(analysis) + separatorString + "\n";
        System.out.println(analysis);
    }

    private static String speciesListToTextTables(List<Species> speciesList) {
        String text = "";
        int indexDigits = 0;
        int number = Math.max(speciesList.size(), 0);
        while (number > 0) {
            number /= 10;
            ++indexDigits;
        }
        int indexWidth = Math.max(3, indexDigits);
        int speciesNameMaxLength = Integer.MIN_VALUE;
        int i = 0;
        while (i < speciesList.size()) {
            int length = speciesList.get(i).getName().length();
            if (speciesNameMaxLength < length) {
                speciesNameMaxLength = length;
            }
            ++i;
        }
        int nameWidth = Math.max(4, speciesNameMaxLength);
        String separatorString = "+-";
        int i2 = 0;
        while (i2 < indexWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i2;
        }
        separatorString = String.valueOf(separatorString) + "-+-";
        i2 = 0;
        while (i2 < nameWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i2;
        }
        separatorString = String.valueOf(separatorString) + "-+";
        String speciesFormat = String.format("| %%%ds | %%%ds |", indexWidth, nameWidth);
        text = String.valueOf(text) + separatorString + "\n";
        text = String.valueOf(text) + String.format(speciesFormat, "Idx", "Name") + "\n";
        text = String.valueOf(text) + separatorString + "\n";
        int i3 = 0;
        while (i3 < speciesList.size()) {
            Species species = speciesList.get(i3);
            text = String.valueOf(text) + String.format(speciesFormat, Integer.toString(species.getIndex() + 1), species.getName()) + "\n";
            ++i3;
        }
        text = String.valueOf(text) + separatorString;
        return text;
    }

    private static String branchListToTextTable(List<Species> speciesList, List<Branch> branchList, double maximumScore) {
        String text = "";
        int indexDigits = 0;
        int number = Math.max(branchList.size(), 0);
        while (number > 0) {
            number /= 10;
            ++indexDigits;
        }
        int indexWidth = Math.max(3, indexDigits);
        int nameWidth = Math.max(2, speciesList.size());
        String separatorString = "+-";
        int i = 0;
        while (i < indexWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i;
        }
        separatorString = String.valueOf(separatorString) + "-+-";
        i = 0;
        while (i < nameWidth) {
            separatorString = String.valueOf(separatorString) + '-';
            ++i;
        }
        separatorString = String.valueOf(separatorString) + "-+";
        int scoreDigits = 0;
        int scoreLimit = (int)Math.ceil(maximumScore);
        while (scoreLimit > 0) {
            scoreLimit /= 10;
            ++scoreDigits;
        }
        int scoreWidth = Math.max(5, scoreDigits + 3);
        String scoreSeparatorString = "-";
        int i2 = 0;
        while (i2 < scoreWidth) {
            scoreSeparatorString = String.valueOf(scoreSeparatorString) + '-';
            ++i2;
        }
        scoreSeparatorString = String.valueOf(scoreSeparatorString) + "-+";
        separatorString = String.valueOf(separatorString) + scoreSeparatorString;
        String maximumScoreString = String.format(String.format("%%%ds", indexWidth + nameWidth + scoreWidth + 8), String.format("/%.2f", maximumScore));
        String branchFormat = String.format("| %%%ds | %%%ds | %%%ds |", indexWidth, nameWidth, scoreWidth);
        text = String.valueOf(text) + separatorString + "\n";
        text = String.valueOf(text) + String.format(branchFormat, "Idx", "ID", "Score", "Type A", "Type B") + "\n";
        text = String.valueOf(text) + separatorString + "\n";
        int i3 = 0;
        while (i3 < branchList.size()) {
            Branch branch = branchList.get(i3);
            text = String.valueOf(text) + String.format(branchFormat, Integer.toString(branch.getIndex() + 1), branch.getBranchTag().toConsenseString(), String.format("%.2f", branch.getScore())) + "\n";
            ++i3;
        }
        text = String.valueOf(text) + separatorString + "\n";
        text = String.valueOf(text) + maximumScoreString;
        return text;
    }

    public String getAnalysis() {
        String text = "Lumberjack Branch Analysis File Format\n";
        text = String.valueOf(text) + "version " + version + "\n\n";
        text = String.valueOf(text) + "All Items (" + this.speciesList.size() + ")\n";
        text = String.valueOf(text) + BranchAnalysis.speciesListToTextTables(this.speciesList);
        text = String.valueOf(text) + "\n\n";
        text = String.valueOf(text) + "All Unrooted Branches (" + this.branchList.size() + ")\n";
        text = String.valueOf(text) + BranchAnalysis.branchListToTextTable(this.speciesList, this.branchList, this.maximumScore);
        text = String.valueOf(text) + "\n\n";
        List<Branch> branchList = this.getRootedBranches();
        text = String.valueOf(text) + "All Rooted Branches (" + branchList.size() + ")\n";
        text = String.valueOf(text) + BranchAnalysis.branchListToTextTable(this.speciesList, branchList, this.maximumScore);
        return text;
    }

    public String getBranchInformation(BranchTag branchTag, List<Integer> speciesOnRight, List<Integer> missingSpecies) {
        int speciesIndex;
        int j;
        String str;
        HashMap<BranchTag, boolean[]> localBranchMap;
        String text = "Branch Information\n";
        text = String.valueOf(text) + "Branch Tag: " + branchTag.toConsenseString() + "\n";
        ArrayList<Integer> supportingTrees = new ArrayList<Integer>();
        ArrayList<Integer> opposingTrees = new ArrayList<Integer>();
        int i = 0;
        while (i < this.localBranchMaps.size()) {
            HashMap<BranchTag, boolean[]> localBranchMap2 = this.localBranchMaps.get(i);
            boolean exists = false;
            for (BranchTag tag : localBranchMap2.keySet()) {
                if (!tag.equalsIgnoreMissing(branchTag)) continue;
                exists = true;
                supportingTrees.add(i);
                break;
            }
            if (!exists) {
                opposingTrees.add(i);
            }
            ++i;
        }
        text = String.valueOf(text) + "Trees that support this branch (" + supportingTrees.size() + ")\n";
        i = 0;
        while (i < supportingTrees.size()) {
            int index = (Integer)supportingTrees.get(i);
            TreeMetadata treeMetadata = this.treeMetadataList.get(index);
            localBranchMap = this.localBranchMaps.get(index);
            str = "";
            j = 0;
            while (j < speciesOnRight.size()) {
                speciesIndex = speciesOnRight.get(j);
                str = treeMetadata.speciesCheck[speciesIndex] != false ? String.valueOf(str) + 'O' : String.valueOf(str) + 'X';
                ++j;
            }
            text = String.valueOf(text) + String.format("%d (%d): %s\n", i + 1, index + 1, str);
            ++i;
        }
        text = String.valueOf(text) + "Trees that oppose this branch (" + opposingTrees.size() + ")\n";
        i = 0;
        while (i < opposingTrees.size()) {
            int index = (Integer)opposingTrees.get(i);
            TreeMetadata treeMetadata = this.treeMetadataList.get(index);
            localBranchMap = this.localBranchMaps.get(index);
            str = "";
            j = 0;
            while (j < speciesOnRight.size()) {
                speciesIndex = speciesOnRight.get(j);
                str = treeMetadata.speciesCheck[speciesIndex] != false ? String.valueOf(str) + 'O' : String.valueOf(str) + 'X';
                ++j;
            }
            text = String.valueOf(text) + String.format("%d (%d): %s\n", i + 1, index + 1, str);
            ++i;
        }
        return text;
    }

    public String getBranchInformation(BranchTag branchTag) {
        String branchTagString = branchTag.toConsenseString();
        ArrayList<Integer> speciesOnRight = new ArrayList<Integer>();
        ArrayList<Integer> missingSpecies = new ArrayList<Integer>();
        int i = 0;
        while (i < branchTagString.length()) {
            char c = branchTagString.charAt(i);
            if (c == '*') {
                speciesOnRight.add(i);
            } else if (c == '?') {
                missingSpecies.add(i);
            }
            ++i;
        }
        return this.getBranchInformation(branchTag, speciesOnRight, missingSpecies);
    }

    public String getBranchInformation(String branchTagString) {
        ArrayList<Integer> speciesOnRight = new ArrayList<Integer>();
        ArrayList<Integer> missingSpecies = new ArrayList<Integer>();
        int i = 0;
        while (i < branchTagString.length()) {
            char c = branchTagString.charAt(i);
            if (c == '*') {
                speciesOnRight.add(i);
            } else if (c == '?') {
                missingSpecies.add(i);
            }
            ++i;
        }
        BranchTag branchTag = new BranchTag(this.speciesList.size(), speciesOnRight, missingSpecies);
        return this.getBranchInformation(branchTag, speciesOnRight, missingSpecies);
    }

    public String getBranchInformation(List<Integer> speciesOnRight, List<Integer> missingSpecies) {
        BranchTag branchTag = new BranchTag(this.speciesList.size(), speciesOnRight, missingSpecies);
        return this.getBranchInformation(branchTag, speciesOnRight, missingSpecies);
    }

    private static int[] growBranches(List<Species> speciesList, Node<Branch> node) {
        Branch branch = node.getData();
        int[] descendants = new int[speciesList.size()];
        int numOfDescendants = 0;
        int i = 0;
        while (i < speciesList.size()) {
            if (branch.getBranchTag().getId().get(i) == 1) {
                descendants[i] = 1;
                ++numOfDescendants;
            }
            ++i;
        }
        i = 0;
        while (i < node.getChildren().size()) {
            int[] descendants2 = BranchAnalysis.growBranches(speciesList, node.getChildren().get(i));
            int j = 0;
            while (j < speciesList.size()) {
                int n = j;
                descendants[n] = descendants[n] + descendants2[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < speciesList.size()) {
            if (descendants[i] == 1) {
                if (branch.getBranchTag().isLeaf()) {
                    node.setName(speciesList.get(i).getName());
                    break;
                }
                Node child = new Node(speciesList.get(i).getName());
                int index = 0;
                int j = 0;
                while (j < node.getChildren().size()) {
                    List<Integer> id = node.getChildren().get(j).getData().getBranchTag().getId();
                    int firstRightIndex = 0;
                    int k = 0;
                    while (k < id.size()) {
                        if (id.get(k) == 1) {
                            firstRightIndex = k;
                            break;
                        }
                        ++k;
                    }
                    if (i < firstRightIndex) break;
                    ++index;
                    ++j;
                }
                node.addChild(index, child, 0.0);
            }
            ++i;
        }
        return descendants;
    }

    private static Tree<Branch> buildConsensusTree(double maximumScore, List<Species> speciesList, List<Branch> branchList) {
        Collections.sort(branchList, new Comparator<Branch>(){

            @Override
            public int compare(Branch branchA, Branch branchB) {
                double difference = branchB.getScore() - branchA.getScore();
                if (difference == 0.0) {
                    return 0;
                }
                if (difference < 0.0) {
                    return -1;
                }
                return 1;
            }
        });
        int i = 0;
        while (i < branchList.size()) {
            Branch branch = branchList.get(i);
            branch.setIndex(i);
            ++i;
        }
        HashMap branchRelationships = new HashMap();
        int i2 = 0;
        while (i2 < branchList.size()) {
            branchRelationships.put(i2, new HashMap());
            ++i2;
        }
        i2 = 0;
        while (i2 < branchList.size()) {
            BranchTag branchTagA = branchList.get(i2).getBranchTag();
            int j = i2 + 1;
            while (j < branchList.size()) {
                BranchTag branchTagB = branchList.get(j).getBranchTag();
                ((HashMap)branchRelationships.get(i2)).put(j, branchTagA.getRelationshipWith(branchTagB));
                ((HashMap)branchRelationships.get(j)).put(i2, branchTagB.getRelationshipWith(branchTagA));
                ++j;
            }
            ++i2;
        }
        ArrayList<Branch> includedBranches = new ArrayList<Branch>();
        ArrayList<Branch> omittedBranches = new ArrayList<Branch>();
        includedBranches.add(branchList.get(0));
        int i3 = 1;
        while (i3 < branchList.size()) {
            Branch branch = branchList.get(i3);
            boolean valid = true;
            int j = 0;
            while (j < includedBranches.size()) {
                Branch includedBranch = (Branch)includedBranches.get(j);
                BranchRelationship relationship = (BranchRelationship)((Object)((HashMap)branchRelationships.get(includedBranch.getIndex())).get(branch.getIndex()));
                if (relationship == BranchRelationship.IMCOMPATIBLE) {
                    valid = false;
                    break;
                }
                ++j;
            }
            if (valid) {
                includedBranches.add(branch);
            } else {
                omittedBranches.add(branch);
            }
            ++i3;
        }
        System.out.println("Branches included in the consensus tree");
        System.out.println(BranchAnalysis.branchListToTextTable(speciesList, includedBranches, maximumScore));
        System.out.println("Branches omitted from the consensus tree");
        System.out.println(BranchAnalysis.branchListToTextTable(speciesList, omittedBranches, maximumScore));
        Node<Object> root = new Node<Object>(null, "root");
        int i4 = 0;
        while (i4 < includedBranches.size()) {
            Branch branch = (Branch)includedBranches.get(i4);
            Node<Branch> node = new Node<Branch>(branch);
            node.setName(String.format("%.2f", branch.getScore() / maximumScore));
            Node<Object> parent = root;
            while (parent.getChildren().size() > 0) {
                boolean traversed = false;
                int j = 0;
                while (j < parent.getChildren().size()) {
                    Node<Object> child = parent.getChildren().get(j);
                    Branch childBranch = child.getData();
                    BranchRelationship relationship = (BranchRelationship)((Object)((HashMap)branchRelationships.get(childBranch.getIndex())).get(branch.getIndex()));
                    if (relationship == BranchRelationship.SUPERSET) {
                        traversed = true;
                        parent = child;
                        break;
                    }
                    if (relationship == BranchRelationship.SUBSET) {
                        parent.removeChild(j);
                        node.addChild(child, 0.0);
                        --j;
                    }
                    ++j;
                }
                if (!traversed) break;
            }
            parent.addChild(node, 0.0);
            ++i4;
        }
        if (root.getChildren().size() > 1) {
            System.err.println("ERROR: There seems to be more than one root.");
            i4 = 0;
            while (i4 < root.getChildren().size()) {
                System.err.println(String.format("%2d. %12s", i4 + 1, ((Branch)root.getChildren().get(i4).getData()).getBranchTag().toConsenseString()));
                ++i4;
            }
            return null;
        }
        if (root.getChildren().size() == 0) {
            System.err.println("ERROR: There is no root.");
            return null;
        }
        root = root.removeChild(0);
        BranchAnalysis.growBranches(speciesList, root);
        Tree<Object> tree = new Tree<Object>(root);
        return tree;
    }

    public List<Branch> getRootedBranches() {
        ArrayList<Branch> newBranchList = new ArrayList<Branch>();
        int i = 0;
        while (i < this.branchList.size()) {
            Branch newBranch;
            Branch branch = this.branchList.get(i);
            if (branch.getLeftScore() > 0.0) {
                newBranch = new Branch(branch.getBranchTag().getCopy(false));
                newBranch.setIndex(newBranchList.size());
                newBranch.setScore(branch.getLeftScore());
                newBranchList.add(newBranch);
            }
            if (branch.getRightScore() > 0.0) {
                newBranch = new Branch(branch.getBranchTag().getCopy(true));
                newBranch.setIndex(newBranchList.size());
                newBranch.setScore(branch.getRightScore());
                newBranchList.add(newBranch);
            }
            ++i;
        }
        return newBranchList;
    }

    public String createConsensusTree() {
        List<Branch> newBranchList = this.getRootedBranches();
        Tree<Branch> tree = BranchAnalysis.buildConsensusTree(this.maximumScore, this.speciesList, newBranchList);
        return tree.exportAsUnscaledNewick();
    }

    public String createConsensusTree(int outgroupIndex) {
        if (outgroupIndex >= this.speciesList.size()) {
            return null;
        }
        ArrayList<Branch> newBranchList = new ArrayList<Branch>();
        int i = 0;
        while (i < this.branchList.size()) {
            Branch branch = this.branchList.get(i);
            Branch newBranch = new Branch(branch.getBranchTag().getCopy(outgroupIndex));
            newBranch.setScore(branch.getScore());
            newBranchList.add(newBranch);
            ++i;
        }
        Tree<Branch> tree = BranchAnalysis.buildConsensusTree(this.maximumScore, this.speciesList, newBranchList);
        return tree.exportAsUnscaledNewick();
    }

    public Tree<Branch> createConsensusTree_Backup(boolean printInformation, int outgroupIndex) {
        Branch branch;
        BranchTag branchTagB;
        int j;
        BranchTag branchTagA;
        if (outgroupIndex >= this.speciesList.size()) {
            return null;
        }
        HashMap branchRelationships = new HashMap();
        int i = 0;
        while (i < this.branchList.size()) {
            BranchTag branchTag = this.branchList.get(i).getBranchTag();
            branchRelationships.put(branchTag, new HashMap());
            ++i;
        }
        i = 0;
        while (i < this.branchList.size()) {
            branchTagA = this.branchList.get(i).getBranchTag();
            j = i + 1;
            while (j < this.branchList.size()) {
                branchTagB = this.branchList.get(j).getBranchTag();
                ((HashMap)branchRelationships.get(branchTagA)).put(branchTagB, branchTagA.getRelationshipWith(branchTagB, outgroupIndex));
                ((HashMap)branchRelationships.get(branchTagB)).put(branchTagA, branchTagB.getRelationshipWith(branchTagA, outgroupIndex));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.branchList.size()) {
            branchTagA = this.branchList.get(i).getBranchTag();
            j = 0;
            while (j < this.branchList.size()) {
                branchTagB = this.branchList.get(j).getBranchTag();
                if (branchTagA.equals(branchTagB)) {
                    System.out.print("  ");
                } else if (((HashMap)branchRelationships.get(branchTagA)).get(branchTagB) == BranchRelationship.IMCOMPATIBLE) {
                    System.out.print(" X");
                } else if (((HashMap)branchRelationships.get(branchTagA)).get(branchTagB) == BranchRelationship.MUTEX) {
                    System.out.print(" O");
                } else if (((HashMap)branchRelationships.get(branchTagA)).get(branchTagB) == BranchRelationship.SUBSET) {
                    System.out.print(" <");
                } else if (((HashMap)branchRelationships.get(branchTagA)).get(branchTagB) == BranchRelationship.SUPERSET) {
                    System.out.print(" >");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
        ArrayList<Branch> includedBranches = new ArrayList<Branch>();
        ArrayList<Branch> omittedBranches = new ArrayList<Branch>();
        includedBranches.add(this.branchList.get(0));
        int i2 = 1;
        while (i2 < this.branchList.size()) {
            branch = this.branchList.get(i2);
            boolean valid = true;
            int j2 = 0;
            while (j2 < includedBranches.size()) {
                Branch includedBranch = (Branch)includedBranches.get(j2);
                BranchRelationship relationship = (BranchRelationship)((Object)((HashMap)branchRelationships.get(includedBranch.getBranchTag())).get(branch.getBranchTag()));
                if (relationship == BranchRelationship.IMCOMPATIBLE) {
                    valid = false;
                    break;
                }
                ++j2;
            }
            if (valid) {
                includedBranches.add(branch);
            } else {
                omittedBranches.add(branch);
            }
            ++i2;
        }
        System.out.println("Branches included in the consensus tree");
        i2 = 0;
        while (i2 < includedBranches.size()) {
            branch = (Branch)includedBranches.get(i2);
            if (!branch.getBranchTag().isLeaf() && !branch.getBranchTag().isRoot()) {
                System.out.println(String.format("%4d: %12s | %7.2f", branch.getIndex(), branch.getBranchTag().toConsenseString(), branch.getScore()));
            }
            ++i2;
        }
        System.out.println("Branches omitted from the consensus tree");
        i2 = 0;
        while (i2 < omittedBranches.size()) {
            branch = (Branch)omittedBranches.get(i2);
            if (branch.getBranchTag().isLeaf() || branch.getBranchTag().isRoot()) {
                System.err.println("ERROR: A Leaf or the Root Branch was omitted from the Consensus Tree.");
            }
            System.out.println(String.format("%4d: %12s | %7.2f", branch.getIndex(), branch.getBranchTag().toConsenseString(), branch.getScore()));
            ++i2;
        }
        Node<Object> root = new Node<Object>(null, "root");
        int i3 = 0;
        while (i3 < includedBranches.size()) {
            Branch branch2 = (Branch)includedBranches.get(i3);
            Node<Branch> node = new Node<Branch>(branch2);
            node.setName(String.format("%.2f", branch2.getScore() / this.maximumScore));
            Node<Object> parent = root;
            while (parent.getChildren().size() > 0) {
                boolean traversed = false;
                int j3 = 0;
                while (j3 < parent.getChildren().size()) {
                    Node<Object> child = parent.getChildren().get(j3);
                    Branch childBranch = child.getData();
                    BranchRelationship relationship = (BranchRelationship)((Object)((HashMap)branchRelationships.get(childBranch.getBranchTag())).get(branch2.getBranchTag()));
                    if (relationship == BranchRelationship.SUPERSET) {
                        traversed = true;
                        parent = child;
                        break;
                    }
                    if (relationship == BranchRelationship.SUBSET) {
                        parent.removeChild(j3);
                        node.addChild(child, 0.0);
                        --j3;
                    }
                    ++j3;
                }
                if (!traversed) break;
            }
            parent.addChild(node, 0.0);
            ++i3;
        }
        if (root.getChildren().size() > 1) {
            System.err.println("ERROR: There seems to be more than one root.");
            i3 = 0;
            while (i3 < root.getChildren().size()) {
                System.err.println(String.format("%2d. %12s", i3 + 1, ((Branch)root.getChildren().get(i3).getData()).getBranchTag().toConsenseString()));
                ++i3;
            }
            return null;
        }
        if (root.getChildren().size() == 0) {
            System.err.println("ERROR: There is no root.");
            return null;
        }
        root = root.removeChild(0);
        BranchAnalysis.growBranches(this.speciesList, root);
        Tree<Object> tree = new Tree<Object>(root);
        return tree;
    }

    public String markTree(File newickFile, boolean isRooted, boolean isBCG, int missingTolerance, int mismatchTolerance) {
        String newickString = "";
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(newickFile));){
                char[] buf = new char[(int)newickFile.length()];
                reader.read(buf, 0, (int)newickFile.length());
                newickString = new String(buf);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Tree tree = Tree.importNewick(newickString)[0];
        this.markTree(tree, isRooted, isBCG, missingTolerance, mismatchTolerance);
        return tree.exportAsNewick();
    }

    public String markTree(String newickString, boolean isRooted, boolean isBCG, int missingTolerance, int mismatchTolerance) {
        Tree tree = Tree.importNewick(newickString)[0];
        this.markTree(tree, isRooted, isBCG, missingTolerance, mismatchTolerance);
        return tree.exportAsNewick();
    }

    private void markTree(Tree tree, boolean isRooted, boolean isBCG, int missingTolerance, int mismatchTolerance) {
        List leaves = tree.getLeaves();
        int numOfLeaves = leaves.size();
        Boolean[] existingSpecies = new Boolean[this.speciesList.size()];
        int j = 0;
        while (j < existingSpecies.length) {
            existingSpecies[j] = false;
            ++j;
        }
        j = 0;
        while (j < leaves.size()) {
            if (this.speciesMap.containsKey(leaves.get(j).getName())) {
                int index = this.speciesMap.get(leaves.get(j).getName()).getIndex();
                existingSpecies[index] = true;
            }
            ++j;
        }
        ArrayList<Integer> missingSpecies = new ArrayList<Integer>();
        int j2 = 0;
        while (j2 < existingSpecies.length) {
            if (!existingSpecies[j2].booleanValue()) {
                missingSpecies.add(j2);
            }
            ++j2;
        }
        int numMissingSpecies = this.speciesList.size() - leaves.size();
        double points = (double)leaves.size() / (double)this.speciesList.size();
        ArrayList queue = new ArrayList();
        queue.add(tree.getRoot());
        int totalBranches = tree.getNodes().size();
        int current = 0;
        while (current < queue.size()) {
            int j3;
            Node currentNode;
            block18: {
                currentNode = (Node)queue.get(current);
                List currentLeaves = new Tree(currentNode).getLeaves();
                boolean isInvalidBranch = false;
                ArrayList<Integer> speciesOnRight = new ArrayList<Integer>(currentLeaves.size());
                j3 = 0;
                while (j3 < currentLeaves.size()) {
                    if (!this.speciesMap.containsKey(currentLeaves.get(j3).getName())) {
                        isInvalidBranch = true;
                        if (!isBCG) {
                            currentNode.setName(String.format("%.2f", 0));
                            break;
                        }
                        currentNode.setName(String.format("%d", 0));
                        break;
                    }
                    int index = this.speciesMap.get(currentLeaves.get(j3).getName()).getIndex();
                    speciesOnRight.add(index);
                    ++j3;
                }
                if (isInvalidBranch) break block18;
                double score = 0.0;
                int i = 0;
                while (i < this.treeMetadataList.size()) {
                    block20: {
                        BranchTag branchTag;
                        block19: {
                            TreeMetadata tmd = this.treeMetadataList.get(i);
                            boolean useHash = true;
                            int j4 = 0;
                            while (j4 < missingSpecies.size()) {
                                if (tmd.speciesCheck[(Integer)missingSpecies.get(j4)].booleanValue()) {
                                    useHash = false;
                                    break;
                                }
                                ++j4;
                            }
                            if (missingTolerance >= 0 || mismatchTolerance != 0) {
                                useHash = false;
                            }
                            if (!useHash) break block19;
                            branchTag = new BranchTag(this.speciesList.size(), speciesOnRight, tmd.missingSpecies);
                            boolean[] leftAndRight = this.localBranchMaps.get(i).get(branchTag);
                            if (leftAndRight == null) break block20;
                            score += 1.0;
                            break block20;
                        }
                        branchTag = new BranchTag(this.speciesList.size(), speciesOnRight, missingSpecies);
                        for (BranchTag tag : this.localBranchMaps.get(i).keySet()) {
                            if (!tag.equalsIgnoreMissing(branchTag, missingTolerance, mismatchTolerance)) continue;
                            score += 1.0;
                            break;
                        }
                    }
                    ++i;
                }
                if (!currentNode.isLeaf()) {
                    if (!isBCG) {
                        currentNode.setName(String.format("%.2f", score / this.maximumScore));
                    } else {
                        currentNode.setName(String.format("%d", (int)score));
                    }
                }
            }
            j3 = 0;
            while (j3 < currentNode.getChildren().size()) {
                queue.add(currentNode.getChildren().get(j3));
                ++j3;
            }
            ++current;
        }
    }

    public List<Species> getSpeciesList() {
        return Collections.unmodifiableList(this.speciesList);
    }

    public static void printHelpMessage() {
        System.out.println("Lumberjack Branch Analysis");
        System.out.println("version " + version + "\n");
        System.out.println("Usage: Interactive Mode\n\tjava -jar Lumberjack.jar -i");
        System.out.println("   or: Consensus Tree Creation\n\tjava -jar Lumberjack.jar -c <input_file> <outgroup_index>");
        System.out.println("   or: Bootstrap Value Marking\n\tjava -jar Lumberjack.jar -b <input_file> <target_newick_file> [-r]\n");
        System.out.println("<input_file>\t\tName of the file that contains all the newick trees.");
        System.out.println("<outgroup_index>\tIndex of the item to be used as the outgroup.\n\t\t\tIf this value is 0, there will be no outgroup and the\n\t\t\tinput trees will be treated as rooted trees.");
        System.out.println("<target_newick_file>\tThe newick file to be marked.");
        System.out.println("-r\t\t\tUse if the target tree is rooted.");
    }

    public static void runTest() {
        BranchAnalysis ba = new BranchAnalysis(new File("intree"));
        System.out.println(ba.getAnalysis());
        System.out.println(BranchAnalysis.speciesListToTextTables(ba.speciesList));
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File("test.txt")));
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(ba.createConsensusTree());
        System.out.println(ba.createConsensusTree(0));
    }

    public static void runInteractiveMode() {
        int action;
        Scanner keyboard = new Scanner(System.in);
        System.out.println("Lumberjack Branch Analysis");
        System.out.println("version " + version + "\n");
        File inputFile = null;
        System.out.println("Enter the input file name. This input file should contain all the newick trees to be used in this analysis.");
        do {
            System.out.print("Input File Name: ");
            inputFile = new File(keyboard.next());
            if (inputFile.exists()) continue;
            System.out.println("File \"" + inputFile.getPath() + "\" does not exist.");
        } while (!inputFile.exists());
        BranchAnalysis branchAnalysis = new BranchAnalysis(inputFile);
        do {
            System.out.println("Select an action to perform.");
            System.out.println(" 1: Print Analysis.");
            System.out.println(" 2: Get Consensus Tree.");
            System.out.println(" 3: Mark Bootstrap Values on a Tree.");
            System.out.println(" 0: Quit.");
            action = keyboard.nextInt();
            if (action == 1) {
                System.out.println(branchAnalysis.getAnalysis());
                continue;
            }
            if (action == 2) {
                System.out.println("Enter the index of the Item to be used as the outgroup. Enter 0 to not use a outgroup.");
                branchAnalysis.printAllSpecies();
                int outgroupIndex = -1;
                do {
                    System.out.print("Outgroup Index: ");
                } while ((outgroupIndex = keyboard.nextInt()) < 0 || outgroupIndex > branchAnalysis.getSpeciesList().size());
                System.out.println("Consensus Tree:");
                if (outgroupIndex == 0) {
                    System.out.println(branchAnalysis.createConsensusTree());
                    continue;
                }
                System.out.println(branchAnalysis.createConsensusTree(outgroupIndex - 1));
                continue;
            }
            if (action != 3) continue;
            System.out.println("Enter the file that contains the target newick tree to be marked. Or enter the newick string directly. (Must end with a semicolon)");
            branchAnalysis.printAllSpecies();
            String targetNewickString = "";
            File targetFile = null;
            boolean isString = false;
            boolean isFile = false;
            do {
                System.out.println("Target Newick File or Newick String: ");
                String string = keyboard.next();
                if (string.endsWith(";")) {
                    targetNewickString = string;
                    isString = true;
                    continue;
                }
                File file = new File(string);
                if (!file.exists()) continue;
                targetFile = file;
                isFile = true;
            } while (!isString && !isFile);
            boolean isRooted = false;
            System.out.println("Is the tree rooted?");
            String string = keyboard.next();
            if (string.toLowerCase().startsWith("y")) {
                isRooted = true;
            }
            System.out.println("Marked Tree:");
            if (isFile) {
                System.out.println(branchAnalysis.markTree(targetFile, isRooted, false, -1, 0));
            }
            if (!isString) continue;
            System.out.println(branchAnalysis.markTree(targetNewickString, isRooted, false, -1, 0));
        } while (action != 0);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            BranchAnalysis.printHelpMessage();
        } else if (args[0].equals("-i")) {
            BranchAnalysis.runInteractiveMode();
        } else if (args[0].equals("-c")) {
            File inputFile = new File(args[1]);
            BranchAnalysis branchAnalysis = new BranchAnalysis(inputFile);
            int outgroupIndex = Integer.parseInt(args[2]);
            String consensusTree = "";
            consensusTree = outgroupIndex == 0 ? branchAnalysis.createConsensusTree() : branchAnalysis.createConsensusTree(outgroupIndex);
            System.out.println("Consensus tree");
            System.out.println(consensusTree);
        } else if (args[0].equals("-b")) {
            File inputFile = new File(args[1]);
            BranchAnalysis branchAnalysis = new BranchAnalysis(inputFile);
            File targetNewickFile = new File(args[2]);
            String markedTree = "";
            markedTree = args.length == 4 && args[3].equals("-r") ? branchAnalysis.markTree(targetNewickFile, true, false, -1, 0) : (args.length == 4 && args[3].equals("-bcg") ? branchAnalysis.markTree(targetNewickFile, false, true, -1, 0) : branchAnalysis.markTree(targetNewickFile, false, false, -1, 0));
            System.out.println(markedTree);
        } else if (args[0].equals("-t")) {
            BranchAnalysis.runTest();
        } else {
            BranchAnalysis.printHelpMessage();
        }
    }
}

