/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.slf4j.Log4jMarker;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    @Override
    public Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker(name);
        marker = new Log4jMarker(log4jMarker);
        Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    @Override
    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    @Override
    public boolean detachMarker(String name) {
        return false;
    }

    @Override
    public Marker getDetachedMarker(String name) {
        return this.getMarker(name);
    }
}

