/*
 * Decompiled with CFR 0.152.
 */
package leb.seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import leb.seq.FastaSeq;

public class FastaSeqList {
    public ArrayList<FastaSeq> list = new ArrayList();

    public int getSize() {
        return this.list.size();
    }

    public int size() {
        return this.list.size();
    }

    public ArrayList<FastaSeq> getRandom(int size) {
        if (this.list.size() < size) {
            size = this.list.size();
        }
        Collections.shuffle(this.list);
        ArrayList<FastaSeq> res = new ArrayList<FastaSeq>();
        int i = 0;
        while (i < size) {
            res.add(this.list.get(i));
            ++i;
        }
        return res;
    }

    public void shuffle() {
        Collections.shuffle(this.list);
    }

    public void checkBase() {
        int A = 0;
        int G = 0;
        int C = 0;
        int T = 0;
        int a = 0;
        int c = 0;
        int g = 0;
        int t = 0;
        int others = 0;
        StringBuffer others_str = new StringBuffer("");
        int i = 0;
        while (i < this.list.size()) {
            FastaSeq fs = this.list.get(i);
            int n = 0;
            while (n < fs.sequence.length()) {
                switch (fs.sequence.charAt(n)) {
                    case 'A': {
                        ++A;
                        break;
                    }
                    case 'C': {
                        ++C;
                        break;
                    }
                    case 'G': {
                        ++G;
                        break;
                    }
                    case 'T': {
                        ++T;
                        break;
                    }
                    case 'a': {
                        ++a;
                        break;
                    }
                    case 'c': {
                        ++c;
                        break;
                    }
                    case 'g': {
                        ++g;
                        break;
                    }
                    case 't': {
                        ++t;
                        break;
                    }
                    default: {
                        ++others;
                        others_str.append(fs.sequence.charAt(n));
                    }
                }
                ++n;
            }
            ++i;
        }
        System.out.println("Check base result:");
        System.out.println("A=" + A + " C=" + C + " G=" + G + " T=" + T + "  Total = " + (A + C + G + T));
        System.out.println("a=" + a + " c=" + c + " g=" + g + " t=" + t + "  Total = " + (a + c + g + t));
        System.out.println("others =" + others);
        System.out.println("others =" + others_str);
    }

    public FastaSeq find(String title) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.equals(title)) {
                return this.list.get(i);
            }
            ++i;
        }
        return null;
    }

    public int find_index(String title) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.equals(title)) {
                return this.list.get((int)i).index;
            }
            ++i;
        }
        return -1;
    }

    public int find_int(String title) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.equals(title)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FastaSeq find_part(String str) {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.indexOf(str) > -1) {
                return this.list.get(i);
            }
            ++i;
        }
        return null;
    }

    public FastaSeq findFastaSeq(String title) {
        FastaSeq res = null;
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.equals(title)) {
                return this.list.get(i);
            }
            ++i;
        }
        return res;
    }

    String extractSeq(String sequence, boolean[] taq) {
        StringBuffer res = new StringBuffer("");
        int i = 0;
        while (i < sequence.length()) {
            if (taq[i]) {
                res.append(sequence.charAt(i));
            }
            ++i;
        }
        return new String(res);
    }

    public FastaSeqList selectACGT() {
        FastaSeqList res = new FastaSeqList();
        boolean[] tag = new boolean[this.list.get((int)0).sequence.length()];
        int i = 0;
        while (i < tag.length) {
            tag[i] = true;
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            int n = 0;
            while (n < this.list.get((int)i).sequence.length()) {
                if (tag[n]) {
                    switch (this.list.get((int)i).sequence.charAt(n)) {
                        case 'A': {
                            break;
                        }
                        case 'C': {
                            break;
                        }
                        case 'G': {
                            break;
                        }
                        case 'T': {
                            break;
                        }
                        default: {
                            tag[n] = false;
                        }
                    }
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, this.extractSeq(this.list.get((int)i).sequence, tag), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
            ++i;
        }
        return res;
    }

    public int getMaxSeqLength() {
        int max = 0;
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).sequence.length() > max) {
                max = this.list.get((int)i).sequence.length();
            }
            ++i;
        }
        return max;
    }

    public FastaSeqList selectTighten() {
        FastaSeqList res = new FastaSeqList();
        int max_length = this.getMaxSeqLength();
        int list_size = this.list.size();
        int[] gap_count = new int[max_length];
        int i = 0;
        while (i < gap_count.length) {
            gap_count[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            int n = 0;
            while (n < this.list.get((int)i).sequence.length()) {
                if (this.list.get((int)i).sequence.charAt(n) == '-') {
                    int n2 = n;
                    gap_count[n2] = gap_count[n2] + 1;
                }
                if (this.list.get((int)i).sequence.charAt(n) == '.') {
                    int n3 = n;
                    gap_count[n3] = gap_count[n3] + 1;
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            StringBuffer sb = new StringBuffer();
            int n = 0;
            while (n < this.list.get((int)i).sequence.length()) {
                if (gap_count[n] != list_size) {
                    sb.append(this.list.get((int)i).sequence.charAt(n));
                }
                ++n;
            }
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, new String(sb), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
            ++i;
        }
        return res;
    }

    public FastaSeqList selectVariable() {
        FastaSeqList res = new FastaSeqList();
        boolean[] tag = new boolean[this.list.get((int)0).sequence.length()];
        int i = 0;
        while (i < tag.length) {
            tag[i] = false;
            ++i;
        }
        int n = 0;
        while (n < tag.length) {
            if (!tag[n]) {
                char firstBase = this.list.get((int)0).sequence.charAt(n);
                int i2 = 1;
                while (i2 < this.list.size()) {
                    char base = this.list.get((int)i2).sequence.charAt(n);
                    if (firstBase != base) {
                        tag[n] = true;
                        break;
                    }
                    ++i2;
                }
            }
            ++n;
        }
        i = 0;
        while (i < this.list.size()) {
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, this.extractSeq(this.list.get((int)i).sequence, tag), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
            ++i;
        }
        return res;
    }

    public FastaSeqList selectMajority(double cutoff) {
        FastaSeqList res = new FastaSeqList();
        int max_length = this.getMaxSeqLength();
        int list_size = this.list.size();
        int[] gap_count = new int[max_length];
        int i = 0;
        while (i < gap_count.length) {
            gap_count[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            int n = 0;
            while (n < this.list.get((int)i).sequence.length()) {
                if (this.list.get((int)i).sequence.charAt(n) == '-') {
                    int n2 = n;
                    gap_count[n2] = gap_count[n2] + 1;
                }
                if (this.list.get((int)i).sequence.charAt(n) == '.') {
                    int n3 = n;
                    gap_count[n3] = gap_count[n3] + 1;
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < this.list.size()) {
            StringBuffer sb = new StringBuffer();
            int n = 0;
            while (n < this.list.get((int)i).sequence.length()) {
                double per_base = (list_size - gap_count[n]) * 100 / list_size;
                if (!(per_base < cutoff)) {
                    sb.append(this.list.get((int)i).sequence.charAt(n));
                }
                ++n;
            }
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, new String(sb), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
            ++i;
        }
        return res;
    }

    public boolean write(String fileName) {
        boolean res = true;
        res = this.write(new File(fileName));
        return res;
    }

    public boolean write(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            int i = 0;
            while (i < this.list.size()) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean write_FQ(String fileName) {
        boolean res = true;
        res = this.write_FQ(new File(fileName));
        return res;
    }

    public boolean write_FQ(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            int i = 0;
            while (i < this.list.size()) {
                fw.write("@" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
                fw.write("+\n");
                fw.write(String.valueOf(this.list.get((int)i).quality) + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean genomeFastaWrite(String fileName) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(new File(fileName));
            int i = 0;
            while (i < this.list.size()) {
                fw.write(">zZ" + this.list.get((int)i).title + "zZ\n" + this.list.get((int)i).sequence + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFile(String full_fn) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(full_fn);
            int i = 0;
            while (i < this.list.size()) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFile(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            int i = 0;
            while (i < this.list.size()) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFileWithIndex(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            int i = 0;
            while (i < this.list.size()) {
                fw.write(">" + (i + 1) + "\n" + this.list.get((int)i).sequence + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public String getString() {
        StringBuffer res = new StringBuffer("");
        int i = 0;
        while (i < this.list.size()) {
            res.append(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
            ++i;
        }
        return new String(res);
    }

    public void add(FastaSeq fa) {
        this.list.add(fa);
    }

    public int findFastaSeqIndex(String title) {
        int res = -1;
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).title.equals(title)) {
                return i;
            }
            ++i;
        }
        return res;
    }

    public boolean append(FastaSeqList fal) {
        boolean res = true;
        if (this.list.size() != fal.list.size()) {
            System.out.println("different size! from FastaSeqList.append()");
            return false;
        }
        int i = 0;
        while (i < this.list.size()) {
            FastaSeq fa = fal.findFastaSeq(this.list.get((int)i).title);
            if (fa == null) {
                System.out.println("not matching title:" + this.list.get((int)i).title + "! from FastaSeqList.append()");
                return false;
            }
            StringBuffer sb = new StringBuffer(this.list.get((int)i).sequence);
            sb.append(fa.sequence);
            this.list.get((int)i).sequence = new String(sb);
            ++this.list.get((int)i).noAddedSeq;
            ++i;
        }
        return true;
    }

    public boolean append_no_check(FastaSeqList fal) {
        boolean res = true;
        if (this.list.size() != fal.list.size()) {
            System.out.println("different size! from FastaSeqList.append()");
            return false;
        }
        int i = 0;
        while (i < fal.list.size()) {
            StringBuffer sb = new StringBuffer(this.list.get((int)i).sequence);
            sb.append(fal.list.get((int)i).sequence);
            this.list.get((int)i).sequence = new String(sb);
            ++this.list.get((int)i).noAddedSeq;
            ++i;
        }
        return true;
    }

    public int importFileQual(String fileName) {
        File f = new File(fileName);
        return this.importFileQual(f);
    }

    public int importFile(String fileName) {
        File f = new File(fileName);
        return this.importFile(f);
    }

    public int importFile_clcbio_contig(String fileName) {
        File f = new File(fileName);
        int res = this.importFile(f);
        int i = 0;
        while (i < this.list.size()) {
            String[] s;
            if (this.list.get((int)i).title != null && (s = this.list.get((int)i).title.split("Average coverage: ")).length == 2) {
                this.list.get((int)i).coverage = Double.valueOf(s[1].replaceAll(",", ""));
            }
            ++i;
        }
        return res;
    }

    public int importFile_FQ(String fileName) {
        File f = new File(fileName);
        return this.importFile_FQ(f);
    }

    public void addSeq(String title, String seqeunce) {
        FastaSeq fa = new FastaSeq();
        fa.setSeq(title, seqeunce, 1);
        this.list.add(fa);
    }

    public int importFileQual(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br_qual(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importFile(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importFile_FQ(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br_FQ(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public void set_index() {
        int i = 0;
        while (i < this.list.size()) {
            this.list.get((int)i).index = i + 1;
            ++i;
        }
    }

    public int import_br(BufferedReader br) {
        String line = null;
        boolean isFirst = true;
        String tmpTitle = null;
        StringBuffer tmpSeq = new StringBuffer("");
        boolean isFirstLineFound = false;
        try {
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith(">")) {
                    tmpSeq.append(line);
                    isFirstLineFound = true;
                    isFirst = false;
                    continue;
                }
                if (line.startsWith(">") || line.startsWith("#")) {
                    if (isFirst) {
                        isFirst = false;
                        tmpTitle = line.substring(1);
                        isFirstLineFound = true;
                        continue;
                    }
                    this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
                    tmpTitle = line.substring(1);
                    tmpSeq = new StringBuffer("");
                    continue;
                }
                if (!isFirstLineFound) continue;
                tmpSeq = tmpSeq.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
        return this.list.size();
    }

    public int import_br_qual(BufferedReader br) {
        String line = null;
        boolean isFirst = true;
        String tmpTitle = null;
        StringBuffer tmpSeq = new StringBuffer("");
        boolean isFirstLineFound = false;
        try {
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith(">")) {
                    tmpSeq.append(" " + line);
                    isFirstLineFound = true;
                    isFirst = false;
                    continue;
                }
                if (line.startsWith(">") || line.startsWith("#")) {
                    if (isFirst) {
                        isFirst = false;
                        tmpTitle = line.substring(1);
                        isFirstLineFound = true;
                        continue;
                    }
                    this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
                    tmpTitle = line.substring(1);
                    tmpSeq = new StringBuffer("");
                    continue;
                }
                if (!isFirstLineFound) continue;
                tmpSeq = tmpSeq.append(" " + line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addSeq(tmpTitle, new String(tmpSeq).trim().toUpperCase());
        return this.list.size();
    }

    public int import_br_FQ(BufferedReader br) {
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                String title = null;
                StringBuilder sbSeq = new StringBuilder();
                StringBuilder sbQual = new StringBuilder();
                if (!line.startsWith("@")) continue;
                title = line.substring(1);
                while (!(line = br.readLine()).startsWith("+")) {
                    sbSeq.append(line);
                }
                while (sbQual.length() != sbSeq.length()) {
                    line = br.readLine();
                    sbQual.append(line);
                    if (sbQual.length() <= sbSeq.length()) continue;
                    System.out.println("Quality length is different with sequence length! Abort!!");
                    System.out.println(title);
                    System.exit(0);
                }
                FastaSeq fa = new FastaSeq();
                fa.title = title;
                fa.sequence = sbSeq.toString();
                fa.quality = sbQual.toString();
                this.list.add(fa);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importString(String input_str) {
        StringReader sr = new StringReader(input_str);
        BufferedReader br = new BufferedReader(sr);
        this.import_br(br);
        try {
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public void print() {
        System.out.println("FastaSeqList:");
        System.out.println("index\tsize\taddedSeq\tacc\ttitle:");
        int i = 0;
        while (i < this.list.size()) {
            System.out.println(String.valueOf(i + 1) + "\t" + this.list.get((int)i).sequence.length() + "\t" + this.list.get((int)i).noAddedSeq + "\t" + this.list.get((int)i).acc + "\t" + this.list.get((int)i).title);
            ++i;
        }
    }

    public int countVariableSites() {
        int res = 0;
        int i = 1;
        while (i < this.list.size()) {
            FastaSeq fa = this.list.get(i);
            int n = 0;
            while (n < this.list.get((int)0).sequence.length()) {
                if (this.list.get((int)0).sequence.charAt(n) != fa.sequence.charAt(n)) {
                    ++res;
                }
                ++n;
            }
            ++i;
        }
        return res;
    }

    public void writePhylip(String fname) {
        try {
            FileWriter fw = new FileWriter(fname);
            fw.write(String.valueOf(this.list.size()) + " " + this.list.get((int)0).sequence.length() + "\n");
            int i = 0;
            while (i < this.list.size()) {
                fw.write(String.format("%10s ", this.list.get((int)i).title));
                fw.write(String.valueOf(this.list.get((int)i).sequence) + "\n");
                ++i;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getStringNexusDNA() {
        StringBuffer res = new StringBuffer("#NEXUS\nbegin data;\ndimensions ntax=" + this.list.size() + " nchar=" + this.list.get((int)0).sequence.length() + ";\n");
        res.append("format datatype=dna interleave=no gap=-;\n");
        res.append("matrix\n");
        int i = 0;
        while (i < this.list.size()) {
            res.append(String.valueOf(this.list.get((int)i).title.replaceAll("\\s", "_")) + "\t" + this.list.get((int)i).sequence + "\n");
            ++i;
        }
        res.append(";\nend;\n");
        return new String(res);
    }

    public void writeNexusDNA(String fname) {
        try {
            FileWriter fw = new FileWriter(fname);
            fw.write(this.getStringNexusDNA());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSum() {
        int res = 0;
        int i = 0;
        while (i < this.list.size()) {
            res += this.list.get((int)i).sequence.trim().length();
            ++i;
        }
        return res;
    }

    public double cal_coverage_average() {
        double res = 0.0;
        double total = 0.0;
        double total_base = 0.0;
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get((int)i).coverage == -1.0) {
                return -1.0;
            }
            int len = this.list.get((int)i).sequence.trim().length();
            total += this.list.get((int)i).coverage * (double)len;
            total_base += (double)len;
            ++i;
        }
        res = total / total_base;
        return res;
    }

    public int importFile_454_contig(String fileName) {
        File f = new File(fileName);
        int res = this.importFile(f);
        int i = 0;
        while (i < this.list.size()) {
            String[] s;
            if (this.list.get((int)i).title != null && (s = this.list.get((int)i).title.split("\\s+")).length == 3) {
                this.list.get((int)i).title = s[0];
                this.list.get((int)i).length = Integer.valueOf(s[1].replaceAll("length=", ""));
                this.list.get((int)i).n_reads = Integer.valueOf(s[2].replaceAll("numreads=", ""));
            }
            ++i;
        }
        return res;
    }

    public int importFile_454_contig(String fileName, String alignment_info_filename) throws IOException {
        int res = this.importFile_454_contig(fileName);
        File f = new File(alignment_info_filename);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        boolean is_first = true;
        String contig = null;
        double total = 0.0;
        double n_reads = 0.0;
        while ((line = br.readLine()) != null) {
            String[] s;
            if (line.startsWith("Position")) continue;
            if (line.startsWith(">")) {
                s = line.substring(1).split("\\s+");
                if (is_first) {
                    contig = s[0];
                    is_first = false;
                    total = 0.0;
                    n_reads = 0.0;
                    continue;
                }
                double coverage = total / n_reads;
                int index = this.find_int(contig);
                if (index == -1) {
                    System.out.println("Warning: " + contig + " not in contig file");
                } else {
                    this.list.get((int)index).coverage = coverage;
                }
                contig = s[0];
                total = 0.0;
                n_reads = 0.0;
                continue;
            }
            s = line.split("\\s+");
            n_reads += 1.0;
            total += Double.valueOf(s[4]).doubleValue();
        }
        return res;
    }

    public void importFile_454_scaffold(String fileName) throws IOException {
        File f = new File(fileName);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] s;
            if (!line.startsWith("scaffold") || !(s = line.split("\\s+"))[5].startsWith("contig")) continue;
            int index = this.find_int(s[5]);
            if (index == -1) {
                System.out.println("Warning: " + s[5] + " not in contig file");
            }
            this.list.get((int)index).scaffold = s[0];
        }
    }

    public void set_RAST_input_title(String chunlab_genome_uid) {
        int i = 0;
        while (i < this.list.size()) {
            FastaSeq fa = this.list.get(i);
            String[] s = fa.title.split("\\|");
            String title = "";
            if (s.length > 0 && s[0].startsWith("contig") && s[1].equals("cv")) {
                String nummber = String.format("%04d", i + 1);
                title = String.valueOf(nummber) + "|cn|" + chunlab_genome_uid + "|ctg|" + (i + 1);
                int n = 1;
                while (n < s.length) {
                    title = String.valueOf(title) + "|" + s[n];
                    ++n;
                }
                fa.title = title;
                this.list.set(i, fa);
            }
            ++i;
        }
    }
}

