/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.util.ArrayList;
import java.util.List;
import lbj.Node;

public class Tree<T> {
    String newickString = null;
    private Node<T> root;

    public Tree() {
    }

    public Tree(Node<T> root) {
        this.root = root;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public void setRoot(Node<T> root) {
        this.root = root;
    }

    public List<Node<T>> getNodes() {
        ArrayList<Node<T>> nodes = new ArrayList<Node<T>>();
        ArrayList queue = new ArrayList(this.root.getNumberOfDescendants());
        queue.add(this.root);
        int index = 0;
        while (index < queue.size()) {
            Node current = (Node)queue.get(index);
            nodes.add(current);
            if (!current.isLeaf()) {
                queue.addAll(current.getChildren());
            }
            ++index;
        }
        return nodes;
    }

    public List<Node<T>> getInternalNodes() {
        ArrayList<Node<T>> internalNodes = new ArrayList<Node<T>>();
        ArrayList queue = new ArrayList(this.root.getNumberOfDescendants());
        queue.add(this.root);
        int index = 0;
        while (index < queue.size()) {
            Node current = (Node)queue.get(index);
            if (!current.isLeaf()) {
                internalNodes.add(current);
                queue.addAll(current.getChildren());
            }
            ++index;
        }
        return internalNodes;
    }

    public List<Node<T>> getLeaves() {
        ArrayList<Node<T>> leaves = new ArrayList<Node<T>>();
        this.bfs(this.root, leaves);
        return leaves;
    }

    public void bfs(Node<T> parent, List<Node<T>> list) {
        if (parent.isLeaf()) {
            list.add(parent);
        } else {
            int i = 0;
            while (i < parent.getChildren().size()) {
                this.bfs(parent.getChildren().get(i), list);
                ++i;
            }
        }
    }

    public String exportAsNewick() {
        String result = "";
        if (this.root == null) {
            return "";
        }
        result = Tree.traversal(this.root);
        return result;
    }

    public static String traversal(Node node) {
        if (node.isLeaf()) {
            return String.valueOf(node.getName()) + ":" + node.getDistance();
        }
        String result = "";
        int i = 0;
        while (i < node.getChildren().size()) {
            result = String.valueOf(result) + Tree.traversal(node.getChildren().get(i));
            if (i + 1 < node.getChildren().size()) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = "(" + result + ")";
        String label = node.getName();
        label = node.isRoot() ? String.valueOf(label) + ";" : String.valueOf(label) + ":" + node.getDistance();
        return String.valueOf(result) + label;
    }

    public String exportAsUnscaledNewick() {
        String result = "";
        if (this.root == null) {
            return "";
        }
        result = Tree.unscaledTraversal(this.root);
        return result;
    }

    public static String unscaledTraversal(Node node) {
        if (node.isLeaf()) {
            return node.getName();
        }
        String result = "";
        int i = 0;
        while (i < node.getChildren().size()) {
            result = String.valueOf(result) + Tree.unscaledTraversal(node.getChildren().get(i));
            if (i + 1 < node.getChildren().size()) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        return "(" + result + ")" + (node.isRoot() ? ";" : node.getName());
    }

    public static Tree parseNewick(String newickString) {
        if (!newickString.endsWith(";")) {
            return null;
        }
        Tree tree = new Tree();
        tree.newickString = newickString;
        String name = "";
        double distance = 0.0;
        int index = newickString.lastIndexOf(41);
        if (index + 1 < newickString.length() - 1) {
            String string = newickString.substring(index + 1, newickString.length() - 1);
            int separatorIdx = string.lastIndexOf(":");
            if (separatorIdx < 0) {
                name = string;
            } else {
                name = string.substring(0, separatorIdx);
                distance = Double.parseDouble(string.substring(separatorIdx + 1));
            }
        }
        String descendant = newickString.substring(1, index);
        Node root = new Node(name);
        root.setDistance(distance);
        tree.setRoot(root);
        ArrayList parents = new ArrayList();
        ArrayList<String> queue = new ArrayList<String>();
        parents.add(root);
        queue.add(descendant);
        String indentation = "\t";
        int queueIndex = 0;
        while (queueIndex < queue.size()) {
            Node parent = (Node)parents.get(queueIndex);
            String current = (String)queue.get(queueIndex);
            int i = 0;
            while (i < current.length()) {
                if (current.charAt(i) == '(') {
                    int openedParenthesis = 0;
                    int j = i + 1;
                    while (j < current.length()) {
                        char c = current.charAt(j);
                        if (c == ')') {
                            if (openedParenthesis == 0) {
                                String subTree = current.substring(i + 1, j);
                                String values = "";
                                if (current.length() > j + 1) {
                                    int end = current.indexOf(44, j + 1);
                                    if (end < 0) {
                                        values = current.substring(j + 1);
                                        i = current.length();
                                    } else {
                                        values = current.substring(j + 1, end);
                                        i = end;
                                    }
                                } else {
                                    values = "";
                                    i = j;
                                }
                                String nodeName = "";
                                double nodeDistance = 0.0;
                                int distIdx = values.lastIndexOf(58);
                                if (distIdx < 0) {
                                    nodeName = values;
                                } else {
                                    nodeName = values.substring(0, distIdx);
                                    try {
                                        nodeDistance = Double.parseDouble(values.substring(distIdx + 1));
                                    }
                                    catch (NumberFormatException e) {
                                        e.printStackTrace();
                                    }
                                }
                                Node node = new Node(nodeName);
                                parent.addChild(node, nodeDistance);
                                parents.add(node);
                                queue.add(subTree);
                                break;
                            }
                            --openedParenthesis;
                        } else if (c == '(') {
                            ++openedParenthesis;
                        }
                        ++j;
                    }
                } else {
                    int end = current.indexOf(44, i);
                    if (end < 0) {
                        String values = current.substring(i);
                        String nodeName = "";
                        double nodeDistance = 0.0;
                        int distIdx = values.lastIndexOf(58);
                        if (distIdx < 0) {
                            nodeName = values;
                        } else {
                            nodeName = values.substring(0, distIdx);
                            try {
                                nodeDistance = Double.parseDouble(values.substring(distIdx + 1));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        Node node = new Node(nodeName);
                        parent.addChild(node, nodeDistance);
                        break;
                    }
                    String values = current.substring(i, end);
                    String nodeName = "";
                    double nodeDistance = 0.0;
                    int distIdx = values.lastIndexOf(58);
                    if (distIdx < 0) {
                        nodeName = values;
                    } else {
                        nodeName = values.substring(0, distIdx);
                        try {
                            nodeDistance = Double.parseDouble(values.substring(distIdx + 1));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    Node node = new Node(nodeName);
                    parent.addChild(node, nodeDistance);
                    if (end + 1 == current.length()) {
                        Node lastNode = new Node("");
                        parent.addChild(lastNode, 0.0);
                    }
                    i = end;
                }
                ++i;
            }
            indentation = String.valueOf(indentation) + "\t";
            ++queueIndex;
        }
        return tree;
    }

    public static Tree[] importNewick(String newickString) {
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        int offset = 0;
        int index = 0;
        while (index < newickString.length()) {
            if (newickString.charAt(index) == ';') {
                String string = newickString.substring(offset, index + 1).trim();
                treeList.add(Tree.parseNewick(string));
                offset = index + 1;
            }
            ++index;
        }
        return treeList.toArray(new Tree[treeList.size()]);
    }

    public static void printDFS(String indentation, Node parent) {
        System.out.println(String.valueOf(indentation) + "\"" + parent.getName() + "\"" + " (" + parent.getDistance() + ")");
        int i = 0;
        while (i < parent.getChildren().size()) {
            Node current = parent.getChildren().get(i);
            Tree.printDFS(String.valueOf(indentation) + "  ", current);
            ++i;
        }
    }
}

