/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.util.ArrayList;
import java.util.List;

public class Node<T> {
    private T data;
    private String name;
    private double distance;
    private Node<T> parent;
    private List<Node<T>> children = new ArrayList<Node<T>>();
    private int height = 0;
    private int level = 0;
    private double distanceFromRoot = 0.0;
    private int numberOfDescendants = 0;
    private double length = 0.0;

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public Node(T data) {
        this.data = data;
    }

    public Node(String name) {
        this.name = name;
    }

    public Node(T data, String name) {
        this.data = data;
        this.name = name;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public void setParent(Node<T> parent) {
        this.parent = parent;
    }

    public List<Node<T>> getChildren() {
        return this.children;
    }

    public boolean addChildForce(Node<T> child) {
        return this.addChildForce(this.children.size(), child);
    }

    public boolean addChild(Node<T> child, double distance) {
        return this.addChild(this.children.size(), child, distance);
    }

    public boolean addChildForce(int index, Node<T> child) {
        this.children.add(index, child);
        return true;
    }

    public boolean addChild(int index, Node<T> child, double distance) {
        if (!child.isRoot()) {
            return false;
        }
        child.setDistance(distance);
        int newDescendants = 1 + child.getNumberOfDescendants();
        Node<T> last = child;
        Node<T> current = this;
        do {
            double newLength;
            current.numberOfDescendants += newDescendants;
            int newHeight = 1 + last.height;
            if (newHeight > current.height) {
                current.height = newHeight;
            }
            if ((newLength = last.length + last.distance) > current.length) {
                current.length = newLength;
            }
            last = current;
        } while ((current = current.parent) != null);
        child.updateLevel(this.getLevel() + 1);
        child.updateDistanceFromRoot(this.getDistanceFromRoot() + child.distance);
        child.setParent(this);
        this.children.add(index, child);
        return true;
    }

    public Node<T> removeChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        Node<T> child = this.children.get(index);
        int oldDescendants = 1 + child.getNumberOfDescendants();
        Node<T> last = child;
        Node<T> current = this;
        do {
            current.numberOfDescendants -= oldDescendants;
            int maxHeight = 0;
            int i = 0;
            while (i < this.children.size()) {
                if (i != index && maxHeight < this.children.get(i).getHeight()) {
                    maxHeight = this.children.get(i).getHeight();
                }
                ++i;
            }
            current.height = maxHeight + 1;
            double maxLength = 0.0;
            int i2 = 0;
            while (i2 < this.children.size()) {
                if (i2 != index && maxLength < this.children.get(i2).getLength() + this.children.get(i2).getDistance()) {
                    maxLength = this.children.get(i2).getLength() + this.children.get(i2).getDistance();
                }
                ++i2;
            }
            current.length = maxLength;
            last = current;
        } while ((current = current.parent) != null);
        child.updateLevel(-(this.getLevel() + 1));
        child.updateDistanceFromRoot(-(this.getDistanceFromRoot() + child.distance));
        child.setParent(null);
        this.children.remove(index);
        return child;
    }

    public int getHeight() {
        return this.height;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void updateDistanceFromRoot(double d) {
        this.distanceFromRoot += d;
        int i = 0;
        while (i < this.getChildren().size()) {
            this.getChildren().get(i).updateDistanceFromRoot(d);
            ++i;
        }
    }

    public void setDistanceFromRoot(double distanceFromRoot) {
        this.distanceFromRoot = distanceFromRoot;
    }

    public double getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    public void updateLevel(int levels) {
        this.level += levels;
        int i = 0;
        while (i < this.getChildren().size()) {
            this.getChildren().get(i).updateLevel(levels);
            ++i;
        }
    }

    public int getNumberOfDescendants() {
        return this.numberOfDescendants;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public static double calculateLength(Node current) {
        if (current.isLeaf()) {
            return 0.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < current.getChildren().size()) {
            Node child = current.getChildren().get(i);
            double length = child.getDistance() + Node.calculateLength(child);
            if (max < length) {
                max = length;
            }
            ++i;
        }
        return max;
    }
}

