/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.math.BigInteger;
import java.util.Iterator;

public class KmerIterator
implements Iterator<String> {
    private String[] charset;
    private int k;
    private int cardinality;
    private int size;
    private int current;
    private int[] next;

    public KmerIterator(String[] charset, int k) {
        this.charset = charset;
        this.k = k;
        this.cardinality = charset.length;
        this.size = (int)Math.pow(this.cardinality, k);
        this.current = 0;
        this.next = new int[k];
        int i = 0;
        while (i < k) {
            this.next[i] = 0;
            ++i;
        }
    }

    @Override
    public boolean hasNext() {
        return this.current < this.size;
    }

    private void setNext() {
        int index = this.k - 1;
        boolean carrying = false;
        do {
            carrying = false;
            int value = this.next[index];
            if (value == this.cardinality - 1) {
                carrying = true;
                this.next[index] = 0;
                continue;
            }
            int n = index;
            this.next[n] = this.next[n] + 1;
        } while (carrying && --index >= 0);
    }

    private String getNext() {
        String string = "";
        int i = 0;
        while (i < this.k) {
            string = String.valueOf(string) + this.charset[this.next[i]];
            ++i;
        }
        return string;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.current;
        this.setNext();
        return this.next.toString();
    }

    @Override
    public void remove() {
    }

    public static void main(String[] args) {
        long end;
        long beg;
        String[] set = new String[]{".", "*"};
        int i = 1;
        while (i <= 64) {
            System.out.println(String.valueOf(set.length) + "^" + i);
            beg = System.currentTimeMillis();
            BigInteger bis = BigInteger.ONE;
            BigInteger cardinality = new BigInteger("" + set.length);
            int j = 0;
            while (j < i) {
                bis = bis.multiply(cardinality);
                ++j;
            }
            BigInteger bi = BigInteger.ZERO;
            while (bi.compareTo(bis) < 0) {
                bi = bi.add(BigInteger.ONE);
            }
            end = System.currentTimeMillis();
            System.out.println("for " + (double)(end - beg) * 0.001 + "s");
            ++i;
        }
        i = 10;
        while (i <= 64) {
            System.out.println(i);
            beg = System.currentTimeMillis();
            double size = Math.pow(set.length, i);
            int j = 0;
            while ((double)j < size) {
                ++j;
            }
            end = System.currentTimeMillis();
            System.out.println("for " + (double)(end - beg) * 0.001 + "s");
            beg = System.currentTimeMillis();
            KmerIterator ki = new KmerIterator(set, i);
            while (ki.hasNext()) {
                String string = ki.next();
            }
            end = System.currentTimeMillis();
            System.out.println("iterator " + (double)(end - beg) * 0.001 + "s");
            beg = System.currentTimeMillis();
            end = System.currentTimeMillis();
            System.out.println("method " + (double)(end - beg) * 0.001 + "s");
            ++i;
        }
    }
}

