/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lbj.BranchAnalysis;
import lbj.BranchRelationship;
import lbj.Species;

public class CopyOfBranchTag {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int MISSING = 2;
    private List<Integer> id;
    private boolean isLeaf;
    private boolean isRoot;
    private int hashCode;
    private int tagLength;
    private int hashLength;
    private byte[] hashArray;

    private CopyOfBranchTag() {
    }

    public CopyOfBranchTag(int size, List<Integer> speciesOnRight, List<Integer> speciesMissing) {
        this.id = this.produceIdFromIndexedList(size, speciesOnRight, speciesMissing);
        this.calcHashCode();
    }

    public CopyOfBranchTag getCopy(boolean side) {
        CopyOfBranchTag copy;
        block19: {
            copy = new CopyOfBranchTag();
            copy.id = new ArrayList<Integer>(this.id.size());
            copy.isLeaf = this.isLeaf;
            copy.isRoot = this.isRoot;
            copy.hashCode = this.hashCode;
            int index = 0;
            while (index < this.id.size() && this.id.get(index) == 2) {
                copy.id.add(2);
                ++index;
            }
            if (index >= this.id.size()) break block19;
            if (!side) {
                if (this.id.get(index) == 0) {
                    int i = index;
                    while (i < this.id.size()) {
                        copy.id.add(this.id.get(i));
                        ++i;
                    }
                } else {
                    int i = index;
                    while (i < this.id.size()) {
                        if (this.id.get(i) == 0) {
                            copy.id.add(1);
                        } else if (this.id.get(i) == 1) {
                            copy.id.add(0);
                        } else {
                            copy.id.add(this.id.get(i));
                        }
                        ++i;
                    }
                }
            } else if (this.id.get(index) == 1) {
                int i = index;
                while (i < this.id.size()) {
                    copy.id.add(this.id.get(i));
                    ++i;
                }
            } else {
                int i = index;
                while (i < this.id.size()) {
                    if (this.id.get(i) == 0) {
                        copy.id.add(1);
                    } else if (this.id.get(i) == 1) {
                        copy.id.add(0);
                    } else {
                        copy.id.add(this.id.get(i));
                    }
                    ++i;
                }
            }
        }
        return copy;
    }

    public CopyOfBranchTag getCopy(int outgroupIndex) {
        CopyOfBranchTag copy = new CopyOfBranchTag();
        copy.id = new ArrayList<Integer>(this.id.size());
        copy.isLeaf = this.isLeaf;
        copy.isRoot = this.isRoot;
        copy.hashCode = this.hashCode;
        if (this.isRoot) {
            int i = 0;
            while (i < this.id.size()) {
                copy.id.add(this.id.get(i));
                ++i;
            }
        } else if (this.id.get(outgroupIndex) == 0) {
            int i = 0;
            while (i < this.id.size()) {
                copy.id.add(this.id.get(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.id.size()) {
                if (this.id.get(i) == 0) {
                    copy.id.add(1);
                } else if (this.id.get(i) == 1) {
                    copy.id.add(0);
                } else {
                    copy.id.add(this.id.get(i));
                }
                ++i;
            }
        }
        return copy;
    }

    private List<Integer> produceIdFromIndexedList(int size, List<Integer> speciesOnRight, List<Integer> speciesMissing) {
        int index;
        List<Integer> id = Arrays.asList(new Integer[size]);
        this.isRoot = speciesOnRight.isEmpty() || size == speciesOnRight.size();
        this.isLeaf = speciesOnRight.size() == 1 || size - speciesOnRight.size() == 1;
        int i = 0;
        while (i < size) {
            id.set(i, 0);
            ++i;
        }
        if (speciesOnRight != null) {
            i = 0;
            while (i < speciesOnRight.size()) {
                index = speciesOnRight.get(i);
                id.set(index, 1);
                ++i;
            }
        }
        if (speciesMissing != null) {
            i = 0;
            while (i < speciesMissing.size()) {
                index = speciesMissing.get(i);
                id.set(index, 2);
                ++i;
            }
        }
        return id;
    }

    public List<Integer> getId() {
        return Collections.unmodifiableList(this.id);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public BranchRelationship getRelationshipWith(CopyOfBranchTag other) {
        if (this.id.size() != other.id.size()) {
            return BranchRelationship.IMCOMPATIBLE;
        }
        int LL = 0;
        int RR = 0;
        int LR = 0;
        int RL = 0;
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) == 0) {
                if (other.id.get(i) == 0) {
                    ++LL;
                } else if (other.id.get(i) == 1) {
                    ++LR;
                }
            } else if (this.id.get(i) == 1) {
                if (other.id.get(i) == 0) {
                    ++RL;
                } else if (other.id.get(i) == 1) {
                    ++RR;
                }
            }
            ++i;
        }
        BranchRelationship verdict = BranchRelationship.IMCOMPATIBLE;
        if (RR > 0) {
            if (LR == 0) {
                verdict = BranchRelationship.SUPERSET;
            } else if (RL == 0) {
                verdict = BranchRelationship.SUBSET;
            }
        } else {
            verdict = BranchRelationship.MUTEX;
        }
        return verdict;
    }

    public BranchRelationship getRelationshipWith(CopyOfBranchTag other, int outgroupIndex) {
        if (this.id.size() != other.id.size()) {
            return BranchRelationship.IMCOMPATIBLE;
        }
        if (this.isRoot) {
            return BranchRelationship.SUPERSET;
        }
        if (other.isRoot) {
            return BranchRelationship.SUBSET;
        }
        Integer thisRight = this.id.get(outgroupIndex);
        Integer otherRight = other.id.get(outgroupIndex);
        int LL = 0;
        int RR = 0;
        int LR = 0;
        int RL = 0;
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) == thisRight) {
                if (other.id.get(i) == otherRight) {
                    ++LL;
                } else if (other.id.get(i) != otherRight) {
                    ++LR;
                }
            } else if (this.id.get(i) != thisRight) {
                if (other.id.get(i) == otherRight) {
                    ++RL;
                } else if (other.id.get(i) != otherRight) {
                    ++RR;
                }
            }
            ++i;
        }
        BranchRelationship verdict = BranchRelationship.IMCOMPATIBLE;
        if (RR > 0) {
            if (LR == 0) {
                verdict = BranchRelationship.SUPERSET;
            } else if (RL == 0) {
                verdict = BranchRelationship.SUBSET;
            }
        } else {
            verdict = BranchRelationship.MUTEX;
        }
        return verdict;
    }

    protected Object clone() throws CloneNotSupportedException {
        CopyOfBranchTag branch = new CopyOfBranchTag();
        branch.id = Collections.unmodifiableList(this.id);
        branch.isRoot = this.isRoot;
        branch.isLeaf = this.isLeaf;
        branch.hashCode = this.hashCode;
        return branch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CopyOfBranchTag)) {
            return false;
        }
        CopyOfBranchTag other = (CopyOfBranchTag)obj;
        if (this.id.size() != other.id.size()) {
            return false;
        }
        if (this.id.size() == 0 && other.id.size() == 0) {
            return true;
        }
        int index = 0;
        while (index < this.id.size() && this.id.get(index) == 2 && other.id.get(index) == 2) {
            ++index;
        }
        if (index < this.id.size()) {
            boolean firstXOR = this.id.get(index) != other.id.get(index);
            int i = index;
            while (i < this.id.size()) {
                if (this.id.get(i) == 2 || other.id.get(i) == 2) {
                    if (this.id.get(i) != other.id.get(i)) {
                        return false;
                    }
                } else if (firstXOR != (this.id.get(i) != other.id.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean equalsIgnoreMissing(Object obj) {
        if (!(obj instanceof CopyOfBranchTag)) {
            return false;
        }
        CopyOfBranchTag other = (CopyOfBranchTag)obj;
        if (this.id.size() != other.id.size()) {
            return false;
        }
        if (this.id.size() == 0 && other.id.size() == 0) {
            return true;
        }
        int index = 0;
        while (index < this.id.size() && (this.id.get(index) == 2 || other.id.get(index) == 2)) {
            ++index;
        }
        if (index < this.id.size()) {
            boolean firstXOR = this.id.get(index) != other.id.get(index);
            int i = index + 1;
            while (i < this.id.size()) {
                if (this.id.get(i) != 2 && other.id.get(i) != 2 && firstXOR != (this.id.get(i) != other.id.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean equalsSideSensitive(Object obj) {
        if (!(obj instanceof CopyOfBranchTag)) {
            return false;
        }
        CopyOfBranchTag other = (CopyOfBranchTag)obj;
        if (this.id.size() != other.id.size()) {
            return false;
        }
        if (this.id.size() == 0 && other.id.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.id.size()) {
            if (this.id.get(i) != other.id.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void calcHashCode() {
        this.tagLength = this.id.size();
        this.hashCode = 0;
        if (this.id.isEmpty()) {
            return;
        }
        int length = this.id.size();
        boolean isFirst = true;
        Integer first = 2;
        Iterator<Integer> i = this.id.iterator();
        int idx = 0;
        while (i.hasNext()) {
            int next = i.next();
            int point = -1;
            if (next == 2) {
                point = isFirst ? 1 : 2;
            } else {
                if (isFirst) {
                    isFirst = false;
                    first = next;
                }
                point = first == next ? 0 : 1;
            }
            this.hashCode = 3 * this.hashCode + point;
            ++idx;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.id.toString();
    }

    public String toConsenseString() {
        String string = "";
        int i = 0;
        while (i < this.id.size()) {
            char c = '?';
            c = this.id.get(i) == 1 ? (char)'*' : (this.id.get(i) == 0 ? (char)'.' : '?');
            string = String.valueOf(string) + c;
            ++i;
        }
        return string;
    }

    public static void main(String[] args) {
        Species A = new Species("A");
        Species B = new Species("B");
        Species C = new Species("C");
        Species D = new Species("D");
        Species E = new Species("E");
        ArrayList<Species> speciesList = new ArrayList<Species>();
        speciesList.add(A);
        speciesList.add(B);
        speciesList.add(C);
        speciesList.add(D);
        speciesList.add(E);
        Collections.sort(speciesList, new Comparator<Species>(){

            @Override
            public int compare(Species speciesA, Species speciesB) {
                return speciesA.getName().compareTo(speciesB.getName());
            }
        });
        int i = 0;
        while (i < speciesList.size()) {
            Species species = (Species)speciesList.get(i);
            species.setIndex(i);
            ++i;
        }
        String format = "%" + speciesList.size() + "s";
        ArrayList<Integer> speciesOnRight1 = new ArrayList<Integer>();
        speciesOnRight1.add(0);
        speciesOnRight1.add(1);
        speciesOnRight1.add(2);
        CopyOfBranchTag branch1 = new CopyOfBranchTag(5, speciesOnRight1, null);
        System.out.println(branch1);
        ArrayList<Integer> speciesOnRight2 = new ArrayList<Integer>();
        speciesOnRight2.add(3);
        speciesOnRight2.add(4);
        CopyOfBranchTag branch2 = new CopyOfBranchTag(5, speciesOnRight2, null);
        System.out.println(branch2);
        ArrayList<Integer> speciesOnRight3 = new ArrayList<Integer>();
        speciesOnRight3.add(2);
        speciesOnRight3.add(3);
        speciesOnRight3.add(4);
        CopyOfBranchTag branch3 = new CopyOfBranchTag(5, speciesOnRight3, null);
        System.out.println(branch3);
        ArrayList<Integer> speciesOnRight4 = new ArrayList<Integer>();
        speciesOnRight4.add(0);
        speciesOnRight4.add(1);
        speciesOnRight4.add(2);
        speciesOnRight4.add(3);
        speciesOnRight4.add(4);
        CopyOfBranchTag branch4 = new CopyOfBranchTag(5, speciesOnRight4, null);
        System.out.println(branch4);
        ArrayList<Integer> speciesOnRight5 = new ArrayList<Integer>();
        speciesOnRight5.add(0);
        speciesOnRight5.add(1);
        speciesOnRight5.add(2);
        CopyOfBranchTag branch5 = new CopyOfBranchTag(5, speciesOnRight5, null);
        System.out.println(branch5);
        System.out.println(branch1 == branch2);
        System.out.println(branch1.equals(branch2));
        System.out.println(String.valueOf(branch1.hashCode()) + " vs " + branch2.hashCode());
        System.out.println(branch1 == branch5);
        System.out.println(branch1.equals(branch5));
        System.out.println(String.valueOf(branch1.hashCode()) + " vs " + branch5.hashCode());
        CopyOfBranchTag branch6 = branch1;
        System.out.println(branch1 == branch6);
        System.out.println(branch1.equals(branch6));
        System.out.println(String.valueOf(branch1.hashCode()) + " vs " + branch6.hashCode());
        CopyOfBranchTag branch7 = null;
        try {
            branch7 = (CopyOfBranchTag)branch1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        System.out.println(branch1 == branch7);
        System.out.println(branch1.equals(branch7));
        System.out.println(String.valueOf(branch1.hashCode()) + " vs " + branch7.hashCode());
        Integer i1 = 0;
        Integer i2 = 1;
        System.out.println(i1.hashCode());
        System.out.println(i2.hashCode());
        Boolean b1 = false;
        Boolean b2 = true;
        System.out.println(b1.hashCode());
        System.out.println(b2.hashCode());
        System.out.println();
        int i3 = 0;
        while (i3 <= 4) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            String output = "";
            String[] strings = BranchAnalysis.getAllPossibleKmers(new String[]{".", "*", "?"}, i3);
            int j = 0;
            while (j < strings.length) {
                String string = strings[j];
                ArrayList<Integer> list = new ArrayList<Integer>();
                ArrayList<Integer> missingList = new ArrayList<Integer>();
                int k = 0;
                while (k < i3) {
                    if (string.charAt(k) == '*') {
                        list.add(k);
                    } else if (string.charAt(k) == '?') {
                        missingList.add(k);
                    }
                    ++k;
                }
                CopyOfBranchTag bt = new CopyOfBranchTag(i3, list, missingList);
                int hashCode = bt.hashCode();
                output = String.valueOf(output) + String.format("%-12s | %-12s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode);
                if (j < strings.length - 1) {
                    output = String.valueOf(output) + "\n";
                }
                if (min > hashCode) {
                    min = hashCode;
                }
                if (max < hashCode) {
                    max = hashCode;
                }
                ++j;
            }
            System.out.println("<<<<<<<<<<<< " + i3 + " (" + min + "~" + max + ") " + (max - min + 1));
            System.out.println(output);
            System.out.println(">>>>>>>>>>>> " + i3 + " (" + min + "~" + max + ") " + (max - min + 1));
            ++i3;
        }
        long last = 0L;
        long offset = 0L;
        int i4 = 0;
        while (i4 <= 10) {
            System.out.println("offset (" + i4 + "): " + (offset += last));
            last += (long)((int)Math.pow(3.0, i4));
            ++i4;
        }
        i4 = 0;
        while (i4 < 64) {
            System.out.println(String.valueOf(i4) + " ==============================================");
            ArrayList<Integer> list = new ArrayList<Integer>();
            CopyOfBranchTag bt = new CopyOfBranchTag(i4, list, null);
            int hashCode = bt.hashCode();
            System.out.println(String.format("%-64s | %-32s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode));
            if (i4 != 0) {
                list.add(0);
                bt = new CopyOfBranchTag(i4, list, null);
                hashCode = bt.hashCode();
                System.out.println(String.format("%-64s | %-32s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode));
                list.remove(0);
                int j = 1;
                while (j < i4) {
                    list.add(j);
                    ++j;
                }
                bt = new CopyOfBranchTag(i4, list, null);
                hashCode = bt.hashCode();
                System.out.println(String.format("%-64s | %-32s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode));
                list.add(0);
                bt = new CopyOfBranchTag(i4, list, null);
                hashCode = bt.hashCode();
                System.out.println(String.format("%-64s | %-32s | %4d", bt.toConsenseString(), Integer.toBinaryString(hashCode).replace(" ", "0"), hashCode));
            }
            ++i4;
        }
        CopyOfBranchTag LLRRR = new CopyOfBranchTag(5, Arrays.asList(2, 3, 4), null);
        CopyOfBranchTag LLLRR = new CopyOfBranchTag(5, Arrays.asList(3, 4), null);
        CopyOfBranchTag RRLLL = new CopyOfBranchTag(5, Arrays.asList(0, 1), null);
        CopyOfBranchTag RRRLL = new CopyOfBranchTag(5, Arrays.asList(0, 1, 2), null);
        List<CopyOfBranchTag> tags = Arrays.asList(LLRRR, LLLRR, RRLLL, RRRLL);
        int i5 = 0;
        while (i5 < 5) {
            int j = 0;
            while (j < 4) {
                System.out.println(String.valueOf("    ".substring(0, i5)) + "V");
                System.out.println(String.valueOf(tags.get(j).toConsenseString()) + "\n------------------------");
                int k = 0;
                while (k < 4) {
                    System.out.println(String.valueOf(tags.get(k).toConsenseString()) + "    " + (Object)((Object)tags.get(j).getRelationshipWith(tags.get(k), i5)));
                    ++k;
                }
                ++j;
            }
            ++i5;
        }
    }
}

