/*
 * Decompiled with CFR 0.152.
 */
package lbj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lbj.BranchRelationship;
import lbj.Species;

public class BranchScore {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int MISSING = 2;
    private List<Species> speciesList;
    private List<Boolean> id;
    private int[] species;
    private String speciesString = "";
    private int numRights = 0;
    private double score = 0.0;

    public BranchScore(int size) {
        this.species = new int[size];
    }

    public BranchScore(List<Species> speciesList, List<Integer> speciesOnRight) {
        this.speciesList = speciesList;
        this.id = Collections.unmodifiableList(BranchScore.produceIdFromIndexedList(speciesList.size(), speciesOnRight));
    }

    public List<Species> getSpeciesList() {
        return this.speciesList;
    }

    public static List<Boolean> produceIdFromIndexedList(int numOfSpecies, List<Integer> speciesOnRight) {
        List<Boolean> id;
        block5: {
            block4: {
                id = Arrays.asList(new Boolean[numOfSpecies]);
                if (!speciesOnRight.isEmpty() && numOfSpecies != speciesOnRight.size()) break block4;
                int i = 0;
                while (i < numOfSpecies) {
                    id.set(i, true);
                    ++i;
                }
                break block5;
            }
            int i = 0;
            while (i < numOfSpecies) {
                id.set(i, false);
                ++i;
            }
            i = 0;
            while (i < speciesOnRight.size()) {
                int index = speciesOnRight.get(i);
                id.set(index, true);
                ++i;
            }
            if (!id.get(0).booleanValue()) break block5;
            i = 0;
            while (i < numOfSpecies) {
                id.set(i, id.get(i) == false);
                ++i;
            }
        }
        return id;
    }

    public String idToString() {
        return "";
    }

    public static String idToString(int i) {
        return "";
    }

    public List<Boolean> getId() {
        return this.id;
    }

    public int[] getSpecies() {
        return this.species;
    }

    public double getScore() {
        return this.score;
    }

    public void addPoints(double points) {
        this.score += points;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getSpeciesString() {
        return this.speciesString;
    }

    public int getNumRights() {
        return this.numRights;
    }

    public void setSpeciesString() {
        this.speciesString = "";
        this.numRights = 0;
        boolean isFirst = true;
        int leftChar = 32;
        char rightChar = ' ';
        int i = 0;
        while (i < this.species.length) {
            if (this.species[i] == 0) {
                if (isFirst) {
                    isFirst = false;
                    leftChar = 46;
                    rightChar = '*';
                }
                this.speciesString = String.valueOf(this.speciesString) + (char)leftChar;
            } else if (this.species[i] == 1) {
                if (isFirst) {
                    isFirst = false;
                    leftChar = 42;
                    rightChar = '.';
                }
                this.speciesString = String.valueOf(this.speciesString) + rightChar;
                ++this.numRights;
            } else if (this.species[i] == 2) {
                this.speciesString = String.valueOf(this.speciesString) + "?";
            }
            if (this.numRights == this.species.length) {
                this.speciesString = this.speciesString.replaceAll(".", "*");
            }
            ++i;
        }
    }

    public BranchRelationship getRelationshipWith(BranchScore other) {
        if (this.speciesString.length() != other.speciesString.length()) {
            return BranchRelationship.IMCOMPATIBLE;
        }
        int LL = 0;
        int RR = 0;
        int LR = 0;
        int RL = 0;
        int i = 0;
        while (i < this.speciesString.length()) {
            if (this.speciesString.charAt(i) == '.') {
                if (other.speciesString.charAt(i) == '.') {
                    ++LL;
                } else if (other.speciesString.charAt(i) == '*') {
                    ++LR;
                }
            } else if (this.speciesString.charAt(i) == '*') {
                if (other.speciesString.charAt(i) == '.') {
                    ++RL;
                } else if (other.speciesString.charAt(i) == '*') {
                    ++RR;
                }
            }
            ++i;
        }
        BranchRelationship verdict = BranchRelationship.IMCOMPATIBLE;
        if (RR > 0) {
            if (LR == 0) {
                verdict = BranchRelationship.SUPERSET;
            } else if (RL == 0) {
                verdict = BranchRelationship.SUBSET;
            }
        } else {
            verdict = BranchRelationship.MUTEX;
        }
        System.out.println("------------- " + (Object)((Object)verdict));
        System.out.println(String.valueOf(this.speciesString) + "    " + this.score);
        System.out.println(String.valueOf(other.speciesString) + "    " + other.score);
        return verdict;
    }

    public static void main(String[] args) {
        Species A = new Species("A");
        Species B = new Species("B");
        Species C = new Species("C");
        Species D = new Species("D");
        Species E = new Species("E");
        ArrayList<Species> speciesList = new ArrayList<Species>();
        speciesList.add(A);
        speciesList.add(B);
        speciesList.add(C);
        speciesList.add(D);
        speciesList.add(E);
        Collections.sort(speciesList, new Comparator<Species>(){

            @Override
            public int compare(Species speciesA, Species speciesB) {
                return speciesA.getName().compareTo(speciesB.getName());
            }
        });
        int i = 0;
        while (i < speciesList.size()) {
            Species species = (Species)speciesList.get(i);
            species.setIndex(i);
            ++i;
        }
        String format = "%" + speciesList.size() + "s";
        ArrayList<Integer> speciesOnRight1 = new ArrayList<Integer>();
        speciesOnRight1.add(0);
        speciesOnRight1.add(1);
        speciesOnRight1.add(2);
        BranchScore branch1 = new BranchScore(speciesList, speciesOnRight1);
        System.out.println(branch1.getId());
        ArrayList<Integer> speciesOnRight2 = new ArrayList<Integer>();
        speciesOnRight2.add(3);
        speciesOnRight2.add(4);
        BranchScore branch2 = new BranchScore(speciesList, speciesOnRight2);
        System.out.println(branch2.getId());
        ArrayList<Integer> speciesOnRight3 = new ArrayList<Integer>();
        speciesOnRight3.add(2);
        speciesOnRight3.add(3);
        speciesOnRight3.add(4);
        BranchScore branch3 = new BranchScore(speciesList, speciesOnRight3);
        System.out.println(branch3.getId());
        ArrayList<Integer> speciesOnRight4 = new ArrayList<Integer>();
        speciesOnRight4.add(0);
        speciesOnRight4.add(1);
        speciesOnRight4.add(2);
        speciesOnRight4.add(3);
        speciesOnRight4.add(4);
        BranchScore branch4 = new BranchScore(speciesList, speciesOnRight4);
        System.out.println(branch4.getId());
        System.out.println(branch1.getId().equals(branch2.getId()));
        System.out.println(branch1.getId().equals(branch3.getId()));
        System.out.println(branch1.getId().hashCode());
        System.out.println(branch2.getId().hashCode());
        System.out.println(branch3.getId().hashCode());
        branch1.getId().set(0, true);
        long l1 = 0x3FFFFFFFFFFFFFFFL;
        long l2 = Long.MAX_VALUE;
        long l3 = l1 ^ l2;
        format = "%64s";
        System.out.println(String.format(format, Long.toBinaryString(l1)).replace(' ', '0'));
        System.out.println(String.format(format, Long.toBinaryString(l2)).replace(' ', '0'));
        System.out.println(String.format(format, Long.toBinaryString(l3)).replace(' ', '0'));
    }
}

