/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import leb.process.enumclass.AlignMode;
import leb.util.StreamGobbler;
import leb.uucgp.ProcessGobbler;

public class MafftForGeneSet {
    AlignMode alignMode;
    String ProgramPath;
    private List<String> arguments = new ArrayList<String>();

    public MafftForGeneSet(String programPath, AlignMode alignMode) {
        this.alignMode = alignMode;
        this.ProgramPath = programPath;
        this.arguments.add("bash");
        this.arguments.add("-c");
    }

    public void setInputOutput(String input, String output) {
        this.arguments.add(String.valueOf(this.ProgramPath) + " --thread 1 " + input + " > " + output);
    }

    public ProcessGobbler execute() throws IOException, InterruptedException {
        Process mafft = new ProcessBuilder(this.arguments).start();
        StreamGobbler stdOut = new StreamGobbler(mafft.getInputStream(), null, false);
        StreamGobbler stdError = new StreamGobbler(mafft.getErrorStream(), null, false);
        stdOut.start();
        stdError.start();
        mafft.waitFor();
        int exitValue = mafft.exitValue();
        ProcessGobbler processGobbler = new ProcessGobbler(exitValue, stdError.LogMessage());
        return processGobbler;
    }
}

