/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import java.io.BufferedReader;
import leb.util.exec.GeneralExecInfo;
import leb.util.exec.SimpleExecTemplate;

public class HmmSearchWrapper
extends SimpleExecTemplate
implements GeneralExecInfo {
    private String hmmFileName;
    private String seqFileName;
    private String outFileName = null;

    public HmmSearchWrapper(String hmmSearchPath) {
        super(hmmSearchPath);
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("-o", outFileName);
        this.outFileName = outFileName;
    }

    public void setAlignOutFileName(String alignOutFileName) {
        this.addArgument("-A", alignOutFileName);
    }

    public void setNoAlignment() {
        this.addArgument("--noali");
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("--cpu", noCore);
    }

    public void setEvalue(double evalue) {
        this.addArgument("-E", evalue);
    }

    public void setDomainEvalue(double evalue) {
        this.addArgument("--domE", evalue);
    }

    public void setTructedCutoff() {
        this.addArgument("--cut_tc");
    }

    public void setScore(double score) {
        this.addArgument("-T", score);
    }

    public void setDomainScore(double score) {
        this.addArgument("--domT", score);
    }

    public void setSignificantEvalue(double evalue) {
        this.addArgument("--incE", evalue);
    }

    public void setSignificantDomainEvalue(double evalue) {
        this.addArgument("--incdomE", evalue);
    }

    public void setSignificantScore(double score) {
        this.addArgument("--incT", score);
    }

    public void setSignificantDomainScore(double score) {
        this.addArgument("--incdomT", score);
    }

    public void setCutGa() {
        this.addArgument("--cut_ga");
    }

    public void setCutNc() {
        this.addArgument("--cut_nc");
    }

    public void setCutTc() {
        this.addArgument("--cut_tc");
    }

    public void setTurnOffBiasFilter() {
        this.addArgument("--nobias");
    }

    public void setTblOut(String tblOutFile) {
        this.addArgument("--tblout", tblOutFile);
    }

    public String getHmmFileName() {
        return this.hmmFileName;
    }

    public void setHmmFileName(String hmmFileName) {
        this.hmmFileName = hmmFileName;
    }

    public void setTrustedCutoff() {
        this.addArgument("--cut_tc");
    }

    public String getSeqFileName() {
        return this.seqFileName;
    }

    public void setSeqFileName(String seqFileName) {
        this.seqFileName = seqFileName;
    }

    @Override
    public boolean execute() {
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        return super.execute();
    }

    @Override
    public void executeWithStdOut() {
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        super.executeWithStdOut();
    }

    @Override
    public BufferedReader executeToBufferedReader() {
        this.addArgument(this.hmmFileName);
        this.addArgument(this.seqFileName);
        return super.executeToBufferedReader();
    }

    @Override
    public String getVersion() {
        return "3.1b1";
    }
}

