/*
 * Decompiled with CFR 0.152.
 */
package leb.uucgp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import leb.util.cli.Arguments;
import leb.uucgp.ProcFindUucgpByGenome;

public class ProcUucgP {
    final String version = "2.0 [Feb, 2021]";
    String[] parameters = null;
    List<String> paramsList = null;
    HashMap<String, String> programPath = null;
    final String[] validatedOptions = new String[]{"-h", "--help", "-ucg_dir", "-i", "-hmm", "-n", "-t", "-p", "-label", "-g", "-taxon_name", "-strain_name", "-strain_property", "-taxonomy", "-type", "-acc", "-uid", "-targ_taxon", "-ncbi_name"};

    private void extract() {
        ProcFindUucgpByGenome upcg = new ProcFindUucgpByGenome(this.parameters, this.programPath);
        upcg.findUpcgSingleGenome("2.0 [Feb, 2021]");
    }

    private void validateParameters() {
        List<String> optionList = Arrays.asList(this.validatedOptions);
        String[] stringArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.startsWith("-") && !optionList.contains(param)) {
                System.err.println("Error!");
                System.err.println("Invalid option " + param);
                System.err.println("Exit!");
                System.exit(1);
            }
            ++n2;
        }
        if (this.paramsList.contains("-h") || this.paramsList.contains("--help")) {
            this.printHelpMessage();
            System.exit(0);
        }
        if (!this.paramsList.contains("-i") && !this.paramsList.contains("-p")) {
            System.err.println("Input file is not entered. Enter -i or -p options.");
            System.err.println("Exit");
            System.exit(1);
        }
        Arguments arg = new Arguments(this.parameters);
        if (this.paramsList.contains("-uid")) {
            try {
                Long.parseLong(arg.get("-uid"));
            }
            catch (NumberFormatException e) {
                System.err.println("Error : uid must be an integer.");
                System.err.println("Exit!");
                System.exit(1);
            }
        }
        this.notContain("-ucg_dir");
        this.notContain("-label");
        this.notContain("-hmm");
    }

    private void notContain(String param) {
        if (!this.paramsList.contains(param)) {
            System.err.println("Enter " + param + " option.");
            System.err.println("Exit");
            System.exit(1);
        }
    }

    private void printHelpMessage() {
        System.out.println("     -------------------------------");
        System.out.println("       UBCG ver2.0 [Feb, 2021]");
        System.out.println("     -------------------------------");
        System.out.println();
        System.out.println("This is a part of pipeline for prokaryotic phylogenomics using core gene sequences.");
        System.out.println("The core gene sets are pre-defined using complete genome sequences.");
        System.out.println("The UBCG finds the core genes from a contig file or a CDS (coding sequences) file.");
        System.out.println("If you want more information, please visit www.leb.snu.ac.kr/ubcg2");
        System.out.println();
        System.out.println("The external programs that are used in the UBCG2 should be installed.");
        System.out.println("Paths of the programs must be written in the 'programPath' file.");
        System.out.println();
        System.out.println("Basic options");
        System.out.println("-h : show usage and options (--help)");
        System.out.println();
        System.out.println("ex) java -jar UBCG2.jar -i fasta/contigs.fasta -ucg_dir path -label e.coli -hmm hmm/ubcg_v2.hmm");
        System.out.println("    Extracting the gene sequences, which are included in ubcg_v2.hmm profile, from a contig file and save as an ucg file in the designated path.");
        System.out.println("ex) java -jar UBCG2.jar -p cds_protein.fasta -ucg_dir path -label e.coli -hmm hmm/ubcg_v2.hmm");
        System.out.println("    Extracting gene sequences from a protein CDS file. Only protein sequences are extracted.");
        System.out.println("ex) java -jar UBCG2.jar -p cds_protein.fasta -n cds_dna.fasta -ucg_dir path -label e.coli -hmm hmm/uacg.hmm");
        System.out.println("    Extracting the gene sequences (gene set in uacg.hmm) from nucleotide/protein CDS files. In this case, the target genome is an archaea.");
        System.out.println();
        System.out.println("Mandatory");
        System.out.println("    -i          <String> : contig file (fasta format)");
        System.out.println("    -p          <String> : CDS protein file (fasta format; -i or this option must be entered)");
        System.out.println("    -n          <String> : CDS nucleotide file (this is optional)");
        System.out.println("    -ucg_dir    <String> : directory to save a ucg file");
        System.out.println("    -label      <String> : label of the genome sequence");
        System.out.println("    -hmm        <String> : profile hmm for the core gene set (ubcg.hmm for bacteria, uacg.hmm for archaea)");
        System.out.println();
        System.out.println("Optional");
        System.out.println("    -g          <Integer>: translation table for translation (-g parameter in Prodigal)");
        System.out.println("                           use this option when you use other genetic code");
        System.out.println("                           most bacterial species use the 11 table");
        System.out.println("                           (Default : 11, the bacterial and archaeal code)");
        System.out.println("    -t          <Integer>: use multi-threads");
        System.out.println("                           (Default : 1)");
        System.out.println();
        System.out.println("Metadata of genome (optional)");
        System.out.println("    -taxon_name <String> : name of species");
        System.out.println("    -strain_name<String> : name of strain");
        System.out.println("    -type                : add this option if the strain is a type strain of species or subspecies");
        System.out.println("    -acc        <String> : accession of genome sequence. NCBI assembly accession is usually used for public data");
        System.out.println("    -uid        <Integer>: unique id. If it is not designated, automatically generated");
        System.out.println("    -taxonomy   <String> : taxonomy of the species");
        System.out.println("    -targ_taxon <String> : target taxon");
        System.out.println();
    }

    private void getProgramPath() {
        String prodigalPath = null;
        String hmmsearchPath = null;
        String mafftPath = null;
        String fasttreePath = null;
        String raxmlPath = null;
        this.programPath = new HashMap();
        try {
            String line;
            File jar = new File(ClassLoader.getSystemClassLoader().getResource(".").toURI().getPath());
            String jarDir = String.valueOf(jar.getParent()) + File.separator;
            BufferedReader pathBR = new BufferedReader(new FileReader(String.valueOf(jarDir) + "programPath"));
            while ((line = pathBR.readLine()) != null) {
                if (line.startsWith("prodigal=")) {
                    prodigalPath = line.substring(line.indexOf("=") + 1);
                    this.programPath.put("prodigal", prodigalPath);
                    continue;
                }
                if (line.startsWith("hmmsearch=")) {
                    hmmsearchPath = line.substring(line.indexOf("=") + 1);
                    this.programPath.put("hmmsearch", hmmsearchPath);
                    continue;
                }
                if (line.startsWith("mafft=")) {
                    mafftPath = line.substring(line.indexOf("=") + 1);
                    this.programPath.put("mafft", mafftPath);
                    continue;
                }
                if (line.startsWith("fasttree=")) {
                    fasttreePath = line.substring(line.indexOf("=") + 1);
                    this.programPath.put("fasttree", fasttreePath);
                    continue;
                }
                if (!line.startsWith("raxml")) continue;
                raxmlPath = line.substring(line.indexOf("=") + 1);
                this.programPath.put("raxml", raxmlPath);
            }
            pathBR.close();
            if (prodigalPath == null || hmmsearchPath == null || mafftPath == null || fasttreePath == null || raxmlPath == null) {
                System.err.println("Error : The external program path is not properly set. Check the path file.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println("Error occurred!");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (URISyntaxException ex) {
            System.err.println("Error occurred!");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        ProcUucgP proc = new ProcUucgP();
        proc.parameters = args;
        proc.paramsList = Arrays.asList(args);
        proc.validateParameters();
        proc.getProgramPath();
        proc.extract();
    }
}

