/*
 * Decompiled with CFR 0.152.
 */
package leb.domain;

import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class DetectedGeneDomain
implements Serializable {
    private static final long serialVersionUID = 830018460048146372L;
    private static final String[] keyList = new String[]{"protein", "dna", "evalue", "bitscore"};
    private String geneName = null;
    private double eValue = 0.0;
    private double bitScore = 0.0;
    private String dna = null;
    private String protein = null;

    public DetectedGeneDomain() {
    }

    public DetectedGeneDomain(JSONObject jsonObject) {
        try {
            String key = null;
            Iterator<String> iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                switch (key = iterator.next()) {
                    case "protein": {
                        this.protein = (String)jsonObject.get(key);
                        break;
                    }
                    case "dna": {
                        this.dna = (String)jsonObject.get(key);
                        break;
                    }
                    case "evalue": {
                        this.eValue = (Double)jsonObject.get(key);
                        break;
                    }
                    case "bitscore": {
                        Object ob = jsonObject.get(key);
                        this.bitScore = ob instanceof Integer ? ((Integer)ob).doubleValue() : ((Double)ob).doubleValue();
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public double geteValue() {
        return this.eValue;
    }

    public void seteValue(double eValue) {
        this.eValue = eValue;
    }

    public double getBitScore() {
        return this.bitScore;
    }

    public void setBitScore(double bitScore) {
        this.bitScore = bitScore;
    }

    public String getDna() {
        return this.dna;
    }

    public void setDna(String dna) {
        this.dna = dna;
    }

    public String getProtein() {
        return this.protein;
    }

    public void setProtein(String protein) {
        this.protein = protein;
    }

    public JSONObject toJsonObject() {
        JSONObject detectedGeneJO = new JSONObject();
        try {
            detectedGeneJO.put("protein", this.protein);
            detectedGeneJO.put("dna", this.dna);
            detectedGeneJO.put("eValue", this.eValue);
            detectedGeneJO.put("bitscore", this.bitScore);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return detectedGeneJO;
    }
}

