/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import leb.util.common.ExecHandler;

public class MMSeqs2Wrapper
extends ExecHandler {
    private static String PATH = "mmseqs";
    private Integer threads = 72;
    private Integer alignmentMode = 2;

    public static void setMmseqsPath(String mmseqsPath) {
        PATH = mmseqsPath;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public void setAlignmentMode(Integer alignmentMode) {
        this.alignmentMode = alignmentMode;
    }

    public MMSeqs2Wrapper() {
        this.init(PATH);
    }

    public void runCreateDb(String inFileName, String outDbName) {
        this.addArgument("createdb");
        this.addArgument(inFileName);
        this.addArgument(outDbName);
        super.exec();
    }

    public void runSearch(String queryDbName, String targetDbName, String outAlignName, String tmpDir) {
        this.addArgument("search");
        this.addArgument(queryDbName);
        this.addArgument(targetDbName);
        this.addArgument(outAlignName);
        this.addArgument(tmpDir);
        this.addArgument("--alignment-mode", this.alignmentMode);
        this.addArgument("--threads", this.threads);
        super.exec();
    }

    public void runFilterdb(String inDbName, String outDbName, String ignoredTmpDir) {
        this.addArgument("filterdb");
        this.addArgument(inDbName);
        this.addArgument(outDbName);
        this.addArgument("--extract-lines", 1);
        this.addArgument("--threads", this.threads);
        super.exec();
    }

    public void runConvertAlis(String inDbName1, String inDbName2, String inAlignName, String outFileName) {
        this.addArgument("convertalis");
        this.addArgument(inDbName1);
        this.addArgument(inDbName2);
        this.addArgument(inAlignName);
        this.addArgument(outFileName);
        this.addArgument("--threads", this.threads);
        super.exec();
    }

    public void runConvert2Fasta(String inDbName, String outFileName) {
        this.addArgument("convert2fasta");
        this.addArgument(inDbName);
        this.addArgument(outFileName);
        super.exec();
    }
}

