/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import leb.util.common.ExecHandler;

public class DiamondWrapper
extends ExecHandler {
    public static int MAKEDB = -1;
    public static int BLASTX = 0;
    public static int BLASTP = 1;

    public DiamondWrapper(String diamondPath, int type) {
        super.init(diamondPath);
        if (type == MAKEDB) {
            this.addArgument("makedb");
        } else if (type == BLASTX) {
            this.addArgument("blastx");
        } else if (type == BLASTP) {
            this.addArgument("blastp");
        }
    }

    public void setQueryFileName(String queryFileName) {
        this.addArgument("--query", queryFileName);
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("--out", outFileName);
    }

    public void setInputFastaForDb(String inFileName) {
        this.addArgument("--in", inFileName);
    }

    public void setDbFile(String dbFileName) {
        this.addArgument("--db", dbFileName);
    }

    public void setEvalue(double evalue) {
        this.addArgument("--evalue", evalue);
    }

    public void setThreads(int threads) {
        this.addArgument("--threads", threads);
    }

    public void setNoHits(int hits) {
        this.addArgument("--max-target-seqs", hits);
    }

    public void setSensitive() {
        this.addArgument("--sensitive");
    }

    public void setIdentity(double identity) {
        this.addArgument("--id", identity);
    }

    public void setQueryCover(double queryCover) {
        this.addArgument("--query-cover", queryCover);
    }

    public void run() {
        super.exec();
    }
}

