/*
 * Decompiled with CFR 0.152.
 */
package leb.wrapper;

import leb.util.common.ExecHandler;

public class BlastPlusWrapper
extends ExecHandler {
    public static final int OUTPUT_TAB = 6;
    public static final int OUTPUT_SIMPLE = 7;
    public static final int OUTPUT_TEXT = 0;

    public BlastPlusWrapper(String path) {
        super.init(path);
    }

    public void setOutFmt(int outputFmt) {
        switch (outputFmt) {
            case 0: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setAlignedView(outputFmt);
    }

    public void setProgramPath(String path) {
        super.init(path);
    }

    public void setInFileName(String inFileName) {
        this.addArgument("-query", inFileName);
    }

    public void setDbFileName(String dbFileName) {
        this.addArgument("-db", dbFileName);
    }

    public void setOutFileName(String outFileName) {
        this.addArgument("-out", outFileName);
    }

    public void setFilterEvalue(double filterEvalue) {
        this.addArgument("-evalue", filterEvalue);
    }

    private void setAlignedView(int alignedView) {
        this.addArgument("-outfmt", alignedView);
    }

    public void setMaxTargetSequence(int maxTarget) {
        this.addArgument("-max_target_seqs", maxTarget);
    }

    public void setCoreForMultiThread(int noCore) {
        this.addArgument("-num_threads", noCore);
    }

    public void run() {
        super.exec();
    }
}

