/*
 * Decompiled with CFR 0.152.
 */
package leb.util.seq;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import leb.util.seq.DnaSeqDomain;
import leb.util.seq.FastSeqType;
import org.apache.commons.io.IOUtils;

public class FastSeqLoader {
    private BufferedReader br = null;
    private String line = null;
    private FastSeqType fastSeqType = null;
    private Integer minLen;
    private Integer maxLen;
    private boolean hasNextSeq = false;
    private final boolean ignoreEmptySeq = false;

    public static List<DnaSeqDomain> importFileToDomainList(String fileName) {
        ArrayList<DnaSeqDomain> list = new ArrayList<DnaSeqDomain>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            list.add(domain);
        }
        try {
            fsl.br.ready();
            fsl.br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public void loadSeqFile(File file) {
        block6: {
            this.hasNextSeq = true;
            this.minLen = Integer.MAX_VALUE;
            this.maxLen = Integer.MIN_VALUE;
            try {
                this.br = new BufferedReader(new FileReader(file));
                String firstLine = null;
                while ((this.line = this.br.readLine()) != null) {
                    if (this.line.trim().length() == 0) continue;
                    firstLine = this.line;
                    break;
                }
                if (firstLine == null) {
                    this.fastSeqType = null;
                    throw new NullPointerException();
                }
                if (firstLine.startsWith("@")) {
                    this.fastSeqType = FastSeqType.FASTQ;
                    break block6;
                }
                if (firstLine.startsWith(">")) {
                    this.fastSeqType = FastSeqType.FASTA;
                    break block6;
                }
                this.fastSeqType = null;
                throw new NullPointerException();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSeqFile(String fileName) {
        this.loadSeqFile(new File(fileName));
    }

    public boolean hasNextSeq() {
        if (this.hasNextSeq) {
            try {
                this.br.mark(100000000);
                if (this.br.readLine() != null) {
                    this.br.reset();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.hasNextSeq;
    }

    public DnaSeqDomain nextSeq() {
        DnaSeqDomain domain;
        if (this.fastSeqType == FastSeqType.FASTA) {
            domain = this.nextFastaSeq();
        } else if (this.fastSeqType == FastSeqType.FASTQ) {
            domain = this.nextFastqSeq();
        } else {
            this.hasNextSeq = false;
            return null;
        }
        if (domain == null) {
            this.hasNextSeq = false;
        }
        return domain;
    }

    private DnaSeqDomain nextFastaSeq() {
        StringBuilder sbSeq = new StringBuilder();
        DnaSeqDomain domain = new DnaSeqDomain();
        if (this.line == null) {
            IOUtils.closeQuietly(this.br);
            return null;
        }
        if (!this.line.startsWith(">")) {
            throw new NullPointerException();
        }
        String title = this.line.substring(1);
        try {
            while ((this.line = this.br.readLine()) != null && !this.line.startsWith(">")) {
                sbSeq.append(this.line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String seq = sbSeq.toString();
        if (seq.length() == 0) {
            throw new NullPointerException("Empty Sequence with title : " + title);
        }
        domain.setTitle(title);
        domain.setSequence(seq);
        this.setVariables(domain);
        return domain;
    }

    private DnaSeqDomain nextFastqSeq() {
        StringBuilder sbSeq = new StringBuilder();
        StringBuilder sbQual = new StringBuilder();
        DnaSeqDomain domain = new DnaSeqDomain();
        if (this.line == null) {
            IOUtils.closeQuietly(this.br);
            return null;
        }
        if (!this.line.startsWith("@")) {
            throw new NullPointerException();
        }
        String title = this.line.substring(1);
        try {
            while (!(this.line = this.br.readLine()).startsWith("+")) {
                sbSeq.append(this.line.trim());
            }
            while (sbQual.length() != sbSeq.length()) {
                this.line = this.br.readLine();
                sbQual.append(this.line.trim());
                if (sbQual.length() <= sbSeq.length()) continue;
                throw new NullPointerException();
            }
            while (!((this.line = this.br.readLine()) == null || this.line.trim().length() != 0 && this.line.startsWith("@"))) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String seq = sbSeq.toString();
        String qual = sbQual.toString();
        if (seq.length() == 0 || qual.length() == 0) {
            throw new NullPointerException("Empty Sequence with title : " + title);
        }
        domain.setTitle(title);
        domain.setSequence(seq);
        this.setVariables(domain);
        return domain;
    }

    private void setVariables(DnaSeqDomain domain) {
        if (this.minLen > domain.getSequence().length()) {
            this.minLen = domain.getSequence().length();
        }
        if (this.maxLen < domain.getSequence().length()) {
            this.maxLen = domain.getSequence().length();
        }
    }
}

