/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeKeeper {
    private static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MM-dd HH:mm:ss");

    private String convert(long time) {
        if (time < 1000L) {
            return "< 1s";
        }
        String tstr = "";
        tstr = (time /= 1000L) % 60L + "s " + tstr;
        if (time < 60L) {
            return tstr;
        }
        tstr = (time /= 60L) % 60L + "m " + tstr;
        if (time < 60L) {
            return tstr;
        }
        tstr = (time /= 60L) % 24L + "h " + tstr;
        if (time < 24L) {
            return tstr;
        }
        tstr = (time /= 24L) % 30L + "d " + tstr;
        if (time < 30L) {
            return tstr;
        }
        tstr = (time /= 30L) % 12L + "m " + tstr;
        if (time < 12L) {
            return tstr;
        }
        return (time /= 12L) + "y " + tstr;
    }

    public static String format(long time) {
        return new TimeKeeper().convert(time);
    }

    public static String timeStamp() {
        String sdf = SDF.format(Calendar.getInstance().getTime());
        return MONTHS[Integer.parseInt(sdf.substring(0, 2)) - 1] + " " + sdf.substring(3);
    }
}

