/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import leb.util.common.ANSIHandler;
import leb.util.common.Prompt;

public class Shell {
    private ProcessBuilder processBuilder = null;
    private Process process = null;
    private BufferedReader reader = null;

    public void execute(String command) {
        Prompt.debug("exec: " + ANSIHandler.wrapper(command, 'B'));
        try {
            this.processBuilder = new ProcessBuilder(new String[0]);
            this.processBuilder.command("/bin/bash", "-c", command);
            this.processBuilder.redirectErrorStream(true);
            this.process = this.processBuilder.start();
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
    }

    public void executeFrom(String command, File dir) {
        Prompt.debug("exec: " + ANSIHandler.wrapper(dir.getAbsolutePath(), 'g') + "$ " + ANSIHandler.wrapper(command, 'B'));
        try {
            this.processBuilder = new ProcessBuilder(new String[0]);
            this.processBuilder.command("/bin/bash", "-c", command);
            this.processBuilder.directory(dir);
            this.processBuilder.redirectErrorStream(true);
            this.process = this.processBuilder.start();
            this.process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
    }

    public String[] raw() throws IOException {
        if (this.reader == null) {
            Prompt.print("Shell", "No command has been executed");
            return null;
        }
        ArrayList<String> alist = new ArrayList<String>();
        String line = this.reader.readLine();
        do {
            alist.add(line);
        } while ((line = this.reader.readLine()) != null);
        alist.add("");
        String[] ls = new String[alist.size()];
        for (int i = 0; i < alist.size(); ++i) {
            ls[i] = (String)alist.get(i);
        }
        return ls;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public static String[] exec(String cmd) {
        String[] raw = null;
        try {
            Shell sh = new Shell();
            sh.execute(cmd);
            raw = sh.raw();
            sh.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return raw;
    }

    public static void exec(String cmd, File dir) {
        try {
            Shell sh = new Shell();
            sh.executeFrom(cmd, dir);
            sh.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

