/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import leb.util.common.ANSIHandler;
import leb.util.common.TimeKeeper;
import leb.util.config.GenericConfig;

public class Prompt {
    private static String buildMessage(String head, String message, char color) {
        int hlen = head.length();
        StringBuilder headBuilder = new StringBuilder(head);
        for (int i = 0; i < GenericConfig.HLEN - hlen; ++i) {
            headBuilder.append(" ");
        }
        head = headBuilder.toString();
        String header = ANSIHandler.wrapper(GenericConfig.TSTAMP ? String.format("[%s] %s |:", TimeKeeper.timeStamp(), head) : String.format("%s |:", head), color);
        return String.format("%s  %s", header, message);
    }

    public static void print_univ(String head, String message, char color) {
        System.out.println(Prompt.buildMessage(head, message, color));
    }

    public static void print(String head, String message) {
        Prompt.print_univ(head, message, 'C');
    }

    public static void print(String message) {
        Prompt.print(GenericConfig.PHEAD, message);
    }

    public static void talk(String head, String message) {
        if (GenericConfig.VERB) {
            Prompt.print_univ(head, message, 'c');
        }
    }

    public static void talk(String message) {
        Prompt.talk(GenericConfig.PHEAD, message);
    }

    public static void debug(String head, String message) {
        if (GenericConfig.DEV) {
            Prompt.print_univ(head, message, 'G');
        }
    }

    public static void debug(String message) {
        Prompt.debug("DEV", message);
    }

    public static void error(String message) {
        Prompt.print_univ("ERROR", message, 'r');
    }

    public static void warning(String message) {
        Prompt.print_univ("WARNING", message, 'y');
    }
}

