/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leb.util.common.Shell;

public abstract class ExecHandler {
    protected String job = null;
    protected List<String> args = null;
    protected Map<String, String> argMap = null;

    protected void init(String job) {
        this.job = job;
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (this.argMap == null) {
            this.argMap = new HashMap<String, String>();
        }
    }

    protected void addArgument(String opt, Object val) {
        this.args.add(opt);
        this.argMap.put(opt, " " + val.toString());
    }

    protected void addArgument(String val) {
        this.args.add(val);
        this.argMap.put(val, "");
    }

    protected String getCommandLine() {
        StringBuilder cmd = new StringBuilder(this.job);
        for (String arg : this.args) {
            cmd.append(" ").append(arg).append(this.argMap.get(arg));
        }
        return cmd.toString();
    }

    protected void exec() {
        Shell.exec(this.getCommandLine());
    }
}

