/*
 * Decompiled with CFR 0.152.
 */
package leb.util.common;

import leb.util.config.GenericConfig;

public class ANSIHandler {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[30m";
    public static final String RED = "\u001b[31m";
    public static final String GREEN = "\u001b[32m";
    public static final String YELLOW = "\u001b[33m";
    public static final String BLUE = "\u001b[34m";
    public static final String PURPLE = "\u001b[35m";
    public static final String CYAN = "\u001b[36m";
    public static final String WHITE = "\u001b[37m";
    public static final String BBLACK = "\u001b[30;1m";
    public static final String BRED = "\u001b[31;1m";
    public static final String BGREEN = "\u001b[32;1m";
    public static final String BYELLOW = "\u001b[33;1m";
    public static final String BBLUE = "\u001b[34;1m";
    public static final String BCYAN = "\u001b[36;1m";

    private static String csMapper(char code) {
        if (GenericConfig.NOCOLOR) {
            return "";
        }
        switch (code) {
            case 'x': {
                return RESET;
            }
            case 'k': {
                return BLACK;
            }
            case 'r': {
                return RED;
            }
            case 'g': {
                return GREEN;
            }
            case 'y': {
                return YELLOW;
            }
            case 'b': {
                return BLUE;
            }
            case 'p': {
                return PURPLE;
            }
            case 'c': {
                return CYAN;
            }
            case 'w': {
                return WHITE;
            }
            case 'K': {
                return BBLACK;
            }
            case 'R': {
                return BRED;
            }
            case 'G': {
                return BGREEN;
            }
            case 'Y': {
                return BYELLOW;
            }
            case 'B': {
                return BBLUE;
            }
            case 'C': {
                return BCYAN;
            }
        }
        return null;
    }

    public static String wrapper(String str, char code) {
        return String.format("%s%s%s", ANSIHandler.csMapper(code), str, ANSIHandler.csMapper('x'));
    }

    public static String wrapper(Object obj, char code) {
        return String.format("%s%s%s", ANSIHandler.csMapper(code), obj.toString(), ANSIHandler.csMapper('x'));
    }
}

