/*
 * Decompiled with CFR 0.152.
 */
package leb.process;

import java.util.LinkedList;
import java.util.List;

public class ProcUPGMA {
    private double[][] dmat;
    private final List<String> leaves = new LinkedList<String>();
    private final List<Double> depths = new LinkedList<Double>();
    private final List<Integer> counts = new LinkedList<Integer>();
    private int N;

    public ProcUPGMA(double[][] dmat, List<Integer> ids, List<String> labels, boolean useid) {
        this.dmat = dmat;
        if (useid) {
            for (int id : ids) {
                this.leaves.add(String.format("%d", id));
            }
        } else {
            this.leaves.addAll(labels);
        }
        this.N = labels.size();
        for (int i = 0; i < this.N; ++i) {
            this.depths.add(0.0);
            this.counts.add(1);
        }
    }

    private void iterate() {
        int mi = -1;
        int mj = -1;
        double md = 200.0;
        for (int i = 0; i < this.N - 1; ++i) {
            for (int j = i + 1; j < this.N; ++j) {
                if (!(this.dmat[i][j] < md)) continue;
                md = this.dmat[i][j];
                mi = i;
                mj = j;
            }
        }
        double[][] umat = new double[this.N - 1][this.N - 1];
        int ni = 1;
        for (int i = 0; i < this.N; ++i) {
            double ad;
            if (i - mi == 0 || i - mj == 0) continue;
            int nj = 1;
            for (int j = 0; j < this.N; ++j) {
                if (j - mi == 0 || j - mj == 0) continue;
                if (i - j != 0) {
                    umat[ni][nj] = this.dmat[i][j];
                }
                ++nj;
            }
            umat[ni][0] = ad = (this.dmat[i][mi] * (double)this.counts.get(mi).intValue() + this.dmat[i][mj] * (double)this.counts.get(mj).intValue()) / (double)(this.counts.get(mi) + this.counts.get(mj));
            umat[0][ni] = ad;
            ++ni;
        }
        String newLeaf = String.format("(%s:%f,%s:%f)", this.leaves.get(mi), this.dmat[mi][mj] / 2.0 - this.depths.get(mi), this.leaves.get(mj), this.dmat[mi][mj] / 2.0 - this.depths.get(mj));
        this.leaves.remove(mj);
        this.leaves.remove(mi);
        this.leaves.add(0, newLeaf);
        double newDepth = this.dmat[mi][mj] / 2.0;
        this.depths.remove(mj);
        this.depths.remove(mi);
        this.depths.add(0, newDepth);
        int newCount = this.counts.get(mi) + this.counts.get(mj);
        this.counts.remove(mj);
        this.counts.remove(mi);
        this.counts.add(0, newCount);
        this.dmat = new double[this.N - 1][this.N - 1];
        for (int i = 0; i < this.N - 1; ++i) {
            System.arraycopy(umat[i], 0, this.dmat[i], 0, this.N - 1);
        }
        --this.N;
    }

    public String getTree() {
        while (this.N > 1) {
            this.iterate();
        }
        return this.leaves.get(0) + ";";
    }
}

