/*
 * Decompiled with CFR 0.152.
 */
package leb.process;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import leb.process.ProdigalThread;
import leb.util.common.Shell;
import leb.util.config.GenericConfig;

public class ProcParallelProdigal {
    private final String input;
    private final String output;
    private final String temp;
    private final String ufasta;
    private final String prodigal;
    private final Integer thread;

    public ProcParallelProdigal(String input, String output, String temp, String ufasta, String prodigal, int thread) {
        this.input = input;
        this.output = output;
        this.temp = temp;
        this.ufasta = ufasta;
        this.prodigal = prodigal;
        this.thread = thread;
    }

    private String splitCommand() {
        StringBuilder command = new StringBuilder(String.format("%s split -i %s", this.ufasta, this.input));
        for (int i = 0; i < this.thread; ++i) {
            command.append(String.format(" %s_%d.fa", this.temp + GenericConfig.SESSION_UID, i));
        }
        return command.toString();
    }

    private void poolProdigal() throws ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(this.thread);
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (int i = 0; i < this.thread; ++i) {
            ProdigalThread prodigalThread = new ProdigalThread(this.prodigal, String.format("%s_%d.fa", this.temp + GenericConfig.SESSION_UID, i), String.format("%s_%d.out.fa", this.temp + GenericConfig.SESSION_UID, i));
            futures.add(executor.submit(prodigalThread));
        }
        executor.shutdown();
        for (Future future : futures) {
            future.get();
        }
    }

    private String catCommand() {
        StringBuilder command = new StringBuilder("cat ");
        for (int i = 0; i < this.thread; ++i) {
            command.append(String.format("%s_%d.out.fa ", this.temp + GenericConfig.SESSION_UID, i));
        }
        command.append(String.format("> %s", this.output));
        return command.toString();
    }

    private void clean() {
        for (int i = 0; i < this.thread; ++i) {
            new File(String.format("%s_%d.fa", this.temp + GenericConfig.SESSION_UID, i)).delete();
            new File(String.format("%s_%d.out.fa", this.temp + GenericConfig.SESSION_UID, i)).delete();
            new File(String.format("%s_%d.fa.log", this.temp + GenericConfig.SESSION_UID, i)).delete();
        }
    }

    public int run() {
        try {
            Shell.exec(this.splitCommand());
            this.poolProdigal();
            Shell.exec(this.catCommand());
            this.clean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }
}

