/*
 * Decompiled with CFR 0.152.
 */
package leb.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leb.process.ProcFuncAnnoByBlastPlus;
import leb.process.ProcFuncAnnoByDiamond;
import leb.process.ProcFuncAnnoByMMSeqs2;
import leb.util.common.Prompt;
import leb.util.config.GenericConfig;
import leb.util.seq.Blast6FormatHitDomain;
import leb.wrapper.DiamondWrapper;
import org.apache.commons.io.FileUtils;

public class ProcCalcPairwiseAAI {
    public static final int MODE_DEFAULT = 3;
    public static final int MODE_BLASTP = 1;
    public static final int MODE_MMSEQS = 3;
    public static final int MODE_DIAMOND = 4;
    public static final int MODE_DSENS = 5;
    private String globaltmp = "/tmp/ezaai";
    private int mode = 3;
    private int nthread = 1;
    private double identity = 40.0;
    private double coverage = 0.5;
    private String path = null;
    private String dbpath = null;
    private BufferedWriter maw = null;
    private String label1 = null;
    private String label2 = null;

    public void setGlobaltmp(String globaltmp) {
        this.globaltmp = globaltmp;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setNthread(int nthread) {
        this.nthread = nthread;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setDbpath(String dbpath) {
        this.dbpath = dbpath;
    }

    public void setIdentity(double identity) {
        this.identity = identity * 100.0;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public void setMatchout(BufferedWriter maw) {
        this.maw = maw;
    }

    public List<String> calculateProteomePairWithDetails(String label1, String label2, String faa1, String faa2) throws IOException {
        this.label1 = label1;
        this.label2 = label2;
        ArrayList<String> res = new ArrayList<String>();
        switch (this.mode) {
            case 1: {
                return this.pairwiseBlastp(faa1, faa2);
            }
            case 3: {
                return this.pairwiseMmseqs(faa1, faa2);
            }
            case 4: {
                return this.pairwiseDiamond(faa1, faa2, false);
            }
            case 5: {
                return this.pairwiseDiamond(faa1, faa2, true);
            }
        }
        return res;
    }

    private void mapLength(BufferedReader br1, BufferedReader br2, Map<String, Integer> lmap, Map<String, Integer> nmap1, Map<String, Integer> nmap2, List<String> nlist1, List<String> nlist2) throws IOException {
        int ed;
        int st;
        String id;
        String buf;
        int n1 = 0;
        int n2 = 0;
        while ((buf = br1.readLine()) != null) {
            if (!buf.startsWith(">")) continue;
            id = buf.split(" ")[0].substring(1);
            st = Integer.parseInt(buf.split(" ")[2]);
            ed = Integer.parseInt(buf.split(" ")[4]);
            lmap.put(id, (ed - st - 2) / 3);
            nmap1.put(id, n1++);
            nlist1.add(id);
        }
        while ((buf = br2.readLine()) != null) {
            if (!buf.startsWith(">")) continue;
            id = buf.split(" ")[0].substring(1);
            st = Integer.parseInt(buf.split(" ")[2]);
            ed = Integer.parseInt(buf.split(" ")[4]);
            lmap.put(id, (ed - st - 2) / 3);
            nmap2.put(id, n2++);
            nlist2.add(id);
        }
    }

    private List<String> calcIdentityWithDetails(List<Blast6FormatHitDomain> hits_vice, List<Blast6FormatHitDomain> hits_versa, Map<String, Integer> lengthMap, Map<String, Integer> nameMap1, Map<String, Integer> nameMap2, List<String> nameList1, List<String> nameList2) {
        ArrayList<String> res = new ArrayList<String>();
        int fac = this.mode == 3 ? 100 : 1;
        int n1 = nameMap1.size();
        int n2 = nameMap2.size();
        Prompt.debug(String.format("n1 = %d, n2 = %d, l1 = %d, l2= %d", n1, n2, nameList1.size(), nameList2.size()));
        res.add(String.valueOf(n2));
        res.add(String.valueOf(n1));
        double[][] viceMatrix = new double[n1][n2];
        double[][] versaMatrix = new double[n1][n2];
        int[][] viceLength = new int[n1][n2];
        int[][] versaLength = new int[n1][n2];
        int hcnt = 0;
        for (Blast6FormatHitDomain hit : hits_vice) {
            if (!(hit.getIdentity() * (double)fac >= this.identity) || !((double)(hit.getEndInQuery() - hit.getStartInQuery()) / (double)lengthMap.get(hit.getQuery().split(" ")[0]).intValue() >= this.coverage)) continue;
            viceMatrix[nameMap1.get((Object)hit.getTarget().split((String)" ")[0]).intValue()][nameMap2.get((Object)hit.getQuery().split((String)" ")[0]).intValue()] = hit.getIdentity() * (double)fac;
            viceLength[nameMap1.get((Object)hit.getTarget().split((String)" ")[0]).intValue()][nameMap2.get((Object)hit.getQuery().split((String)" ")[0]).intValue()] = hit.getAlignmentLength();
            if (++hcnt >= 10) continue;
            Prompt.debug(String.format("Forward hit #%d : %s\tvs.%s\t= %.3f", hcnt, hit.getTarget().split(" ")[0], hit.getQuery().split(" ")[0], hit.getIdentity() * (double)fac));
        }
        Prompt.talk(String.format("%d forward hits found.", hcnt));
        res.add(String.valueOf(hcnt));
        hcnt = 0;
        for (Blast6FormatHitDomain hit : hits_versa) {
            if (!(hit.getIdentity() * (double)fac >= this.identity) || !((double)(hit.getEndInQuery() - hit.getStartInQuery()) / (double)lengthMap.get(hit.getQuery().split(" ")[0]).intValue() >= this.coverage)) continue;
            versaMatrix[nameMap1.get((Object)hit.getQuery().split((String)" ")[0]).intValue()][nameMap2.get((Object)hit.getTarget().split((String)" ")[0]).intValue()] = hit.getIdentity() * (double)fac;
            versaLength[nameMap1.get((Object)hit.getQuery().split((String)" ")[0]).intValue()][nameMap2.get((Object)hit.getTarget().split((String)" ")[0]).intValue()] = hit.getAlignmentLength();
            if (++hcnt >= 10) continue;
            Prompt.debug(String.format("Backward hit #%d : %s\tvs.%s\t= %.3f", hcnt, hit.getQuery().split(" ")[0], hit.getTarget().split(" ")[0], hit.getIdentity() * (double)fac));
        }
        Prompt.talk(String.format("%d backward hits found.", hcnt));
        res.add(String.valueOf(hcnt));
        int nval = 0;
        double isum = 0.0;
        int lsum = 0;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(viceMatrix[i][j] >= this.identity) || !(versaMatrix[i][j] >= this.identity)) continue;
                ++nval;
                isum += viceMatrix[i][j] + versaMatrix[i][j];
                lsum += viceLength[i][j] + versaLength[i][j];
                if (this.maw == null) continue;
                try {
                    this.maw.write(String.format("%d\t%d\t%s\t%s\t%s\t%s\t%.3f\t%.3f\t%.3f\n", Math.abs(this.label1.hashCode()) % 0x40000000, Math.abs(this.label2.hashCode()) % 0x40000000, this.label1, this.label2, nameList1.get(j), nameList2.get(i), viceMatrix[i][j], versaMatrix[i][j], (viceMatrix[i][j] + versaMatrix[i][j]) / 2.0));
                    continue;
                }
                catch (IOException e) {
                    Prompt.error("FATAL ERROR : Failed to write match output.");
                    return null;
                }
            }
        }
        if (nval == 0) {
            Prompt.print("WARNING: No reciprocal hits found.");
            res.add("0");
            res.add("NaN");
            res.add("NaN");
            return res;
        }
        Prompt.talk(String.format("%d reciprocal hits found. Estimated AAI : %.3f", nval, isum / (double)(nval * 2)));
        res.add(String.valueOf(nval));
        res.add(String.valueOf(lsum / (nval * 2)));
        res.add(String.valueOf(isum / (double)(nval * 2)));
        return res;
    }

    private List<String> pairwiseBlastp(String faa1, String faa2) throws IOException {
        BufferedReader br1 = new BufferedReader(new FileReader(faa1));
        BufferedReader br2 = new BufferedReader(new FileReader(faa2));
        HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap1 = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap2 = new HashMap<String, Integer>();
        ArrayList<String> nameList1 = new ArrayList<String>();
        ArrayList<String> nameList2 = new ArrayList<String>();
        this.mapLength(br1, br2, lengthMap, nameMap1, nameMap2, nameList1, nameList2);
        br1.close();
        br2.close();
        Prompt.print("Preparing to run reciprocal BLASTp+...");
        ProcFuncAnnoByBlastPlus procBlast = new ProcFuncAnnoByBlastPlus();
        if (this.path == null) {
            this.path = "blastp";
        }
        if (this.dbpath == null) {
            this.dbpath = "makeblastdb";
        }
        procBlast.setProgramPath(this.path);
        procBlast.setBlastdbPath(this.dbpath);
        procBlast.setEvalue(0.1);
        procBlast.setThreads(this.nthread);
        procBlast.setKeepBlastOutput(GenericConfig.KEEP);
        procBlast.executeMakeBlastDb(faa1, 1, GenericConfig.VERB);
        procBlast.executeMakeBlastDb(faa2, 1, GenericConfig.VERB);
        Prompt.print(String.format("Running BLASTp+... (%s vs. %s)", faa1, faa2));
        procBlast.setOutFileName(this.globaltmp + File.separator + GenericConfig.TEMP_HEADER + "vice.out");
        List<Blast6FormatHitDomain> hits_vice = procBlast.execute(faa1, faa2, GenericConfig.VERB);
        Prompt.print(String.format("Running BLASTp+... (%s vs. %s)", faa2, faa1));
        procBlast.setOutFileName(this.globaltmp + File.separator + GenericConfig.TEMP_HEADER + "versa.out");
        List<Blast6FormatHitDomain> hits_versa = procBlast.execute(faa2, faa1, GenericConfig.VERB);
        if (!GenericConfig.KEEP) {
            new File(faa1 + ".pin").delete();
            new File(faa1 + ".phr").delete();
            new File(faa1 + ".psq").delete();
            new File(faa2 + ".pin").delete();
            new File(faa2 + ".phr").delete();
            new File(faa2 + ".psq").delete();
        }
        return this.calcIdentityWithDetails(hits_vice, hits_versa, lengthMap, nameMap1, nameMap2, nameList1, nameList2);
    }

    private List<String> pairwiseMmseqs(String faa1, String faa2) throws IOException {
        BufferedReader br1 = new BufferedReader(new FileReader(faa1));
        BufferedReader br2 = new BufferedReader(new FileReader(faa2));
        HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap1 = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap2 = new HashMap<String, Integer>();
        ArrayList<String> nameList1 = new ArrayList<String>();
        ArrayList<String> nameList2 = new ArrayList<String>();
        this.mapLength(br1, br2, lengthMap, nameMap1, nameMap2, nameList1, nameList2);
        br1.close();
        br2.close();
        Prompt.talk("Preparing to run reciprocal MMSeqs2 search...");
        ProcFuncAnnoByMMSeqs2 procMmseqs = new ProcFuncAnnoByMMSeqs2();
        if (this.path == null) {
            this.path = "mmseqs";
        }
        procMmseqs.setMmseqsPath(this.path);
        File mmout = new File(this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_MM");
        if (!mmout.exists()) {
            mmout.mkdir();
        } else if (!mmout.isDirectory()) {
            Prompt.error("FATAL ERROR : MMSeqs2 output directory could not be created.");
            return null;
        }
        String outDir = mmout.getAbsolutePath();
        String tmpDir = this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_tmp";
        procMmseqs.setThreads(this.nthread);
        procMmseqs.setAlignmentMode(3);
        procMmseqs.executeCreateDb(faa1, outDir + File.separator + "db1");
        procMmseqs.executeCreateDb(faa2, outDir + File.separator + "db2");
        Prompt.talk(String.format("Running MMSeqs2 search... (%s vs. %s)", faa1, faa2));
        procMmseqs.executeSearch(outDir + File.separator + "db1", outDir + File.separator + "db2", outDir + File.separator + "vice", tmpDir);
        procMmseqs.executeFilterdb(outDir + File.separator + "vice", outDir + File.separator + "vice_filt", tmpDir);
        procMmseqs.executeConvertAlis(outDir + File.separator + "db1", outDir + File.separator + "db2", outDir + File.separator + "vice_filt", outDir + File.separator + "vice.m8");
        List<Blast6FormatHitDomain> hits_vice = procMmseqs.parseOutFile(outDir + File.separator + "vice.m8");
        Prompt.talk(String.format("Running MMSeqs2 search... (%s vs. %s)", faa2, faa1));
        procMmseqs.executeSearch(outDir + File.separator + "db2", outDir + File.separator + "db1", outDir + File.separator + "versa", tmpDir);
        procMmseqs.executeFilterdb(outDir + File.separator + "versa", outDir + File.separator + "versa_filt", tmpDir);
        procMmseqs.executeConvertAlis(outDir + File.separator + "db2", outDir + File.separator + "db1", outDir + File.separator + "versa_filt", outDir + File.separator + "versa.m8");
        List<Blast6FormatHitDomain> hits_versa = procMmseqs.parseOutFile(outDir + File.separator + "versa.m8");
        if (!GenericConfig.KEEP) {
            FileUtils.deleteDirectory(new File(this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_MM"));
            FileUtils.deleteDirectory(new File(this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_tmp"));
        }
        return this.calcIdentityWithDetails(hits_vice, hits_versa, lengthMap, nameMap2, nameMap1, nameList1, nameList2);
    }

    private List<String> pairwiseDiamond(String faa1, String faa2, boolean sensitive) throws IOException {
        BufferedReader br1 = new BufferedReader(new FileReader(faa1));
        BufferedReader br2 = new BufferedReader(new FileReader(faa2));
        HashMap<String, Integer> lengthMap = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap1 = new HashMap<String, Integer>();
        HashMap<String, Integer> nameMap2 = new HashMap<String, Integer>();
        ArrayList<String> nameList1 = new ArrayList<String>();
        ArrayList<String> nameList2 = new ArrayList<String>();
        this.mapLength(br1, br2, lengthMap, nameMap1, nameMap2, nameList1, nameList2);
        br1.close();
        br2.close();
        Prompt.talk("Preparing to run reciprocal Diamond search...");
        ProcFuncAnnoByDiamond procDiamond = new ProcFuncAnnoByDiamond(DiamondWrapper.BLASTP);
        if (this.path == null) {
            this.path = "diamond";
        }
        procDiamond.setDiamondPath(this.path);
        File dmout = new File(this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_DM");
        if (!dmout.exists()) {
            dmout.mkdir();
        } else if (!dmout.isDirectory()) {
            Prompt.error("FATAL ERROR : Diamond output directory could not be created.");
            return null;
        }
        String outDir = dmout.getAbsolutePath();
        procDiamond.setSensitive(sensitive);
        procDiamond.setOutDir(outDir);
        procDiamond.executeMakeDB(faa1, outDir + File.separator + "db1", this.nthread);
        procDiamond.executeMakeDB(faa2, outDir + File.separator + "db2", this.nthread);
        procDiamond.setIdentity(this.identity);
        procDiamond.setQcov(this.coverage * 100.0);
        Prompt.talk(String.format("Running Diamond search... (%s vs. %s)", faa1, faa2));
        List<Blast6FormatHitDomain> hits_vice = procDiamond.execute(faa1, outDir + File.separator + "db2", this.nthread);
        Prompt.talk(String.format("Running Diamond search... (%s vs. %s)", faa2, faa1));
        List<Blast6FormatHitDomain> hits_versa = procDiamond.execute(faa2, outDir + File.separator + "db1", this.nthread);
        if (!GenericConfig.KEEP) {
            FileUtils.deleteDirectory(new File(this.globaltmp + File.separator + GenericConfig.SESSION_UID + "_DM"));
        }
        return this.calcIdentityWithDetails(hits_vice, hits_versa, lengthMap, nameMap2, nameMap1, nameList1, nameList2);
    }
}

