/*
 * Decompiled with CFR 0.152.
 */
package leb.process;

import java.io.File;
import leb.wrapper.ProdigalWrapper;

public class ProcCDSPredictionByProdigal {
    private String outDir = "/tmp/ezaai";
    private String prodigalPath = "prodigal";
    boolean meta = true;
    private String gffOutFileName = this.outDir + File.separator + "prodigal.gff";
    private String faaOutFileName = this.outDir + File.separator + "prodigal.faa";
    private String ffnOutFileName = this.outDir + File.separator + "prodigal.ffn";

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public void setProdigalPath(String prodigalPath) {
        this.prodigalPath = prodigalPath;
    }

    public void setGffOutFileName(String gffOutFileName) {
        this.gffOutFileName = gffOutFileName;
    }

    public void setFaaOutFileName(String faaOutFileName) {
        this.faaOutFileName = faaOutFileName;
    }

    public void setFfnOutFileName(String ffnOutFileName) {
        this.ffnOutFileName = ffnOutFileName;
    }

    public void execute(String seqFileName, boolean ignoredVerbose) {
        boolean allowPartialGene;
        File dir = new File(this.outDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ProdigalWrapper prodigal = new ProdigalWrapper(this.prodigalPath);
        prodigal.setInputFileName(seqFileName);
        prodigal.setOutputFormat("gff");
        File prodigal_gff = new File(this.gffOutFileName);
        File prodigal_faa = new File(this.faaOutFileName);
        File prodigal_ffn = new File(this.ffnOutFileName);
        prodigal.setOutputFileName(prodigal_gff.getAbsolutePath());
        prodigal.setProteinFileName(prodigal_faa.getAbsolutePath());
        prodigal.setNuclFileName(prodigal_ffn.getAbsolutePath());
        prodigal.setQuietRun();
        if (this.meta) {
            prodigal.setMetagenome();
        }
        if (!(allowPartialGene = true)) {
            prodigal.setClosedEnds();
        }
        int transl_table = 11;
        prodigal.setTranslationTable(transl_table);
        prodigal.run();
    }
}

