/*
 * Decompiled with CFR 0.152.
 */
package leb.main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import leb.process.ProcCDSPredictionByProdigal;
import leb.process.ProcCalcPairwiseAAI;
import leb.process.ProcFuncAnnoByMMSeqs2;
import leb.process.ProcParallelProdigal;
import leb.process.ProcUPGMA;
import leb.util.common.ANSIHandler;
import leb.util.common.Arguments;
import leb.util.common.Prompt;
import leb.util.common.Shell;
import leb.util.config.GenericConfig;
import leb.util.seq.DnaSeqDomain;
import leb.util.seq.FastSeqLoader;
import leb.util.seq.Seqtools;
import org.apache.commons.io.FileUtils;

public class EzAAI {
    public static final String VERSION = "v1.2.3";
    public static final String RELEASE = "Feb. 2024";
    public static final String CITATION = " Kim, D., Park, S. & Chun, J.\n Introducing EzAAI: a pipeline for high throughput calculations of prokaryotic average amino acid identity.\n J Microbiol. 59, 476\u2013480 (2021).\n DOI: 10.1007/s12275-021-1154-0";
    public static final boolean STABLE = true;
    static final int MODULE_CONVERT = 1;
    static final int MODULE_EXTRACT = 2;
    static final int MODULE_CALCULATE = 3;
    static final int MODULE_CLUSTER = 4;
    static final int MODULE_CONVERTDB = 5;
    static final int MODULE_INVALID = 0;
    static final int PROGRAM_MMSEQS = 1;
    static final int PROGRAM_DIAMOND = 2;
    static final int PROGRAM_BLASTP = 3;
    static final int PROGRAM_PRODIGAL = 4;
    static final int PROGRAM_BLASTDB = 5;
    static final int PROGRAM_UFASTA = 6;
    int module = 0;
    String input1 = null;
    String output = null;
    String tmp = "/tmp/ezaai";
    boolean outExists = false;
    boolean seqNucl = true;
    boolean multithread = false;
    String path_prodigal = "prodigal";
    String path_mmseqs = "mmseqs";
    String path_diamond = "diamond";
    String path_blastp = "blastp";
    String path_blastdb = "makeblastdb";
    String path_ufasta = "ufasta";
    String label = null;
    String input2 = null;
    String matchout = null;
    String mtxout = null;
    int thread = 10;
    double identity = 0.4;
    double coverage = 0.5;
    boolean self = false;
    int program = 1;
    boolean useid = false;

    public EzAAI(String module) {
        if (module.equals("convert")) {
            this.module = 1;
        }
        if (module.equals("extract")) {
            this.module = 2;
        }
        if (module.equals("calculate")) {
            this.module = 3;
        }
        if (module.equals("cluster")) {
            this.module = 4;
        }
        if (module.equals("convertdb")) {
            this.module = 5;
        }
    }

    private int parseArguments(String[] args) {
        String modstr = "";
        switch (this.module) {
            case 1: {
                modstr = "convert";
                break;
            }
            case 2: {
                modstr = "extract";
                break;
            }
            case 3: {
                modstr = "calculate";
                break;
            }
            case 4: {
                modstr = "cluster";
                break;
            }
            case 5: {
                modstr = "convertdb";
            }
        }
        Arguments arg = new Arguments(args);
        if (arg.get("-i") == null) {
            Prompt.error("No input file given. Run with \"" + modstr + " -h\" argument to get manual on this module.");
            return -1;
        }
        this.input1 = arg.get("-i");
        File fileInput = new File(this.input1);
        if (!fileInput.exists() || fileInput.isDirectory() && this.module != 3) {
            Prompt.error("Invalid input file given.");
            return -1;
        }
        if (arg.get("-o") == null) {
            Prompt.error("No output file given. Run with \"" + modstr + " -h\" argument to get manual on this module.");
            return -1;
        }
        this.output = arg.get("-o");
        if (new File(this.output).exists()) {
            if (new File(this.output).isDirectory()) {
                Prompt.error("Given output file exists and is a directory: " + this.output);
                return -1;
            }
            this.outExists = true;
            if (this.module == 3) {
                Prompt.warning("Output file exists. Results will be appended.");
            } else {
                Prompt.warning("Output file exists. Results will be overwritten.");
            }
        }
        if (arg.get("-tmp") != null) {
            this.tmp = arg.get("-tmp");
            if (new File(this.tmp).exists()) {
                if (!new File(this.tmp).isDirectory()) {
                    Prompt.error("Invalid temporary directory given: " + this.tmp);
                    return -1;
                }
                Prompt.talk("Using existing temporary directory: " + this.tmp);
            } else if (new File(this.tmp).mkdirs()) {
                Prompt.talk("Created temporary directory: " + this.tmp);
            } else {
                Prompt.error("Failed to create temporary directory: " + this.tmp);
                return -1;
            }
        }
        if (this.module == 1) {
            if (arg.get("-s") == null) {
                Prompt.error("No sequence type given. Run with \"convert -h\" argument to get manual on this module.");
                return -1;
            }
            if (arg.get("-s").equals("prot")) {
                this.seqNucl = false;
            } else if (!arg.get("-s").equals("nucl")) {
                Prompt.error("Invalid sequence type given.");
                return -1;
            }
            this.label = arg.get("-l") == null ? this.input1 : arg.get("-l");
            if (arg.get("-m") != null) {
                this.path_mmseqs = arg.get("-m");
            }
        }
        if (this.module == 2) {
            this.label = arg.get("-l") == null ? this.input1 : arg.get("-l");
            if (arg.get("-m") != null) {
                this.path_mmseqs = arg.get("-m");
            }
            if (arg.get("-t") != null) {
                this.thread = Integer.parseInt(arg.get("-t"));
                if (this.thread > 1) {
                    this.multithread = true;
                }
            } else {
                this.thread = 1;
            }
        }
        if (this.module == 3) {
            if (arg.get("-p") != null) {
                String pstr;
                switch (pstr = arg.get("-p")) {
                    case "mmseqs": {
                        this.program = 1;
                        break;
                    }
                    case "diamond": {
                        this.program = 2;
                        break;
                    }
                    case "blastp": {
                        this.program = 3;
                        break;
                    }
                    default: {
                        Prompt.error("Invalid program given.");
                        return -1;
                    }
                }
            }
            if (arg.get("-j") == null) {
                Prompt.error("No secondary input file given. Run with \"calculate -h\" argument to get manual on this module.");
                return -1;
            }
            this.input2 = arg.get("-j");
            fileInput = new File(this.input2);
            if (!fileInput.exists()) {
                Prompt.error("Invalid input file given.");
                return -1;
            }
            if (arg.get("-self") != null) {
                boolean bl = this.self = Integer.parseInt(arg.get("-self")) != 0;
                if (this.self && !this.input1.equals(this.input2)) {
                    Prompt.error("Self-comparison with different input files is not allowed.");
                    return -1;
                }
            }
            if (arg.get("-id") != null) {
                this.identity = Double.parseDouble(arg.get("-id"));
            }
            if (arg.get("-cov") != null) {
                this.coverage = Double.parseDouble(arg.get("-cov"));
            }
            if (arg.get("-match") != null) {
                this.matchout = arg.get("-match");
            }
            if (arg.get("-mtx") != null) {
                this.mtxout = arg.get("-mtx");
            }
            if (arg.get("-t") != null) {
                this.thread = Integer.parseInt(arg.get("-t"));
            }
        }
        if (this.module == 4 && arg.get("-u") != null) {
            this.useid = true;
        }
        if (arg.get("-prodigal") != null) {
            this.path_prodigal = arg.get("-prodigal");
        }
        if (arg.get("-mmseqs") != null) {
            this.path_mmseqs = arg.get("-mmseqs");
        }
        if (arg.get("-diamond") != null) {
            this.path_diamond = arg.get("-diamond");
        }
        if (arg.get("-blastp") != null) {
            this.path_blastp = arg.get("-blastp");
        }
        if (arg.get("-makeblastdb") != null) {
            this.path_blastdb = arg.get("-makeblastdb");
        }
        if (arg.get("-ufasta") != null) {
            this.path_ufasta = arg.get("-ufasta");
        }
        return 0;
    }

    private boolean checkProgram(int program) {
        boolean sane = true;
        switch (program) {
            case 1: {
                sane = Shell.exec(this.path_mmseqs + " -h")[0].contains("MMseqs2");
                break;
            }
            case 2: {
                sane = Shell.exec(this.path_diamond + " help")[0].contains("diamond v");
                break;
            }
            case 3: {
                sane = Shell.exec(this.path_blastp + " -h")[1].contains("blastp");
                break;
            }
            case 4: {
                sane = Shell.exec(this.path_prodigal + " -h")[1].contains("prodigal");
                break;
            }
            case 5: {
                sane = Shell.exec(this.path_blastdb + " -h")[1].contains("makeblastdb");
                break;
            }
            case 6: {
                sane = Shell.exec(this.path_ufasta + " -h")[0].contains("Usage");
            }
        }
        return !sane;
    }

    private int checkDependency(int module, int program) {
        Prompt.talk("Checking dependencies...");
        switch (module) {
            case 1: 
            case 5: {
                if (!this.checkProgram(1)) break;
                return 1;
            }
            case 2: {
                if (this.checkProgram(4)) {
                    return 4;
                }
                if (this.checkProgram(1)) {
                    return 1;
                }
                if (!this.multithread || !this.checkProgram(6)) break;
                return 6;
            }
            case 3: {
                if (program == 2 && this.checkProgram(2)) {
                    return 2;
                }
                if (program == 3) {
                    if (this.checkProgram(3)) {
                        return 3;
                    }
                    if (this.checkProgram(5)) {
                        return 5;
                    }
                }
                if (!this.checkProgram(1)) break;
                return 1;
            }
        }
        return 0;
    }

    private int runConvert() {
        Prompt.debug("EzAAI - convert module");
        Prompt.print("Converting given CDS file into protein database... (" + this.input1 + " -> " + this.output + ")");
        String hex = Long.toHexString(new Random().nextLong());
        String faaPath = this.tmp + File.separator + hex + ".faa";
        try {
            if (this.seqNucl) {
                Prompt.talk("Translating nucleotide sequences into protein sequences...");
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(faaPath));
            List<DnaSeqDomain> seqs = FastSeqLoader.importFileToDomainList(this.input1);
            for (DnaSeqDomain seq : seqs) {
                String title = seq.getTitle();
                String dna = seq.getSequence();
                String prot = this.seqNucl ? Seqtools.translate_CDS(dna, 11, true) : dna;
                bw.write(String.format(">ezaai_%s # %d # %d\n%s\n", title.split("\\s+")[0], 1, prot.length() * 3 + 3, prot));
            }
            bw.close();
            String dir = this.tmp + File.separator + hex;
            if (!new File(dir).mkdirs()) {
                Prompt.error("Failed to create temporary directory: " + dir);
                return -1;
            }
            ProcFuncAnnoByMMSeqs2 procMmseqs = new ProcFuncAnnoByMMSeqs2();
            procMmseqs.setMmseqsPath(this.path_mmseqs);
            procMmseqs.executeCreateDb(faaPath, dir + File.separator + "mm");
            Prompt.debug("Writing file mm.label");
            bw = new BufferedWriter(new FileWriter(dir + File.separator + "mm.label"));
            bw.write(this.label + "\n");
            bw.close();
            String[] names = new String[]{"mm", "mm.dbtype", "mm.index", "mm.lookup", "mm.source", "mm_h", "mm_h.dbtype", "mm_h.index", "mm.label"};
            StringBuilder buf = new StringBuilder("tar -c -z -f mm.tar.gz");
            for (String name : names) {
                buf.append(" ").append(name);
            }
            Shell.exec(buf.toString(), new File(dir));
            Shell.exec("mv " + dir + File.separator + "mm.tar.gz " + this.output);
            for (String name : names) {
                new File(dir + File.separator + name).delete();
            }
            new File(dir).delete();
            new File(faaPath).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        Prompt.talk("EzAAI", "Conversion finished.");
        return 0;
    }

    private int runExtract() {
        Prompt.debug("EzAAI - extract module");
        String gffFile = this.tmp + File.separator + GenericConfig.SESSION_UID + ".gff";
        String faaFile = this.input1 + ".faa";
        String ffnFile = this.tmp + File.separator + GenericConfig.SESSION_UID + ".ffn";
        try {
            Object procProdigal;
            Prompt.print("Running prodigal on genome " + this.input1 + "...");
            if (this.multithread) {
                procProdigal = new ProcParallelProdigal(this.input1, faaFile, this.tmp + File.separator, this.path_ufasta, this.path_prodigal, this.thread);
                if (((ProcParallelProdigal)procProdigal).run() < 0) {
                    return -1;
                }
            } else {
                procProdigal = new ProcCDSPredictionByProdigal();
                ((ProcCDSPredictionByProdigal)procProdigal).setOutDir(this.tmp + File.separator);
                ((ProcCDSPredictionByProdigal)procProdigal).setProdigalPath(this.path_prodigal);
                ((ProcCDSPredictionByProdigal)procProdigal).setGffOutFileName(gffFile);
                ((ProcCDSPredictionByProdigal)procProdigal).setFaaOutFileName(faaFile);
                ((ProcCDSPredictionByProdigal)procProdigal).setFfnOutFileName(ffnFile);
                ((ProcCDSPredictionByProdigal)procProdigal).execute(this.input1, GenericConfig.DEV);
            }
            Prompt.talk("EzAAI", "Creating a submodule for converting .faa into .db...");
            EzAAI convertModule = new EzAAI("convert");
            String[] convertArgs = new String[]{"convert", "-i", faaFile, "-s", "prot", "-o", this.output, "-l", this.label, "-m", this.path_mmseqs, "-tmp", this.tmp};
            if (convertModule.run(convertArgs) < 0) {
                return -1;
            }
            new File(gffFile).delete();
            new File(faaFile).delete();
            new File(ffnFile).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        Prompt.print("Task finished.");
        return 0;
    }

    private int dbToFaa(String dbPath, String faaPath) {
        try {
            String[] struct;
            Shell.exec("tar -x -z -f " + dbPath);
            ProcFuncAnnoByMMSeqs2 procMmseqs = new ProcFuncAnnoByMMSeqs2();
            procMmseqs.setMmseqsPath(this.path_mmseqs);
            procMmseqs.executeConvert2Fasta("mm", faaPath);
            for (String str : struct = new String[]{"mm", "mm.dbtype", "mm.index", "mm.lookup", "mm.source", "mm_h", "mm_h.dbtype", "mm_h.index"}) {
                new File(str).delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private int runCalculate() {
        Prompt.debug("EzAAI - calculate module");
        try {
            int j;
            int i;
            BufferedReader br;
            String faaPath;
            String[] jnames;
            int i2;
            String[] inames;
            String[] ls;
            if (this.outExists) {
                BufferedReader br2 = new BufferedReader(new FileReader(this.output));
                String line = br2.readLine();
                if (line == null) {
                    Prompt.warning("Empty output file given.");
                    this.outExists = false;
                } else if (!line.equals("ID 1\tID 2\tLabel 1\tLabel 2\tAAI\tCDS count 1\tCDS count 2\tMatched count\tProteome cov.\tID param.\tCov. param.")) {
                    Prompt.error("Invalid output file given.");
                    return -1;
                }
            }
            File ifile = new File(this.input1);
            File jfile = new File(this.input2);
            if (ifile.isDirectory()) {
                ls = ifile.list();
                assert (ls != null);
                inames = new String[ls.length];
                for (i2 = 0; i2 < ls.length; ++i2) {
                    inames[i2] = ifile.getAbsolutePath() + File.separator + ls[i2];
                }
            } else {
                inames = new String[]{ifile.getAbsolutePath()};
            }
            if (jfile.isDirectory()) {
                ls = jfile.list();
                assert (ls != null);
                jnames = new String[ls.length];
                for (i2 = 0; i2 < ls.length; ++i2) {
                    jnames[i2] = jfile.getAbsolutePath() + File.separator + ls[i2];
                }
            } else {
                jnames = new String[]{jfile.getAbsolutePath()};
            }
            if (this.self && inames.length <= 1) {
                Prompt.error("Self-comparison requires directory with at least two files.");
                return -1;
            }
            ArrayList<String> ilist = new ArrayList<String>();
            ArrayList<String> jlist = new ArrayList<String>();
            ArrayList<String> ilabs = new ArrayList<String>();
            ArrayList<String> jlabs = new ArrayList<String>();
            File faaDir = new File(this.tmp + File.separator + GenericConfig.SESSION_UID + "_faa");
            if (!faaDir.exists()) {
                faaDir.mkdirs();
            } else if (!faaDir.isDirectory()) {
                Prompt.error("Could not create temporary directory for FASTA files.");
                return -1;
            }
            for (int i3 = 0; i3 < inames.length; ++i3) {
                faaPath = faaDir + File.separator + "i" + i3 + ".faa";
                if (this.dbToFaa(inames[i3], faaPath) < 0) {
                    return -1;
                }
                ilist.add(faaPath);
                br = new BufferedReader(new FileReader("mm.label"));
                ilabs.add(br.readLine());
                br.close();
                new File("mm.label").delete();
            }
            for (int j2 = 0; j2 < jnames.length; ++j2) {
                faaPath = faaDir + File.separator + "j" + j2 + ".faa";
                if (this.dbToFaa(jnames[j2], faaPath) < 0) {
                    return -1;
                }
                jlist.add(faaPath);
                br = new BufferedReader(new FileReader("mm.label"));
                jlabs.add(br.readLine());
                br.close();
                new File("mm.label").delete();
            }
            BufferedWriter maw = null;
            if (this.matchout != null) {
                maw = new BufferedWriter(new FileWriter(this.matchout));
                maw.write("ID 1\tID 2\tLabel 1\tLabel 2\tCDS 1\tCDS 2\tForward\tBackward\tAverage\n");
            }
            Double[][] aaiTable = new Double[ilist.size()][jlist.size()];
            Integer[][] hitTable = new Integer[ilist.size()][jlist.size()];
            Integer[] ilens = new Integer[ilist.size()];
            Integer[] jlens = new Integer[jlist.size()];
            int it = 0;
            int sz = this.self ? ilist.size() * (ilist.size() - 1) / 2 : ilist.size() * jlist.size();
            for (i = 0; i < ilist.size(); ++i) {
                for (j = 0; j < jlist.size(); ++j) {
                    if (this.self && i >= j) continue;
                    Prompt.print(String.format("Calculating AAI... [Task %d/%d]", ++it, sz));
                    ProcCalcPairwiseAAI procAAI = new ProcCalcPairwiseAAI();
                    switch (this.program) {
                        case 1: {
                            procAAI.setPath(this.path_mmseqs);
                            procAAI.setMode(3);
                            break;
                        }
                        case 2: {
                            procAAI.setPath(this.path_diamond);
                            procAAI.setMode(5);
                            break;
                        }
                        case 3: {
                            procAAI.setPath(this.path_blastp);
                            procAAI.setDbpath(this.path_blastdb);
                            procAAI.setMode(1);
                        }
                    }
                    procAAI.setGlobaltmp(this.tmp);
                    procAAI.setNthread(this.thread);
                    procAAI.setIdentity(this.identity);
                    procAAI.setCoverage(this.coverage);
                    if (maw != null) {
                        procAAI.setMatchout(maw);
                    }
                    List<String> res = procAAI.calculateProteomePairWithDetails((String)ilabs.get(i), (String)jlabs.get(j), (String)ilist.get(i), (String)jlist.get(j));
                    hitTable[i][j] = Integer.parseInt(res.get(4));
                    aaiTable[i][j] = Double.parseDouble(res.get(6));
                    if (ilens[i] == null) {
                        ilens[i] = Integer.parseInt(res.get(0));
                    }
                    if (jlens[j] != null) continue;
                    jlens[j] = Integer.parseInt(res.get(1));
                }
            }
            if (maw != null) {
                maw.close();
            }
            if (this.self) {
                for (i = 0; i < ilist.size(); ++i) {
                    if (jlens[i] == null) {
                        jlens[i] = ilens[i];
                    }
                    if (ilens[i] == null) {
                        ilens[i] = jlens[i];
                    }
                    aaiTable[i][i] = 100.0;
                    hitTable[i][i] = ilens[i];
                    for (j = i + 1; j < jlist.size(); ++j) {
                        aaiTable[j][i] = aaiTable[i][j];
                        hitTable[j][i] = hitTable[i][j];
                    }
                }
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.output, this.outExists));
            if (!this.outExists) {
                bw.write("ID 1\tID 2\tLabel 1\tLabel 2\tAAI\tCDS count 1\tCDS count 2\tMatched count\tProteome cov.\tID param.\tCov. param.\n");
            }
            for (int i4 = 0; i4 < ilist.size(); ++i4) {
                for (int j3 = 0; j3 < jlist.size(); ++j3) {
                    bw.write(String.format("%d\t%d\t%s\t%s\t%f\t%d\t%d\t%d\t%f\t%f\t%f\n", Math.abs(((String)ilabs.get(i4)).hashCode()) % 0x40000000, Math.abs(((String)jlabs.get(j3)).hashCode()) % 0x40000000, ilabs.get(i4), jlabs.get(j3), aaiTable[i4][j3], ilens[i4], jlens[j3], hitTable[i4][j3], (double)hitTable[i4][j3].intValue() * 2.0 / (double)(ilens[i4] + jlens[j3]), this.identity, this.coverage));
                }
            }
            bw.close();
            if (this.mtxout != null) {
                BufferedWriter mw = new BufferedWriter(new FileWriter(this.mtxout));
                mw.write("%%MatrixMarket matrix array real general\n");
                mw.write(String.format("%d %d\n", ilist.size(), jlist.size()));
                for (int j4 = 0; j4 < jlist.size(); ++j4) {
                    for (int i5 = 0; i5 < ilist.size(); ++i5) {
                        mw.write(String.format("%f\n", aaiTable[i5][j4]));
                    }
                }
                mw.close();
            }
            FileUtils.deleteDirectory(faaDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        Prompt.print("Task finished.");
        return 0;
    }

    private int runCluster() {
        Prompt.debug("EzAAI - cluster module");
        HashMap<Integer, Integer> imap = new HashMap<Integer, Integer>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> bufs = new ArrayList<String>();
        try {
            String buf;
            BufferedReader br = new BufferedReader(new FileReader(this.input1));
            br.readLine();
            while ((buf = br.readLine()) != null) {
                bufs.add(buf);
                int id1 = Integer.parseInt(buf.split("\t")[0]);
                int id2 = Integer.parseInt(buf.split("\t")[1]);
                String lab1 = buf.split("\t")[2];
                String lab2 = buf.split("\t")[3];
                if (!imap.containsKey(id1)) {
                    imap.put(id1, labels.size());
                    ids.add(id1);
                    labels.add(lab1);
                }
                if (imap.containsKey(id2)) continue;
                imap.put(id2, labels.size());
                ids.add(id2);
                labels.add(lab2);
            }
            br.close();
        }
        catch (Exception e) {
            Prompt.error("Given file is incompatible. Input file must be the output of EzAAI calculate module.");
            return -1;
        }
        try {
            double[][] dmat = new double[labels.size()][labels.size()];
            for (int i = 0; i < labels.size(); ++i) {
                for (int j = 0; j < labels.size(); ++j) {
                    dmat[i][j] = i - j == 0 ? 0.0 : -1.0;
                }
            }
            for (String buf : bufs) {
                int i = (Integer)imap.get(Integer.parseInt(buf.split("\t")[0]));
                int j = (Integer)imap.get(Integer.parseInt(buf.split("\t")[1]));
                dmat[i][j] = 100.0 - Double.parseDouble(buf.split("\t")[4]);
            }
            boolean complete = true;
            for (int i = 0; i < labels.size() - 1; ++i) {
                if (dmat[i][i] > 0.0) {
                    complete = false;
                    Prompt.talk(String.format("INCOMPLETE DATA - Positive distance to iteslf: [%s]", labels.get(i)));
                }
                for (int j = i + 1; j < labels.size(); ++j) {
                    if (dmat[i][j] < 0.0) {
                        complete = false;
                        Prompt.talk(String.format("INCOMPLETE DATA - AAI value missing: [%s] vs. [%s]", labels.get(i), labels.get(j)));
                        continue;
                    }
                    if (!(dmat[j][i] < 0.0)) continue;
                    dmat[j][i] = dmat[i][j];
                }
            }
            if (!complete) {
                Prompt.error("Given values are incomplete. File should contain all-by-all pairwise AAI values from a group of taxa.");
                Prompt.error("To see the detailed error log, run the identical script with -v option.");
                return -1;
            }
            Prompt.print("AAI matrix identified. Running hierarchical clustering with UPGMA method...");
            ProcUPGMA upgma = new ProcUPGMA(dmat, ids, labels, this.useid);
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.output));
            bw.write(upgma.getTree() + "\n");
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        Prompt.print("Task finished.");
        return 0;
    }

    private int runConvertDB() {
        int ret = this.dbToFaa(this.input1, this.output);
        if (ret == 0) {
            new File("mm.label").delete();
            Prompt.print("Task finished.");
        }
        return ret;
    }

    private int run(String[] args) {
        if (this.parseArguments(args) < 0) {
            return -1;
        }
        switch (this.checkDependency(this.module, this.program)) {
            case 1: {
                Prompt.error("Failed to resolve MMSeqs2 binary. Please check the given path: " + ANSIHandler.wrapper(this.path_mmseqs, 'g'));
                return -1;
            }
            case 2: {
                Prompt.error("Failed to resolve DIAMOND binary. Please check the given path: " + ANSIHandler.wrapper(this.path_diamond, 'g'));
                return -1;
            }
            case 3: {
                Prompt.error("Failed to resolve BLASTp+ binary. Please check the given path: " + ANSIHandler.wrapper(this.path_blastp, 'g'));
                return -1;
            }
            case 4: {
                Prompt.error("Failed to resolve Prodigal binary. Please check the given path: " + ANSIHandler.wrapper(this.path_prodigal, 'g'));
                return -1;
            }
            case 5: {
                Prompt.error("Failed to resolve makeblastdb binary. Please check the given path: " + ANSIHandler.wrapper(this.path_blastdb, 'g'));
                return -1;
            }
            case 6: {
                Prompt.error("Failed to resolve ufasta binary. Multi-thread extraction requires ufasta binary.");
                Prompt.error("ufasta is available at: https://github.com/gmarcais/ufasta");
                return -1;
            }
        }
        switch (this.module) {
            case 1: {
                return this.runConvert();
            }
            case 2: {
                return this.runExtract();
            }
            case 3: {
                return this.runCalculate();
            }
            case 4: {
                return this.runCluster();
            }
            case 5: {
                return this.runConvertDB();
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            EzAAI.printHelp(0);
            return;
        }
        Arguments arg = new Arguments(args);
        if (arg.get("-v") != null) {
            GenericConfig.VERB = true;
        }
        if (arg.get("-dev") != null) {
            GenericConfig.VERB = true;
            GenericConfig.DEV = true;
        }
        if (arg.get("-nc") != null) {
            GenericConfig.NOCOLOR = true;
        }
        GenericConfig.TSTAMP = arg.get("-nt") == null;
        EzAAI ezAAI = new EzAAI(args[0]);
        if (arg.get("-h") != null) {
            EzAAI.printHelp(ezAAI.module);
            return;
        }
        if (ezAAI.module == 0) {
            Prompt.error("Invalid module given. Use -h option to get help.");
            return;
        }
        GenericConfig.setHeaderLength(7);
        GenericConfig.setHeader("EzAAI");
        Prompt.print(String.format("EzAAI - %s [%s]", VERSION, RELEASE));
        if (ezAAI.run(args) < 0) {
            Prompt.error("Program terminated with error.");
        }
    }

    private static void printHelp(int module) {
        String indent;
        if (module == 0) {
            System.out.println(ANSIHandler.wrapper(String.format("\n EzAAI - %s [%s]", VERSION, RELEASE), 'G'));
            System.out.println(ANSIHandler.wrapper(" High Throughput Prokaryotic Average Amino acid Identity Calculator", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Please cite:\n", 'C') + CITATION);
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar <module> [<args>]");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Available modules", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Module", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "extract", "Extract protein DB from genome using Prodigal");
            System.out.printf(" %-" + indent + "s%s%n", "convert", "Convert CDS FASTA file into protein DB");
            System.out.printf(" %-" + indent + "s%s%n", "convertdb", "Convert protein DB into FASTA file");
            System.out.printf(" %-" + indent + "s%s%n", "calculate", "Calculate AAI value from protein databases using MMSeqs2");
            System.out.printf(" %-" + indent + "s%s%n", "cluster", "Hierarchical clustering of taxa with AAI values");
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Miscellaneous", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-nc", "No-color mode");
            System.out.printf(" %-" + indent + "s%s%n", "-nt", "No time stamps");
            System.out.printf(" %-" + indent + "s%s%n", "-v", "Go verbose");
            System.out.printf(" %-" + indent + "s%s%n", "-h", "Print help");
            System.out.println();
        }
        if (module == 2) {
            System.out.println(ANSIHandler.wrapper("\n EzAAI - extract", 'G'));
            System.out.println(ANSIHandler.wrapper(" Extract protein DB from prokaryotic genome sequence using Prodigal", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar extract -i <IN_SEQ> -o <OUT_DB> [-l <LABEL> -t <THREAD>]");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Required options", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-i", "Input prokaryotic genome sequence");
            System.out.printf(" %-" + indent + "s%s%n", "-o", "Output protein database");
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Additional options", 'y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-l", "Taxonomic label for phylogenetic tree");
            System.out.printf(" %-" + indent + "s%s%n", "-t", "Number of CPU threads - multi-threading requires ufasta (default: 1)");
            System.out.printf(" %-" + indent + "s%s%n", "-tmp", "Custom temporary directory (default: /tmp/ezaai)");
            System.out.printf(" %-" + indent + "s%s%n", "-prodigal", "Custom path to prodigal binary (default: prodigal)");
            System.out.printf(" %-" + indent + "s%s%n", "-mmseqs", "Custom path to MMSeqs2 binary (default: mmseqs)");
            System.out.printf(" %-" + indent + "s%s%n", "-ufasta", "Custom path to ufasta binary (default: ufasta)");
            System.out.println();
        }
        if (module == 1) {
            System.out.println(ANSIHandler.wrapper("\n EzAAI - convert", 'G'));
            System.out.println(ANSIHandler.wrapper(" Convert CDS FASTA file into protein DB", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar convert -i <IN_CDS> -s <SEQ_TYPE> -o <OUT_DB> [-l <LABEL>]");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Required options", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-i", "Input CDS file (FASTA format)");
            System.out.printf(" %-" + indent + "s%s%n", "-s", "Sequence type of input file (nucl/prot)");
            System.out.printf(" %-" + indent + "s%s%n", "-o", "Output protein DB");
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Additional options", 'y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-l", "Taxonomic label for phylogenetic tree");
            System.out.printf(" %-" + indent + "s%s%n", "-tmp", "Custom temporary directory (default: /tmp/ezaai)");
            System.out.printf(" %-" + indent + "s%s%n", "-mmseqs", "Custom path to MMSeqs2 binary (default: mmseqs)");
            System.out.println();
        }
        if (module == 3) {
            System.out.println(ANSIHandler.wrapper("\n EzAAI - calculate", 'G'));
            System.out.println(ANSIHandler.wrapper(" Calculate AAI value from protein databases", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar calculate -i <INPUT_1> -j <INPUT_2> -o <OUTPUT> [-p <PROGRAM> -t <THREAD> -id <IDENTITY> -cov <COVERAGE> -mtx <MTX_OUTPUT>]");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Required options", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-i      ", "First input protein DB / directory with protein DBs");
            System.out.printf(" %-" + indent + "s%s%n", "-j      ", "Second input protein DB / directory with protein DBs");
            System.out.printf(" %-" + indent + "s%s%n", "-o      ", "Output result file");
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Additional options", 'y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-p      ", "Customize calculation program [mmseqs / diamond / blastp] (default: mmseqs)");
            System.out.printf(" %-" + indent + "s%s%n", "-t      ", "Number of CPU threads to use (default: 10)");
            System.out.printf(" %-" + indent + "s%s%n", "-tmp    ", "Custom temporary directory (default: /tmp/ezaai)");
            System.out.printf(" %-" + indent + "s%s%n", "-self   ", "Assume self-comparison; -i and -j must be identical [0 / 1] (default: 0)");
            System.out.printf(" %-" + indent + "s%s%n", "-id     ", "Minimum identity threshold for AAI calculations [0 - 1.0] (default: 0.4)");
            System.out.printf(" %-" + indent + "s%s%n", "-cov    ", "Minimum query coverage threshold for AAI calculations [0 - 1.0] (default: 0.5)");
            System.out.printf(" %-" + indent + "s%s%n", "-match  ", "Path to write a result of matched CDS names");
            System.out.printf(" %-" + indent + "s%s%n", "-mtx    ", "Path to write a Matrix Market formatted output");
            System.out.printf(" %-" + indent + "s%s%n", "-mmseqs ", "Custom path to MMSeqs2 binary (default: mmseqs)");
            System.out.printf(" %-" + indent + "s%s%n", "-diamond", "Custom path to DIAMOND binary (default: diamond)");
            System.out.printf(" %-" + indent + "s%s%n", "-blastp ", "Custom path to BLASTp+ binary (default: blastp)");
            System.out.printf(" %-" + indent + "s%s%n", "-blastdb", "Custom path to makeblastdb binary (default: makeblastdb)");
            System.out.println();
        }
        if (module == 4) {
            System.out.println(ANSIHandler.wrapper("\n EzAAI - cluster", 'G'));
            System.out.println(ANSIHandler.wrapper(" Hierarchical clustering of taxa with AAI values", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar cluster -i <AAI_TABLE> -o <OUTPUT>");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Required options", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-i", "Input EzAAI result file containing all-by-all pairwise AAI values");
            System.out.printf(" %-" + indent + "s%s%n", "-o", "Output result file");
            System.out.printf(" %-" + indent + "s%s%n", "-u", "Use ID instead of label for tree");
            System.out.println();
        }
        if (module == 5) {
            System.out.println(ANSIHandler.wrapper("\n EzAAI - convertdb", 'G'));
            System.out.println(ANSIHandler.wrapper(" Convert protein DB into FASTA file", 'g'));
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n USAGE:", 'Y') + " java -jar EzAAI.jar convertdb -i <IN_DB> -o <OUT_FA>");
            System.out.println();
            indent = String.valueOf(15);
            System.out.println(ANSIHandler.wrapper("\n Required options", 'Y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-i", "Input protein DB");
            System.out.printf(" %-" + indent + "s%s%n", "-o", "Output FASTA file");
            System.out.println();
            System.out.println(ANSIHandler.wrapper("\n Additional options", 'y'));
            System.out.println(ANSIHandler.wrapper(String.format(" %-" + indent + "s%s", "Argument", "Description"), 'c'));
            System.out.printf(" %-" + indent + "s%s%n", "-tmp", "Custom temporary directory (default: /tmp/ezaai)");
            System.out.printf(" %-" + indent + "s%s%n", "-mmseqs", "Custom path to MMSeqs2 binary (default: mmseqs)");
            System.out.println();
        }
    }
}

